/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.oasis.Style;
import net.sf.jasperreports.engine.util.JRColorUtil;

public abstract class BorderStyle
extends Style {
    private static final String[] border = new String[]{"top", "left", "bottom", "right"};
    protected static final int TOP_BORDER = 0;
    protected static final int LEFT_BORDER = 1;
    protected static final int BOTTOM_BORDER = 2;
    protected static final int RIGHT_BORDER = 3;
    private String[] borderColor = new String[4];
    private String[] borderWidth = new String[4];
    private String[] borderStyle = new String[4];
    private String[] borderPadding = new String[4];

    public BorderStyle(Writer styleWriter) {
        super(styleWriter);
    }

    public void setBox(JRLineBox box) {
        if (box != null) {
            this.appendBorder(box.getTopPen(), 0);
            this.borderPadding[0] = String.valueOf(LengthUtil.inchNoRound(box.getTopPadding().intValue()));
            this.appendBorder(box.getLeftPen(), 1);
            this.borderPadding[1] = String.valueOf(LengthUtil.inchNoRound(box.getLeftPadding().intValue()));
            this.appendBorder(box.getBottomPen(), 2);
            this.borderPadding[2] = String.valueOf(LengthUtil.inchNoRound(box.getBottomPadding().intValue()));
            this.appendBorder(box.getRightPen(), 3);
            this.borderPadding[3] = String.valueOf(LengthUtil.inchNoRound(box.getRightPadding().intValue()));
        }
    }

    public void setPen(JRPen pen) {
        if (this.borderWidth[0] == null && this.borderWidth[1] == null && this.borderWidth[2] == null && this.borderWidth[3] == null) {
            this.appendBorder(pen, 0);
            this.appendBorder(pen, 1);
            this.appendBorder(pen, 2);
            this.appendBorder(pen, 3);
        }
    }

    public String getId() {
        return this.borderWidth[0] + "|" + this.borderColor[0] + "|" + this.borderStyle[0] + "|" + this.borderPadding[0] + "|" + this.borderWidth[1] + "|" + this.borderColor[1] + "|" + this.borderStyle[1] + "|" + this.borderPadding[1] + "|" + this.borderWidth[2] + "|" + this.borderColor[2] + "|" + this.borderStyle[2] + "|" + this.borderPadding[2] + "|" + this.borderWidth[3] + "|" + this.borderColor[3] + "|" + this.borderStyle[3] + "|" + this.borderPadding[3];
    }

    protected void writeBorder(int side) throws IOException {
        if (this.borderWidth[side] != null) {
            this.styleWriter.write(" fo:border-");
            this.styleWriter.write(border[side]);
            this.styleWriter.write("=\"");
            this.styleWriter.write(this.borderWidth[side]);
            this.styleWriter.write("in ");
            this.styleWriter.write(this.borderStyle[side]);
            this.styleWriter.write(" #");
            this.styleWriter.write(this.borderColor[side]);
            this.styleWriter.write("\"");
        }
        if (this.borderPadding[side] != null) {
            this.styleWriter.write(" fo:padding-");
            this.styleWriter.write(border[side]);
            this.styleWriter.write("=\"");
            this.styleWriter.write(this.borderPadding[side]);
            this.styleWriter.write("in\"");
        }
    }

    private void appendBorder(JRPen pen, int side) {
        double width = pen.getLineWidth().doubleValue();
        String style = null;
        if (width > 0.0) {
            switch (pen.getLineStyleValue()) {
                case DOTTED: {
                    style = "dotted";
                    break;
                }
                case DASHED: {
                    style = "dashed";
                    break;
                }
                default: {
                    style = "solid";
                }
            }
            this.borderWidth[side] = String.valueOf(LengthUtil.inchNoRound(width));
        } else {
            style = "none";
        }
        this.borderStyle[side] = style;
        this.borderColor[side] = JRColorUtil.getColorHexa(pen.getLineColor());
    }
}

