/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.12
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.gnu.glpk;


  /**
   * The intermediary JNI class.
   * Loads the native library.
   */
   public class GLPKJNI {

  static {
    try {
      if (System.getProperty("os.name").toLowerCase().contains("windows")) {
        // try to load Windows libraries


        try {
          System.loadLibrary("glpk_4_60");
        } catch (UnsatisfiedLinkError e) {
          // The dependent library might be in the OS library search path.
        }


        System.loadLibrary("glpk_4_60_java");
      } else {
        // try to load Linux library


        try {
          System.loadLibrary("glpk");
        } catch (UnsatisfiedLinkError e) {
          // The dependent library might be in the OS library search path.
        }


        System.loadLibrary("glpk_java");
      }
    } catch (UnsatisfiedLinkError e) {
      /**
       * Information string.
       */
      String info = "\n"
        + "The dynamic link library for GLPK for Java could not be "
        + "loaded.\nConsider using\njava -Djava.library.path=\n"
        + "The current value of system property java.library.path is:\n"
        + System.getProperty("java.library.path") + "\n\n";

      try {
          /**
           * Number of bits.
           */
          String bits = null;

          bits = System.getProperty("com.ibm.vm.bitmode");
          if (bits == null) {
              bits = System.getProperty("sun.arch.data.model");
          }

          info +=
            "java.vendor: " + System.getProperty("java.vendor")
            + "\njava.version: "
            + System.getProperty("java.version")
            + "\njava.vm.name: "
            + System.getProperty("java.vm.name")
            + "\njava.vm.version: "
            + System.getProperty("java.vm.version")
            + "\njava.runtime.version: "
            + System.getProperty("java.runtime.version");
          if (bits != null) {
              info += "\ndata model: " + bits + " bit";
          }
      } catch (SecurityException ex) {
          info += "\n\n";
          info += ex.getMessage();
      }
      info += "\n";
      System.err.println(info);
      throw e;  
    }
  }

  public final static native long new_intArray(int jarg1);
  public final static native void delete_intArray(long jarg1);
  public final static native int intArray_getitem(long jarg1, int jarg2);
  public final static native void intArray_setitem(long jarg1, int jarg2, int jarg3);
  public final static native long new_doubleArray(int jarg1);
  public final static native void delete_doubleArray(long jarg1);
  public final static native double doubleArray_getitem(long jarg1, int jarg2);
  public final static native void doubleArray_setitem(long jarg1, int jarg2, double jarg3);
  public final static native int GLP_JAVA_A_CAP_get();
  public final static native int GLP_JAVA_A_COST_get();
  public final static native int GLP_JAVA_A_LOW_get();
  public final static native int GLP_JAVA_A_RC_get();
  public final static native int GLP_JAVA_A_X_get();
  public final static native int GLP_JAVA_A_SIZE_get();
  public final static native int GLP_JAVA_V_CUT_get();
  public final static native int GLP_JAVA_V_PI_get();
  public final static native int GLP_JAVA_V_RHS_get();
  public final static native int GLP_JAVA_V_SET_get();
  public final static native int GLP_JAVA_V_SIZE_get();
  public final static native int GLP_JAVA_MSG_LVL_OFF_get();
  public final static native int GLP_JAVA_MSG_LVL_ALL_get();
  public final static native void glp_java_error(String jarg1);
  public final static native void glp_java_set_msg_lvl(int jarg1);
  public final static native void glp_java_set_numeric_locale(String jarg1);
  public final static native void glp_java_arc_data_cap_set(long jarg1, glp_java_arc_data jarg1_, double jarg2);
  public final static native double glp_java_arc_data_cap_get(long jarg1, glp_java_arc_data jarg1_);
  public final static native void glp_java_arc_data_cost_set(long jarg1, glp_java_arc_data jarg1_, double jarg2);
  public final static native double glp_java_arc_data_cost_get(long jarg1, glp_java_arc_data jarg1_);
  public final static native void glp_java_arc_data_low_set(long jarg1, glp_java_arc_data jarg1_, double jarg2);
  public final static native double glp_java_arc_data_low_get(long jarg1, glp_java_arc_data jarg1_);
  public final static native void glp_java_arc_data_rc_set(long jarg1, glp_java_arc_data jarg1_, double jarg2);
  public final static native double glp_java_arc_data_rc_get(long jarg1, glp_java_arc_data jarg1_);
  public final static native void glp_java_arc_data_x_set(long jarg1, glp_java_arc_data jarg1_, double jarg2);
  public final static native double glp_java_arc_data_x_get(long jarg1, glp_java_arc_data jarg1_);
  public final static native long new_glp_java_arc_data();
  public final static native void delete_glp_java_arc_data(long jarg1);
  public final static native void glp_java_vertex_data_cut_set(long jarg1, glp_java_vertex_data jarg1_, int jarg2);
  public final static native int glp_java_vertex_data_cut_get(long jarg1, glp_java_vertex_data jarg1_);
  public final static native void glp_java_vertex_data_pi_set(long jarg1, glp_java_vertex_data jarg1_, double jarg2);
  public final static native double glp_java_vertex_data_pi_get(long jarg1, glp_java_vertex_data jarg1_);
  public final static native void glp_java_vertex_data_rhs_set(long jarg1, glp_java_vertex_data jarg1_, double jarg2);
  public final static native double glp_java_vertex_data_rhs_get(long jarg1, glp_java_vertex_data jarg1_);
  public final static native void glp_java_vertex_data_set_set(long jarg1, glp_java_vertex_data jarg1_, int jarg2);
  public final static native int glp_java_vertex_data_set_get(long jarg1, glp_java_vertex_data jarg1_);
  public final static native long new_glp_java_vertex_data();
  public final static native void delete_glp_java_vertex_data(long jarg1);
  public final static native long glp_java_arc_get_data(long jarg1, glp_arc jarg1_);
  public final static native long glp_java_vertex_data_get(long jarg1, glp_graph jarg1_, int jarg2);
  public final static native long glp_java_vertex_get_data(long jarg1, glp_vertex jarg1_);
  public final static native long glp_java_vertex_get(long jarg1, glp_graph jarg1_, int jarg2);
  public final static native void glp_prob_hidden_internal_set(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native int glp_prob_hidden_internal_get(long jarg1, glp_prob jarg1_);
  public final static native long new_glp_prob();
  public final static native void delete_glp_prob(long jarg1);
  public final static native void glp_tran_hidden_internal_set(long jarg1, glp_tran jarg1_, int jarg2);
  public final static native int glp_tran_hidden_internal_get(long jarg1, glp_tran jarg1_);
  public final static native long new_glp_tran();
  public final static native void delete_glp_tran(long jarg1);
  public final static native void glp_tree_hidden_internal_set(long jarg1, glp_tree jarg1_, int jarg2);
  public final static native int glp_tree_hidden_internal_get(long jarg1, glp_tree jarg1_);
  public final static native long new_glp_tree();
  public final static native void delete_glp_tree(long jarg1);
  public final static native int GLP_MAJOR_VERSION_get();
  public final static native int GLP_MINOR_VERSION_get();
  public final static native int GLP_MIN_get();
  public final static native int GLP_MAX_get();
  public final static native int GLP_CV_get();
  public final static native int GLP_IV_get();
  public final static native int GLP_BV_get();
  public final static native int GLP_FR_get();
  public final static native int GLP_LO_get();
  public final static native int GLP_UP_get();
  public final static native int GLP_DB_get();
  public final static native int GLP_FX_get();
  public final static native int GLP_BS_get();
  public final static native int GLP_NL_get();
  public final static native int GLP_NU_get();
  public final static native int GLP_NF_get();
  public final static native int GLP_NS_get();
  public final static native int GLP_SF_GM_get();
  public final static native int GLP_SF_EQ_get();
  public final static native int GLP_SF_2N_get();
  public final static native int GLP_SF_SKIP_get();
  public final static native int GLP_SF_AUTO_get();
  public final static native int GLP_SOL_get();
  public final static native int GLP_IPT_get();
  public final static native int GLP_MIP_get();
  public final static native int GLP_UNDEF_get();
  public final static native int GLP_FEAS_get();
  public final static native int GLP_INFEAS_get();
  public final static native int GLP_NOFEAS_get();
  public final static native int GLP_OPT_get();
  public final static native int GLP_UNBND_get();
  public final static native void glp_bfcp_msg_lev_set(long jarg1, glp_bfcp jarg1_, int jarg2);
  public final static native int glp_bfcp_msg_lev_get(long jarg1, glp_bfcp jarg1_);
  public final static native void glp_bfcp_type_set(long jarg1, glp_bfcp jarg1_, int jarg2);
  public final static native int glp_bfcp_type_get(long jarg1, glp_bfcp jarg1_);
  public final static native int GLP_BF_LUF_get();
  public final static native int GLP_BF_BTF_get();
  public final static native int GLP_BF_FT_get();
  public final static native int GLP_BF_BG_get();
  public final static native int GLP_BF_GR_get();
  public final static native void glp_bfcp_lu_size_set(long jarg1, glp_bfcp jarg1_, int jarg2);
  public final static native int glp_bfcp_lu_size_get(long jarg1, glp_bfcp jarg1_);
  public final static native void glp_bfcp_piv_tol_set(long jarg1, glp_bfcp jarg1_, double jarg2);
  public final static native double glp_bfcp_piv_tol_get(long jarg1, glp_bfcp jarg1_);
  public final static native void glp_bfcp_piv_lim_set(long jarg1, glp_bfcp jarg1_, int jarg2);
  public final static native int glp_bfcp_piv_lim_get(long jarg1, glp_bfcp jarg1_);
  public final static native void glp_bfcp_suhl_set(long jarg1, glp_bfcp jarg1_, int jarg2);
  public final static native int glp_bfcp_suhl_get(long jarg1, glp_bfcp jarg1_);
  public final static native void glp_bfcp_eps_tol_set(long jarg1, glp_bfcp jarg1_, double jarg2);
  public final static native double glp_bfcp_eps_tol_get(long jarg1, glp_bfcp jarg1_);
  public final static native void glp_bfcp_max_gro_set(long jarg1, glp_bfcp jarg1_, double jarg2);
  public final static native double glp_bfcp_max_gro_get(long jarg1, glp_bfcp jarg1_);
  public final static native void glp_bfcp_nfs_max_set(long jarg1, glp_bfcp jarg1_, int jarg2);
  public final static native int glp_bfcp_nfs_max_get(long jarg1, glp_bfcp jarg1_);
  public final static native void glp_bfcp_upd_tol_set(long jarg1, glp_bfcp jarg1_, double jarg2);
  public final static native double glp_bfcp_upd_tol_get(long jarg1, glp_bfcp jarg1_);
  public final static native void glp_bfcp_nrs_max_set(long jarg1, glp_bfcp jarg1_, int jarg2);
  public final static native int glp_bfcp_nrs_max_get(long jarg1, glp_bfcp jarg1_);
  public final static native void glp_bfcp_rs_size_set(long jarg1, glp_bfcp jarg1_, int jarg2);
  public final static native int glp_bfcp_rs_size_get(long jarg1, glp_bfcp jarg1_);
  public final static native void glp_bfcp_foo_bar_set(long jarg1, glp_bfcp jarg1_, long jarg2);
  public final static native long glp_bfcp_foo_bar_get(long jarg1, glp_bfcp jarg1_);
  public final static native long new_glp_bfcp();
  public final static native void delete_glp_bfcp(long jarg1);
  public final static native void glp_smcp_msg_lev_set(long jarg1, glp_smcp jarg1_, int jarg2);
  public final static native int glp_smcp_msg_lev_get(long jarg1, glp_smcp jarg1_);
  public final static native int GLP_MSG_OFF_get();
  public final static native int GLP_MSG_ERR_get();
  public final static native int GLP_MSG_ON_get();
  public final static native int GLP_MSG_ALL_get();
  public final static native int GLP_MSG_DBG_get();
  public final static native void glp_smcp_meth_set(long jarg1, glp_smcp jarg1_, int jarg2);
  public final static native int glp_smcp_meth_get(long jarg1, glp_smcp jarg1_);
  public final static native int GLP_PRIMAL_get();
  public final static native int GLP_DUALP_get();
  public final static native int GLP_DUAL_get();
  public final static native void glp_smcp_pricing_set(long jarg1, glp_smcp jarg1_, int jarg2);
  public final static native int glp_smcp_pricing_get(long jarg1, glp_smcp jarg1_);
  public final static native int GLP_PT_STD_get();
  public final static native int GLP_PT_PSE_get();
  public final static native void glp_smcp_r_test_set(long jarg1, glp_smcp jarg1_, int jarg2);
  public final static native int glp_smcp_r_test_get(long jarg1, glp_smcp jarg1_);
  public final static native int GLP_RT_STD_get();
  public final static native int GLP_RT_HAR_get();
  public final static native void glp_smcp_tol_bnd_set(long jarg1, glp_smcp jarg1_, double jarg2);
  public final static native double glp_smcp_tol_bnd_get(long jarg1, glp_smcp jarg1_);
  public final static native void glp_smcp_tol_dj_set(long jarg1, glp_smcp jarg1_, double jarg2);
  public final static native double glp_smcp_tol_dj_get(long jarg1, glp_smcp jarg1_);
  public final static native void glp_smcp_tol_piv_set(long jarg1, glp_smcp jarg1_, double jarg2);
  public final static native double glp_smcp_tol_piv_get(long jarg1, glp_smcp jarg1_);
  public final static native void glp_smcp_obj_ll_set(long jarg1, glp_smcp jarg1_, double jarg2);
  public final static native double glp_smcp_obj_ll_get(long jarg1, glp_smcp jarg1_);
  public final static native void glp_smcp_obj_ul_set(long jarg1, glp_smcp jarg1_, double jarg2);
  public final static native double glp_smcp_obj_ul_get(long jarg1, glp_smcp jarg1_);
  public final static native void glp_smcp_it_lim_set(long jarg1, glp_smcp jarg1_, int jarg2);
  public final static native int glp_smcp_it_lim_get(long jarg1, glp_smcp jarg1_);
  public final static native void glp_smcp_tm_lim_set(long jarg1, glp_smcp jarg1_, int jarg2);
  public final static native int glp_smcp_tm_lim_get(long jarg1, glp_smcp jarg1_);
  public final static native void glp_smcp_out_frq_set(long jarg1, glp_smcp jarg1_, int jarg2);
  public final static native int glp_smcp_out_frq_get(long jarg1, glp_smcp jarg1_);
  public final static native void glp_smcp_out_dly_set(long jarg1, glp_smcp jarg1_, int jarg2);
  public final static native int glp_smcp_out_dly_get(long jarg1, glp_smcp jarg1_);
  public final static native void glp_smcp_presolve_set(long jarg1, glp_smcp jarg1_, int jarg2);
  public final static native int glp_smcp_presolve_get(long jarg1, glp_smcp jarg1_);
  public final static native void glp_smcp_foo_bar_set(long jarg1, glp_smcp jarg1_, long jarg2);
  public final static native long glp_smcp_foo_bar_get(long jarg1, glp_smcp jarg1_);
  public final static native long new_glp_smcp();
  public final static native void delete_glp_smcp(long jarg1);
  public final static native void glp_iptcp_msg_lev_set(long jarg1, glp_iptcp jarg1_, int jarg2);
  public final static native int glp_iptcp_msg_lev_get(long jarg1, glp_iptcp jarg1_);
  public final static native void glp_iptcp_ord_alg_set(long jarg1, glp_iptcp jarg1_, int jarg2);
  public final static native int glp_iptcp_ord_alg_get(long jarg1, glp_iptcp jarg1_);
  public final static native int GLP_ORD_NONE_get();
  public final static native int GLP_ORD_QMD_get();
  public final static native int GLP_ORD_AMD_get();
  public final static native int GLP_ORD_SYMAMD_get();
  public final static native void glp_iptcp_foo_bar_set(long jarg1, glp_iptcp jarg1_, long jarg2);
  public final static native long glp_iptcp_foo_bar_get(long jarg1, glp_iptcp jarg1_);
  public final static native long new_glp_iptcp();
  public final static native void delete_glp_iptcp(long jarg1);
  public final static native void glp_iocp_msg_lev_set(long jarg1, glp_iocp jarg1_, int jarg2);
  public final static native int glp_iocp_msg_lev_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_br_tech_set(long jarg1, glp_iocp jarg1_, int jarg2);
  public final static native int glp_iocp_br_tech_get(long jarg1, glp_iocp jarg1_);
  public final static native int GLP_BR_FFV_get();
  public final static native int GLP_BR_LFV_get();
  public final static native int GLP_BR_MFV_get();
  public final static native int GLP_BR_DTH_get();
  public final static native int GLP_BR_PCH_get();
  public final static native void glp_iocp_bt_tech_set(long jarg1, glp_iocp jarg1_, int jarg2);
  public final static native int glp_iocp_bt_tech_get(long jarg1, glp_iocp jarg1_);
  public final static native int GLP_BT_DFS_get();
  public final static native int GLP_BT_BFS_get();
  public final static native int GLP_BT_BLB_get();
  public final static native int GLP_BT_BPH_get();
  public final static native void glp_iocp_tol_int_set(long jarg1, glp_iocp jarg1_, double jarg2);
  public final static native double glp_iocp_tol_int_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_tol_obj_set(long jarg1, glp_iocp jarg1_, double jarg2);
  public final static native double glp_iocp_tol_obj_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_tm_lim_set(long jarg1, glp_iocp jarg1_, int jarg2);
  public final static native int glp_iocp_tm_lim_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_out_frq_set(long jarg1, glp_iocp jarg1_, int jarg2);
  public final static native int glp_iocp_out_frq_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_out_dly_set(long jarg1, glp_iocp jarg1_, int jarg2);
  public final static native int glp_iocp_out_dly_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_cb_func_set(long jarg1, glp_iocp jarg1_, long jarg2);
  public final static native long glp_iocp_cb_func_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_cb_info_set(long jarg1, glp_iocp jarg1_, long jarg2);
  public final static native long glp_iocp_cb_info_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_cb_size_set(long jarg1, glp_iocp jarg1_, int jarg2);
  public final static native int glp_iocp_cb_size_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_pp_tech_set(long jarg1, glp_iocp jarg1_, int jarg2);
  public final static native int glp_iocp_pp_tech_get(long jarg1, glp_iocp jarg1_);
  public final static native int GLP_PP_NONE_get();
  public final static native int GLP_PP_ROOT_get();
  public final static native int GLP_PP_ALL_get();
  public final static native void glp_iocp_mip_gap_set(long jarg1, glp_iocp jarg1_, double jarg2);
  public final static native double glp_iocp_mip_gap_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_mir_cuts_set(long jarg1, glp_iocp jarg1_, int jarg2);
  public final static native int glp_iocp_mir_cuts_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_gmi_cuts_set(long jarg1, glp_iocp jarg1_, int jarg2);
  public final static native int glp_iocp_gmi_cuts_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_cov_cuts_set(long jarg1, glp_iocp jarg1_, int jarg2);
  public final static native int glp_iocp_cov_cuts_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_clq_cuts_set(long jarg1, glp_iocp jarg1_, int jarg2);
  public final static native int glp_iocp_clq_cuts_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_presolve_set(long jarg1, glp_iocp jarg1_, int jarg2);
  public final static native int glp_iocp_presolve_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_binarize_set(long jarg1, glp_iocp jarg1_, int jarg2);
  public final static native int glp_iocp_binarize_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_fp_heur_set(long jarg1, glp_iocp jarg1_, int jarg2);
  public final static native int glp_iocp_fp_heur_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_ps_heur_set(long jarg1, glp_iocp jarg1_, int jarg2);
  public final static native int glp_iocp_ps_heur_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_ps_tm_lim_set(long jarg1, glp_iocp jarg1_, int jarg2);
  public final static native int glp_iocp_ps_tm_lim_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_use_sol_set(long jarg1, glp_iocp jarg1_, int jarg2);
  public final static native int glp_iocp_use_sol_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_save_sol_set(long jarg1, glp_iocp jarg1_, String jarg2);
  public final static native String glp_iocp_save_sol_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_alien_set(long jarg1, glp_iocp jarg1_, int jarg2);
  public final static native int glp_iocp_alien_get(long jarg1, glp_iocp jarg1_);
  public final static native void glp_iocp_foo_bar_set(long jarg1, glp_iocp jarg1_, long jarg2);
  public final static native long glp_iocp_foo_bar_get(long jarg1, glp_iocp jarg1_);
  public final static native long new_glp_iocp();
  public final static native void delete_glp_iocp(long jarg1);
  public final static native void glp_attr_level_set(long jarg1, glp_attr jarg1_, int jarg2);
  public final static native int glp_attr_level_get(long jarg1, glp_attr jarg1_);
  public final static native void glp_attr_origin_set(long jarg1, glp_attr jarg1_, int jarg2);
  public final static native int glp_attr_origin_get(long jarg1, glp_attr jarg1_);
  public final static native int GLP_RF_REG_get();
  public final static native int GLP_RF_LAZY_get();
  public final static native int GLP_RF_CUT_get();
  public final static native void glp_attr_klass_set(long jarg1, glp_attr jarg1_, int jarg2);
  public final static native int glp_attr_klass_get(long jarg1, glp_attr jarg1_);
  public final static native int GLP_RF_GMI_get();
  public final static native int GLP_RF_MIR_get();
  public final static native int GLP_RF_COV_get();
  public final static native int GLP_RF_CLQ_get();
  public final static native void glp_attr_foo_bar_set(long jarg1, glp_attr jarg1_, long jarg2);
  public final static native long glp_attr_foo_bar_get(long jarg1, glp_attr jarg1_);
  public final static native long new_glp_attr();
  public final static native void delete_glp_attr(long jarg1);
  public final static native int GLP_ON_get();
  public final static native int GLP_OFF_get();
  public final static native int GLP_IROWGEN_get();
  public final static native int GLP_IBINGO_get();
  public final static native int GLP_IHEUR_get();
  public final static native int GLP_ICUTGEN_get();
  public final static native int GLP_IBRANCH_get();
  public final static native int GLP_ISELECT_get();
  public final static native int GLP_IPREPRO_get();
  public final static native int GLP_NO_BRNCH_get();
  public final static native int GLP_DN_BRNCH_get();
  public final static native int GLP_UP_BRNCH_get();
  public final static native int GLP_EBADB_get();
  public final static native int GLP_ESING_get();
  public final static native int GLP_ECOND_get();
  public final static native int GLP_EBOUND_get();
  public final static native int GLP_EFAIL_get();
  public final static native int GLP_EOBJLL_get();
  public final static native int GLP_EOBJUL_get();
  public final static native int GLP_EITLIM_get();
  public final static native int GLP_ETMLIM_get();
  public final static native int GLP_ENOPFS_get();
  public final static native int GLP_ENODFS_get();
  public final static native int GLP_EROOT_get();
  public final static native int GLP_ESTOP_get();
  public final static native int GLP_EMIPGAP_get();
  public final static native int GLP_ENOFEAS_get();
  public final static native int GLP_ENOCVG_get();
  public final static native int GLP_EINSTAB_get();
  public final static native int GLP_EDATA_get();
  public final static native int GLP_ERANGE_get();
  public final static native int GLP_KKT_PE_get();
  public final static native int GLP_KKT_PB_get();
  public final static native int GLP_KKT_DE_get();
  public final static native int GLP_KKT_DB_get();
  public final static native int GLP_KKT_CS_get();
  public final static native int GLP_MPS_DECK_get();
  public final static native int GLP_MPS_FILE_get();
  public final static native void glp_mpscp_blank_set(long jarg1, glp_mpscp jarg1_, int jarg2);
  public final static native int glp_mpscp_blank_get(long jarg1, glp_mpscp jarg1_);
  public final static native void glp_mpscp_obj_name_set(long jarg1, glp_mpscp jarg1_, String jarg2);
  public final static native String glp_mpscp_obj_name_get(long jarg1, glp_mpscp jarg1_);
  public final static native void glp_mpscp_tol_mps_set(long jarg1, glp_mpscp jarg1_, double jarg2);
  public final static native double glp_mpscp_tol_mps_get(long jarg1, glp_mpscp jarg1_);
  public final static native void glp_mpscp_foo_bar_set(long jarg1, glp_mpscp jarg1_, long jarg2);
  public final static native long glp_mpscp_foo_bar_get(long jarg1, glp_mpscp jarg1_);
  public final static native long new_glp_mpscp();
  public final static native void delete_glp_mpscp(long jarg1);
  public final static native void glp_cpxcp_foo_bar_set(long jarg1, glp_cpxcp jarg1_, long jarg2);
  public final static native long glp_cpxcp_foo_bar_get(long jarg1, glp_cpxcp jarg1_);
  public final static native long new_glp_cpxcp();
  public final static native void delete_glp_cpxcp(long jarg1);
  public final static native long glp_create_prob();
  public final static native void glp_set_prob_name(long jarg1, glp_prob jarg1_, String jarg2);
  public final static native void glp_set_obj_name(long jarg1, glp_prob jarg1_, String jarg2);
  public final static native void glp_set_obj_dir(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native int glp_add_rows(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native int glp_add_cols(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native void glp_set_row_name(long jarg1, glp_prob jarg1_, int jarg2, String jarg3);
  public final static native void glp_set_col_name(long jarg1, glp_prob jarg1_, int jarg2, String jarg3);
  public final static native void glp_set_row_bnds(long jarg1, glp_prob jarg1_, int jarg2, int jarg3, double jarg4, double jarg5);
  public final static native void glp_set_col_bnds(long jarg1, glp_prob jarg1_, int jarg2, int jarg3, double jarg4, double jarg5);
  public final static native void glp_set_obj_coef(long jarg1, glp_prob jarg1_, int jarg2, double jarg3);
  public final static native void glp_set_mat_row(long jarg1, glp_prob jarg1_, int jarg2, int jarg3, long jarg4, long jarg5);
  public final static native void glp_set_mat_col(long jarg1, glp_prob jarg1_, int jarg2, int jarg3, long jarg4, long jarg5);
  public final static native void glp_load_matrix(long jarg1, glp_prob jarg1_, int jarg2, long jarg3, long jarg4, long jarg5);
  public final static native int glp_check_dup(int jarg1, int jarg2, int jarg3, long jarg4, long jarg5);
  public final static native void glp_sort_matrix(long jarg1, glp_prob jarg1_);
  public final static native void glp_del_rows(long jarg1, glp_prob jarg1_, int jarg2, long jarg3);
  public final static native void glp_del_cols(long jarg1, glp_prob jarg1_, int jarg2, long jarg3);
  public final static native void glp_copy_prob(long jarg1, glp_prob jarg1_, long jarg2, glp_prob jarg2_, int jarg3);
  public final static native void glp_erase_prob(long jarg1, glp_prob jarg1_);
  public final static native void glp_delete_prob(long jarg1, glp_prob jarg1_);
  public final static native String glp_get_prob_name(long jarg1, glp_prob jarg1_);
  public final static native String glp_get_obj_name(long jarg1, glp_prob jarg1_);
  public final static native int glp_get_obj_dir(long jarg1, glp_prob jarg1_);
  public final static native int glp_get_num_rows(long jarg1, glp_prob jarg1_);
  public final static native int glp_get_num_cols(long jarg1, glp_prob jarg1_);
  public final static native String glp_get_row_name(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native String glp_get_col_name(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native int glp_get_row_type(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native double glp_get_row_lb(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native double glp_get_row_ub(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native int glp_get_col_type(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native double glp_get_col_lb(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native double glp_get_col_ub(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native double glp_get_obj_coef(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native int glp_get_num_nz(long jarg1, glp_prob jarg1_);
  public final static native int glp_get_mat_row(long jarg1, glp_prob jarg1_, int jarg2, long jarg3, long jarg4);
  public final static native int glp_get_mat_col(long jarg1, glp_prob jarg1_, int jarg2, long jarg3, long jarg4);
  public final static native void glp_create_index(long jarg1, glp_prob jarg1_);
  public final static native int glp_find_row(long jarg1, glp_prob jarg1_, String jarg2);
  public final static native int glp_find_col(long jarg1, glp_prob jarg1_, String jarg2);
  public final static native void glp_delete_index(long jarg1, glp_prob jarg1_);
  public final static native void glp_set_rii(long jarg1, glp_prob jarg1_, int jarg2, double jarg3);
  public final static native void glp_set_sjj(long jarg1, glp_prob jarg1_, int jarg2, double jarg3);
  public final static native double glp_get_rii(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native double glp_get_sjj(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native void glp_scale_prob(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native void glp_unscale_prob(long jarg1, glp_prob jarg1_);
  public final static native void glp_set_row_stat(long jarg1, glp_prob jarg1_, int jarg2, int jarg3);
  public final static native void glp_set_col_stat(long jarg1, glp_prob jarg1_, int jarg2, int jarg3);
  public final static native void glp_std_basis(long jarg1, glp_prob jarg1_);
  public final static native void glp_adv_basis(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native void glp_cpx_basis(long jarg1, glp_prob jarg1_);
  public final static native int glp_simplex(long jarg1, glp_prob jarg1_, long jarg2, glp_smcp jarg2_);
  public final static native int glp_exact(long jarg1, glp_prob jarg1_, long jarg2, glp_smcp jarg2_);
  public final static native void glp_init_smcp(long jarg1, glp_smcp jarg1_);
  public final static native int glp_get_status(long jarg1, glp_prob jarg1_);
  public final static native int glp_get_prim_stat(long jarg1, glp_prob jarg1_);
  public final static native int glp_get_dual_stat(long jarg1, glp_prob jarg1_);
  public final static native double glp_get_obj_val(long jarg1, glp_prob jarg1_);
  public final static native int glp_get_row_stat(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native double glp_get_row_prim(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native double glp_get_row_dual(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native int glp_get_col_stat(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native double glp_get_col_prim(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native double glp_get_col_dual(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native int glp_get_unbnd_ray(long jarg1, glp_prob jarg1_);
  public final static native int glp_get_it_cnt(long jarg1, glp_prob jarg1_);
  public final static native void glp_set_it_cnt(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native int glp_interior(long jarg1, glp_prob jarg1_, long jarg2, glp_iptcp jarg2_);
  public final static native void glp_init_iptcp(long jarg1, glp_iptcp jarg1_);
  public final static native int glp_ipt_status(long jarg1, glp_prob jarg1_);
  public final static native double glp_ipt_obj_val(long jarg1, glp_prob jarg1_);
  public final static native double glp_ipt_row_prim(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native double glp_ipt_row_dual(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native double glp_ipt_col_prim(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native double glp_ipt_col_dual(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native void glp_set_col_kind(long jarg1, glp_prob jarg1_, int jarg2, int jarg3);
  public final static native int glp_get_col_kind(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native int glp_get_num_int(long jarg1, glp_prob jarg1_);
  public final static native int glp_get_num_bin(long jarg1, glp_prob jarg1_);
  public final static native int glp_intopt(long jarg1, glp_prob jarg1_, long jarg2, glp_iocp jarg2_);
  public final static native void glp_init_iocp(long jarg1, glp_iocp jarg1_);
  public final static native int glp_mip_status(long jarg1, glp_prob jarg1_);
  public final static native double glp_mip_obj_val(long jarg1, glp_prob jarg1_);
  public final static native double glp_mip_row_val(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native double glp_mip_col_val(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native void glp_check_kkt(long jarg1, glp_prob jarg1_, int jarg2, int jarg3, long jarg4, long jarg5, long jarg6, long jarg7);
  public final static native int glp_print_sol(long jarg1, glp_prob jarg1_, String jarg2);
  public final static native int glp_read_sol(long jarg1, glp_prob jarg1_, String jarg2);
  public final static native int glp_write_sol(long jarg1, glp_prob jarg1_, String jarg2);
  public final static native int glp_print_ranges(long jarg1, glp_prob jarg1_, int jarg2, long jarg3, int jarg4, String jarg5);
  public final static native int glp_print_ipt(long jarg1, glp_prob jarg1_, String jarg2);
  public final static native int glp_read_ipt(long jarg1, glp_prob jarg1_, String jarg2);
  public final static native int glp_write_ipt(long jarg1, glp_prob jarg1_, String jarg2);
  public final static native int glp_print_mip(long jarg1, glp_prob jarg1_, String jarg2);
  public final static native int glp_read_mip(long jarg1, glp_prob jarg1_, String jarg2);
  public final static native int glp_write_mip(long jarg1, glp_prob jarg1_, String jarg2);
  public final static native int glp_bf_exists(long jarg1, glp_prob jarg1_);
  public final static native int glp_factorize(long jarg1, glp_prob jarg1_);
  public final static native int glp_bf_updated(long jarg1, glp_prob jarg1_);
  public final static native void glp_get_bfcp(long jarg1, glp_prob jarg1_, long jarg2, glp_bfcp jarg2_);
  public final static native void glp_set_bfcp(long jarg1, glp_prob jarg1_, long jarg2, glp_bfcp jarg2_);
  public final static native int glp_get_bhead(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native int glp_get_row_bind(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native int glp_get_col_bind(long jarg1, glp_prob jarg1_, int jarg2);
  public final static native void glp_ftran(long jarg1, glp_prob jarg1_, long jarg2);
  public final static native void glp_btran(long jarg1, glp_prob jarg1_, long jarg2);
  public final static native int glp_warm_up(long jarg1, glp_prob jarg1_);
  public final static native int glp_eval_tab_row(long jarg1, glp_prob jarg1_, int jarg2, long jarg3, long jarg4);
  public final static native int glp_eval_tab_col(long jarg1, glp_prob jarg1_, int jarg2, long jarg3, long jarg4);
  public final static native int glp_transform_row(long jarg1, glp_prob jarg1_, int jarg2, long jarg3, long jarg4);
  public final static native int glp_transform_col(long jarg1, glp_prob jarg1_, int jarg2, long jarg3, long jarg4);
  public final static native int glp_prim_rtest(long jarg1, glp_prob jarg1_, int jarg2, long jarg3, long jarg4, int jarg5, double jarg6);
  public final static native int glp_dual_rtest(long jarg1, glp_prob jarg1_, int jarg2, long jarg3, long jarg4, int jarg5, double jarg6);
  public final static native void glp_analyze_bound(long jarg1, glp_prob jarg1_, int jarg2, long jarg3, long jarg4, long jarg5, long jarg6);
  public final static native void glp_analyze_coef(long jarg1, glp_prob jarg1_, int jarg2, long jarg3, long jarg4, long jarg5, long jarg6, long jarg7, long jarg8);
  public final static native int glp_ios_reason(long jarg1, glp_tree jarg1_);
  public final static native long glp_ios_get_prob(long jarg1, glp_tree jarg1_);
  public final static native void glp_ios_tree_size(long jarg1, glp_tree jarg1_, long jarg2, long jarg3, long jarg4);
  public final static native int glp_ios_curr_node(long jarg1, glp_tree jarg1_);
  public final static native int glp_ios_next_node(long jarg1, glp_tree jarg1_, int jarg2);
  public final static native int glp_ios_prev_node(long jarg1, glp_tree jarg1_, int jarg2);
  public final static native int glp_ios_up_node(long jarg1, glp_tree jarg1_, int jarg2);
  public final static native int glp_ios_node_level(long jarg1, glp_tree jarg1_, int jarg2);
  public final static native double glp_ios_node_bound(long jarg1, glp_tree jarg1_, int jarg2);
  public final static native int glp_ios_best_node(long jarg1, glp_tree jarg1_);
  public final static native double glp_ios_mip_gap(long jarg1, glp_tree jarg1_);
  public final static native long glp_ios_node_data(long jarg1, glp_tree jarg1_, int jarg2);
  public final static native void glp_ios_row_attr(long jarg1, glp_tree jarg1_, int jarg2, long jarg3, glp_attr jarg3_);
  public final static native int glp_ios_pool_size(long jarg1, glp_tree jarg1_);
  public final static native int glp_ios_add_row(long jarg1, glp_tree jarg1_, String jarg2, int jarg3, int jarg4, int jarg5, long jarg6, long jarg7, int jarg8, double jarg9);
  public final static native void glp_ios_del_row(long jarg1, glp_tree jarg1_, int jarg2);
  public final static native void glp_ios_clear_pool(long jarg1, glp_tree jarg1_);
  public final static native int glp_ios_can_branch(long jarg1, glp_tree jarg1_, int jarg2);
  public final static native void glp_ios_branch_upon(long jarg1, glp_tree jarg1_, int jarg2, int jarg3);
  public final static native void glp_ios_select_node(long jarg1, glp_tree jarg1_, int jarg2);
  public final static native int glp_ios_heur_sol(long jarg1, glp_tree jarg1_, long jarg2);
  public final static native void glp_ios_terminate(long jarg1, glp_tree jarg1_);
  public final static native void glp_init_mpscp(long jarg1, glp_mpscp jarg1_);
  public final static native int glp_read_mps(long jarg1, glp_prob jarg1_, int jarg2, long jarg3, glp_mpscp jarg3_, String jarg4);
  public final static native int glp_write_mps(long jarg1, glp_prob jarg1_, int jarg2, long jarg3, glp_mpscp jarg3_, String jarg4);
  public final static native void glp_init_cpxcp(long jarg1, glp_cpxcp jarg1_);
  public final static native int glp_read_lp(long jarg1, glp_prob jarg1_, long jarg2, glp_cpxcp jarg2_, String jarg3);
  public final static native int glp_write_lp(long jarg1, glp_prob jarg1_, long jarg2, glp_cpxcp jarg2_, String jarg3);
  public final static native int glp_read_prob(long jarg1, glp_prob jarg1_, int jarg2, String jarg3);
  public final static native int glp_write_prob(long jarg1, glp_prob jarg1_, int jarg2, String jarg3);
  public final static native long glp_mpl_alloc_wksp();
  public final static native int glp_mpl_read_model(long jarg1, glp_tran jarg1_, String jarg2, int jarg3);
  public final static native int glp_mpl_read_data(long jarg1, glp_tran jarg1_, String jarg2);
  public final static native int glp_mpl_generate(long jarg1, glp_tran jarg1_, String jarg2);
  public final static native void glp_mpl_build_prob(long jarg1, glp_tran jarg1_, long jarg2, glp_prob jarg2_);
  public final static native int glp_mpl_postsolve(long jarg1, glp_tran jarg1_, long jarg2, glp_prob jarg2_, int jarg3);
  public final static native void glp_mpl_free_wksp(long jarg1, glp_tran jarg1_);
  public final static native int glp_main(int jarg1, String[] jarg2);
  public final static native int glp_read_cnfsat(long jarg1, glp_prob jarg1_, String jarg2);
  public final static native int glp_check_cnfsat(long jarg1, glp_prob jarg1_);
  public final static native int glp_write_cnfsat(long jarg1, glp_prob jarg1_, String jarg2);
  public final static native int glp_minisat1(long jarg1, glp_prob jarg1_);
  public final static native int glp_intfeas1(long jarg1, glp_prob jarg1_, int jarg2, int jarg3);
  public final static native int glp_init_env();
  public final static native String glp_version();
  public final static native int glp_free_env();
  public final static native void glp_puts(String jarg1);
  public final static native void glp_printf(String jarg1);
  public final static native void glp_vprintf(String jarg1, long jarg2);
  public final static native int glp_term_out(int jarg1);
  public final static native void glp_term_hook(long jarg1, long jarg2);
  public final static native int glp_open_tee(String jarg1);
  public final static native int glp_close_tee();
  public final static native long glp_error_(String jarg1, int jarg2);
  public final static native void glp_assert_(String jarg1, String jarg2, int jarg3);
  public final static native void glp_error_hook(long jarg1, long jarg2);
  public final static native long glp_alloc(int jarg1, int jarg2);
  public final static native long glp_realloc(long jarg1, int jarg2, int jarg3);
  public final static native void glp_free(long jarg1);
  public final static native void glp_mem_limit(int jarg1);
  public final static native void glp_mem_usage(long jarg1, long jarg2, long jarg3, long jarg4);
  public final static native void glp_graph_pool_set(long jarg1, long jarg2);
  public final static native long glp_graph_pool_get(long jarg1);
  public final static native void glp_graph_name_set(long jarg1, String jarg2);
  public final static native String glp_graph_name_get(long jarg1);
  public final static native void glp_graph_nv_max_set(long jarg1, int jarg2);
  public final static native int glp_graph_nv_max_get(long jarg1);
  public final static native void glp_graph_nv_set(long jarg1, int jarg2);
  public final static native int glp_graph_nv_get(long jarg1);
  public final static native void glp_graph_na_set(long jarg1, int jarg2);
  public final static native int glp_graph_na_get(long jarg1);
  public final static native void glp_graph_v_set(long jarg1, long jarg2);
  public final static native long glp_graph_v_get(long jarg1);
  public final static native void glp_graph_index_set(long jarg1, long jarg2);
  public final static native long glp_graph_index_get(long jarg1);
  public final static native void glp_graph_v_size_set(long jarg1, int jarg2);
  public final static native int glp_graph_v_size_get(long jarg1);
  public final static native void glp_graph_a_size_set(long jarg1, int jarg2);
  public final static native int glp_graph_a_size_get(long jarg1);
  public final static native long new_glp_graph();
  public final static native void delete_glp_graph(long jarg1);
  public final static native void glp_vertex_i_set(long jarg1, int jarg2);
  public final static native int glp_vertex_i_get(long jarg1);
  public final static native void glp_vertex_name_set(long jarg1, String jarg2);
  public final static native String glp_vertex_name_get(long jarg1);
  public final static native void glp_vertex_entry_set(long jarg1, long jarg2);
  public final static native long glp_vertex_entry_get(long jarg1);
  public final static native void glp_vertex_data_set(long jarg1, long jarg2);
  public final static native long glp_vertex_data_get(long jarg1);
  public final static native void glp_vertex_temp_set(long jarg1, long jarg2);
  public final static native long glp_vertex_temp_get(long jarg1);
  public final static native void glp_vertex_in_set(long jarg1, long jarg2, glp_arc jarg2_);
  public final static native long glp_vertex_in_get(long jarg1);
  public final static native void glp_vertex_out_set(long jarg1, long jarg2, glp_arc jarg2_);
  public final static native long glp_vertex_out_get(long jarg1);
  public final static native long new_glp_vertex();
  public final static native void delete_glp_vertex(long jarg1);
  public final static native void glp_arc_tail_set(long jarg1, long jarg2, glp_vertex jarg2_);
  public final static native long glp_arc_tail_get(long jarg1);
  public final static native void glp_arc_head_set(long jarg1, long jarg2, glp_vertex jarg2_);
  public final static native long glp_arc_head_get(long jarg1);
  public final static native void glp_arc_data_set(long jarg1, long jarg2);
  public final static native long glp_arc_data_get(long jarg1);
  public final static native void glp_arc_temp_set(long jarg1, long jarg2);
  public final static native long glp_arc_temp_get(long jarg1);
  public final static native void glp_arc_t_prev_set(long jarg1, long jarg2, glp_arc jarg2_);
  public final static native long glp_arc_t_prev_get(long jarg1);
  public final static native void glp_arc_t_next_set(long jarg1, long jarg2, glp_arc jarg2_);
  public final static native long glp_arc_t_next_get(long jarg1);
  public final static native void glp_arc_h_prev_set(long jarg1, long jarg2, glp_arc jarg2_);
  public final static native long glp_arc_h_prev_get(long jarg1);
  public final static native void glp_arc_h_next_set(long jarg1, long jarg2, glp_arc jarg2_);
  public final static native long glp_arc_h_next_get(long jarg1);
  public final static native long new_glp_arc();
  public final static native void delete_glp_arc(long jarg1);
  public final static native long glp_create_graph(int jarg1, int jarg2);
  public final static native void glp_set_graph_name(long jarg1, glp_graph jarg1_, String jarg2);
  public final static native int glp_add_vertices(long jarg1, glp_graph jarg1_, int jarg2);
  public final static native void glp_set_vertex_name(long jarg1, glp_graph jarg1_, int jarg2, String jarg3);
  public final static native long glp_add_arc(long jarg1, glp_graph jarg1_, int jarg2, int jarg3);
  public final static native void glp_del_vertices(long jarg1, glp_graph jarg1_, int jarg2, long jarg3);
  public final static native void glp_del_arc(long jarg1, glp_graph jarg1_, long jarg2, glp_arc jarg2_);
  public final static native void glp_erase_graph(long jarg1, glp_graph jarg1_, int jarg2, int jarg3);
  public final static native void glp_delete_graph(long jarg1, glp_graph jarg1_);
  public final static native void glp_create_v_index(long jarg1, glp_graph jarg1_);
  public final static native int glp_find_vertex(long jarg1, glp_graph jarg1_, String jarg2);
  public final static native void glp_delete_v_index(long jarg1, glp_graph jarg1_);
  public final static native int glp_read_graph(long jarg1, glp_graph jarg1_, String jarg2);
  public final static native int glp_write_graph(long jarg1, glp_graph jarg1_, String jarg2);
  public final static native void glp_mincost_lp(long jarg1, glp_prob jarg1_, long jarg2, glp_graph jarg2_, int jarg3, int jarg4, int jarg5, int jarg6, int jarg7);
  public final static native int glp_mincost_okalg(long jarg1, glp_graph jarg1_, int jarg2, int jarg3, int jarg4, int jarg5, long jarg6, int jarg7, int jarg8);
  public final static native int glp_mincost_relax4(long jarg1, glp_graph jarg1_, int jarg2, int jarg3, int jarg4, int jarg5, int jarg6, long jarg7, int jarg8, int jarg9);
  public final static native void glp_maxflow_lp(long jarg1, glp_prob jarg1_, long jarg2, glp_graph jarg2_, int jarg3, int jarg4, int jarg5, int jarg6);
  public final static native int glp_maxflow_ffalg(long jarg1, glp_graph jarg1_, int jarg2, int jarg3, int jarg4, long jarg5, int jarg6, int jarg7);
  public final static native int glp_check_asnprob(long jarg1, glp_graph jarg1_, int jarg2);
  public final static native int GLP_ASN_MIN_get();
  public final static native int GLP_ASN_MAX_get();
  public final static native int GLP_ASN_MMP_get();
  public final static native int glp_asnprob_lp(long jarg1, glp_prob jarg1_, int jarg2, long jarg3, glp_graph jarg3_, int jarg4, int jarg5, int jarg6);
  public final static native int glp_asnprob_okalg(int jarg1, long jarg2, glp_graph jarg2_, int jarg3, int jarg4, long jarg5, int jarg6);
  public final static native int glp_asnprob_hall(long jarg1, glp_graph jarg1_, int jarg2, int jarg3);
  public final static native double glp_cpp(long jarg1, glp_graph jarg1_, int jarg2, int jarg3, int jarg4);
  public final static native int glp_read_mincost(long jarg1, glp_graph jarg1_, int jarg2, int jarg3, int jarg4, int jarg5, String jarg6);
  public final static native int glp_write_mincost(long jarg1, glp_graph jarg1_, int jarg2, int jarg3, int jarg4, int jarg5, String jarg6);
  public final static native int glp_read_maxflow(long jarg1, glp_graph jarg1_, long jarg2, long jarg3, int jarg4, String jarg5);
  public final static native int glp_write_maxflow(long jarg1, glp_graph jarg1_, int jarg2, int jarg3, int jarg4, String jarg5);
  public final static native int glp_read_asnprob(long jarg1, glp_graph jarg1_, int jarg2, int jarg3, String jarg4);
  public final static native int glp_write_asnprob(long jarg1, glp_graph jarg1_, int jarg2, int jarg3, String jarg4);
  public final static native int glp_read_ccdata(long jarg1, glp_graph jarg1_, int jarg2, String jarg3);
  public final static native int glp_write_ccdata(long jarg1, glp_graph jarg1_, int jarg2, String jarg3);
  public final static native int glp_netgen(long jarg1, glp_graph jarg1_, int jarg2, int jarg3, int jarg4, long jarg5);
  public final static native void glp_netgen_prob(int jarg1, long jarg2);
  public final static native int glp_gridgen(long jarg1, glp_graph jarg1_, int jarg2, int jarg3, int jarg4, long jarg5);
  public final static native int glp_rmfgen(long jarg1, glp_graph jarg1_, long jarg2, long jarg3, int jarg4, long jarg5);
  public final static native int glp_weak_comp(long jarg1, glp_graph jarg1_, int jarg2);
  public final static native int glp_strong_comp(long jarg1, glp_graph jarg1_, int jarg2);
  public final static native int glp_top_sort(long jarg1, glp_graph jarg1_, int jarg2);
  public final static native int glp_wclique_exact(long jarg1, glp_graph jarg1_, int jarg2, long jarg3, int jarg4);
}
