/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.AbstractPlainSocketImpl;
import java.net.DualStackPlainSocketImpl;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketInputStream;
import java.net.TwoStacksPlainSocketImpl;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;

class PlainSocketImpl
extends AbstractPlainSocketImpl {
    private AbstractPlainSocketImpl impl;
    private static float version;
    private static boolean preferIPv4Stack;
    private static boolean useDualStackImpl;
    private static String exclBindProp;
    private static boolean exclusiveBind;

    PlainSocketImpl() {
        this.impl = useDualStackImpl ? new DualStackPlainSocketImpl(exclusiveBind) : new TwoStacksPlainSocketImpl(exclusiveBind);
    }

    PlainSocketImpl(FileDescriptor fd) {
        this.impl = useDualStackImpl ? new DualStackPlainSocketImpl(fd, exclusiveBind) : new TwoStacksPlainSocketImpl(fd, exclusiveBind);
    }

    @Override
    protected FileDescriptor getFileDescriptor() {
        return this.impl.getFileDescriptor();
    }

    @Override
    protected InetAddress getInetAddress() {
        return this.impl.getInetAddress();
    }

    @Override
    protected int getPort() {
        return this.impl.getPort();
    }

    @Override
    protected int getLocalPort() {
        return this.impl.getLocalPort();
    }

    @Override
    void setSocket(Socket soc) {
        this.impl.setSocket(soc);
    }

    @Override
    Socket getSocket() {
        return this.impl.getSocket();
    }

    @Override
    void setServerSocket(ServerSocket soc) {
        this.impl.setServerSocket(soc);
    }

    @Override
    ServerSocket getServerSocket() {
        return this.impl.getServerSocket();
    }

    @Override
    public String toString() {
        return this.impl.toString();
    }

    @Override
    protected synchronized void create(boolean stream) throws IOException {
        this.impl.create(stream);
        this.fd = this.impl.fd;
    }

    @Override
    protected void connect(String host, int port) throws UnknownHostException, IOException {
        this.impl.connect(host, port);
    }

    @Override
    protected void connect(InetAddress address, int port) throws IOException {
        this.impl.connect(address, port);
    }

    @Override
    protected void connect(SocketAddress address, int timeout) throws IOException {
        this.impl.connect(address, timeout);
    }

    @Override
    public void setOption(int opt, Object val) throws SocketException {
        this.impl.setOption(opt, val);
    }

    @Override
    public Object getOption(int opt) throws SocketException {
        return this.impl.getOption(opt);
    }

    @Override
    synchronized void doConnect(InetAddress address, int port, int timeout) throws IOException {
        this.impl.doConnect(address, port, timeout);
    }

    @Override
    protected synchronized void bind(InetAddress address, int lport) throws IOException {
        this.impl.bind(address, lport);
    }

    @Override
    protected synchronized void accept(SocketImpl s) throws IOException {
        if (s instanceof PlainSocketImpl) {
            AbstractPlainSocketImpl delegate = ((PlainSocketImpl)s).impl;
            delegate.address = new InetAddress();
            delegate.fd = new FileDescriptor();
            this.impl.accept(delegate);
            s.fd = delegate.fd;
        } else {
            this.impl.accept(s);
        }
    }

    @Override
    void setFileDescriptor(FileDescriptor fd) {
        this.impl.setFileDescriptor(fd);
    }

    @Override
    void setAddress(InetAddress address) {
        this.impl.setAddress(address);
    }

    @Override
    void setPort(int port) {
        this.impl.setPort(port);
    }

    @Override
    void setLocalPort(int localPort) {
        this.impl.setLocalPort(localPort);
    }

    @Override
    protected synchronized InputStream getInputStream() throws IOException {
        return this.impl.getInputStream();
    }

    @Override
    void setInputStream(SocketInputStream in) {
        this.impl.setInputStream(in);
    }

    @Override
    protected synchronized OutputStream getOutputStream() throws IOException {
        return this.impl.getOutputStream();
    }

    @Override
    protected void close() throws IOException {
        try {
            this.impl.close();
        }
        finally {
            this.fd = null;
        }
    }

    @Override
    void reset() throws IOException {
        try {
            this.impl.reset();
        }
        finally {
            this.fd = null;
        }
    }

    @Override
    protected void shutdownInput() throws IOException {
        this.impl.shutdownInput();
    }

    @Override
    protected void shutdownOutput() throws IOException {
        this.impl.shutdownOutput();
    }

    @Override
    protected void sendUrgentData(int data) throws IOException {
        this.impl.sendUrgentData(data);
    }

    @Override
    FileDescriptor acquireFD() {
        return this.impl.acquireFD();
    }

    @Override
    void releaseFD() {
        this.impl.releaseFD();
    }

    @Override
    public boolean isConnectionReset() {
        return this.impl.isConnectionReset();
    }

    @Override
    public boolean isConnectionResetPending() {
        return this.impl.isConnectionResetPending();
    }

    @Override
    public void setConnectionReset() {
        this.impl.setConnectionReset();
    }

    @Override
    public void setConnectionResetPending() {
        this.impl.setConnectionResetPending();
    }

    @Override
    public boolean isClosedOrPending() {
        return this.impl.isClosedOrPending();
    }

    @Override
    public int getTimeout() {
        return this.impl.getTimeout();
    }

    @Override
    void socketCreate(boolean isServer) throws IOException {
        this.impl.socketCreate(isServer);
    }

    @Override
    void socketConnect(InetAddress address, int port, int timeout) throws IOException {
        this.impl.socketConnect(address, port, timeout);
    }

    @Override
    void socketBind(InetAddress address, int port) throws IOException {
        this.impl.socketBind(address, port);
    }

    @Override
    void socketListen(int count) throws IOException {
        this.impl.socketListen(count);
    }

    @Override
    void socketAccept(SocketImpl s) throws IOException {
        this.impl.socketAccept(s);
    }

    @Override
    int socketAvailable() throws IOException {
        return this.impl.socketAvailable();
    }

    @Override
    void socketClose0(boolean useDeferredClose) throws IOException {
        this.impl.socketClose0(useDeferredClose);
    }

    @Override
    void socketShutdown(int howto) throws IOException {
        this.impl.socketShutdown(howto);
    }

    @Override
    void socketSetOption(int cmd, boolean on, Object value) throws SocketException {
        this.impl.socketSetOption(cmd, on, value);
    }

    @Override
    int socketGetOption(int opt, Object iaContainerObj) throws SocketException {
        return this.impl.socketGetOption(opt, iaContainerObj);
    }

    @Override
    void socketSendUrgentData(int data) throws IOException {
        this.impl.socketSendUrgentData(data);
    }

    static {
        preferIPv4Stack = false;
        useDualStackImpl = false;
        exclusiveBind = true;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                block2: {
                    version = 0.0f;
                    try {
                        version = Float.parseFloat(System.getProperties().getProperty("os.version"));
                        preferIPv4Stack = Boolean.parseBoolean(System.getProperties().getProperty("java.net.preferIPv4Stack"));
                        exclBindProp = System.getProperty("sun.net.useExclusiveBind");
                    }
                    catch (NumberFormatException e) {
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError((Object)e);
                    }
                }
                return null;
            }
        });
        if ((double)version >= 6.0 && !preferIPv4Stack) {
            useDualStackImpl = true;
        }
        if (exclBindProp != null) {
            exclusiveBind = exclBindProp.length() == 0 ? true : Boolean.parseBoolean(exclBindProp);
        } else if ((double)version < 6.0) {
            exclusiveBind = false;
        }
    }
}

