/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class IdentityHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable,
Cloneable {
    private static final int DEFAULT_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x20000000;
    transient Object[] table;
    int size;
    transient int modCount;
    static final Object NULL_KEY = new Object();
    private transient Set<Map.Entry<K, V>> entrySet;
    private static final long serialVersionUID = 8188218128353913216L;

    private static Object maskNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    static final Object unmaskNull(Object key) {
        return key == NULL_KEY ? null : key;
    }

    public IdentityHashMap() {
        this.init(32);
    }

    public IdentityHashMap(int expectedMaxSize) {
        if (expectedMaxSize < 0) {
            throw new IllegalArgumentException("expectedMaxSize is negative: " + expectedMaxSize);
        }
        this.init(IdentityHashMap.capacity(expectedMaxSize));
    }

    private static int capacity(int expectedMaxSize) {
        return expectedMaxSize > 0xAAAAAAA ? 0x20000000 : (expectedMaxSize <= 2 ? 4 : Integer.highestOneBit(expectedMaxSize + (expectedMaxSize << 1)));
    }

    private void init(int initCapacity) {
        this.table = new Object[2 * initCapacity];
    }

    public IdentityHashMap(Map<? extends K, ? extends V> m) {
        this((int)((double)(1 + m.size()) * 1.1));
        this.putAll(m);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private static int hash(Object x, int length) {
        int h = System.identityHashCode(x);
        return (h << 1) - (h << 8) & length - 1;
    }

    private static int nextKeyIndex(int i, int len) {
        return i + 2 < len ? i + 2 : 0;
    }

    @Override
    public V get(Object key) {
        Object k = IdentityHashMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityHashMap.hash(k, len);
        Object item;
        while ((item = tab[i]) != k) {
            if (item == null) {
                return null;
            }
            i = IdentityHashMap.nextKeyIndex(i, len);
        }
        return (V)tab[i + 1];
    }

    @Override
    public boolean containsKey(Object key) {
        Object k = IdentityHashMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityHashMap.hash(k, len);
        Object item;
        while ((item = tab[i]) != k) {
            if (item == null) {
                return false;
            }
            i = IdentityHashMap.nextKeyIndex(i, len);
        }
        return true;
    }

    @Override
    public boolean containsValue(Object value) {
        Object[] tab = this.table;
        for (int i = 1; i < tab.length; i += 2) {
            if (tab[i] != value || tab[i - 1] == null) continue;
            return true;
        }
        return false;
    }

    private boolean containsMapping(Object key, Object value) {
        Object k = IdentityHashMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityHashMap.hash(k, len);
        Object item;
        while ((item = tab[i]) != k) {
            if (item == null) {
                return false;
            }
            i = IdentityHashMap.nextKeyIndex(i, len);
        }
        return tab[i + 1] == value;
    }

    @Override
    public V put(K key, V value) {
        int len;
        int s;
        Object k = IdentityHashMap.maskNull(key);
        do {
            Object item;
            Object[] tab = this.table;
            len = tab.length;
            int i = IdentityHashMap.hash(k, len);
            while ((item = tab[i]) != null) {
                if (item == k) {
                    Object oldValue = tab[i + 1];
                    tab[i + 1] = value;
                    return (V)oldValue;
                }
                i = IdentityHashMap.nextKeyIndex(i, len);
            }
        } while ((s = this.size + 1) + (s << 1) > len && this.resize(len));
        ++this.modCount;
        tab[i] = k;
        tab[i + 1] = value;
        this.size = s;
        return null;
    }

    private boolean resize(int newCapacity) {
        int newLength = newCapacity * 2;
        Object[] oldTable = this.table;
        int oldLength = oldTable.length;
        if (oldLength == 0x40000000) {
            if (this.size == 0x1FFFFFFF) {
                throw new IllegalStateException("Capacity exhausted.");
            }
            return false;
        }
        if (oldLength >= newLength) {
            return false;
        }
        Object[] newTable = new Object[newLength];
        for (int j = 0; j < oldLength; j += 2) {
            Object key = oldTable[j];
            if (key == null) continue;
            Object value = oldTable[j + 1];
            oldTable[j] = null;
            oldTable[j + 1] = null;
            int i = IdentityHashMap.hash(key, newLength);
            while (newTable[i] != null) {
                i = IdentityHashMap.nextKeyIndex(i, newLength);
            }
            newTable[i] = key;
            newTable[i + 1] = value;
        }
        this.table = newTable;
        return true;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        int n = m.size();
        if (n == 0) {
            return;
        }
        if (n > this.size) {
            this.resize(IdentityHashMap.capacity(n));
        }
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Object k = IdentityHashMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityHashMap.hash(k, len);
        while (true) {
            Object item;
            if ((item = tab[i]) == k) {
                ++this.modCount;
                --this.size;
                Object oldValue = tab[i + 1];
                tab[i + 1] = null;
                tab[i] = null;
                this.closeDeletion(i);
                return (V)oldValue;
            }
            if (item == null) {
                return null;
            }
            i = IdentityHashMap.nextKeyIndex(i, len);
        }
    }

    private boolean removeMapping(Object key, Object value) {
        Object k = IdentityHashMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityHashMap.hash(k, len);
        while (true) {
            Object item;
            if ((item = tab[i]) == k) {
                if (tab[i + 1] != value) {
                    return false;
                }
                ++this.modCount;
                --this.size;
                tab[i] = null;
                tab[i + 1] = null;
                this.closeDeletion(i);
                return true;
            }
            if (item == null) {
                return false;
            }
            i = IdentityHashMap.nextKeyIndex(i, len);
        }
    }

    private void closeDeletion(int d) {
        Object item;
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityHashMap.nextKeyIndex(d, len);
        while ((item = tab[i]) != null) {
            int r = IdentityHashMap.hash(item, len);
            if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                tab[d] = item;
                tab[d + 1] = tab[i + 1];
                tab[i] = null;
                tab[i + 1] = null;
                d = i;
            }
            i = IdentityHashMap.nextKeyIndex(i, len);
        }
    }

    @Override
    public void clear() {
        ++this.modCount;
        Object[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IdentityHashMap) {
            IdentityHashMap m = (IdentityHashMap)o;
            if (m.size() != this.size) {
                return false;
            }
            Object[] tab = m.table;
            for (int i = 0; i < tab.length; i += 2) {
                Object k = tab[i];
                if (k == null || this.containsMapping(k, tab[i + 1])) continue;
                return false;
            }
            return true;
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            return this.entrySet().equals(m.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 0;
        Object[] tab = this.table;
        for (int i = 0; i < tab.length; i += 2) {
            Object key = tab[i];
            if (key == null) continue;
            Object k = IdentityHashMap.unmaskNull(key);
            result += System.identityHashCode(k) ^ System.identityHashCode(tab[i + 1]);
        }
        return result;
    }

    @Override
    public Object clone() {
        try {
            IdentityHashMap m = (IdentityHashMap)super.clone();
            m.entrySet = null;
            m.table = (Object[])this.table.clone();
            return m;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public Set<K> keySet() {
        Set ks = this.keySet;
        if (ks == null) {
            this.keySet = ks = new KeySet();
        }
        return ks;
    }

    @Override
    public Collection<V> values() {
        Collection vs = this.values;
        if (vs == null) {
            this.values = vs = new Values();
        }
        return vs;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> es = this.entrySet;
        if (es != null) {
            return es;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        Object[] tab = this.table;
        for (int i = 0; i < tab.length; i += 2) {
            Object key = tab[i];
            if (key == null) continue;
            s.writeObject(IdentityHashMap.unmaskNull(key));
            s.writeObject(tab[i + 1]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        if (size < 0) {
            throw new StreamCorruptedException("Illegal mappings count: " + size);
        }
        this.init(IdentityHashMap.capacity(size));
        for (int i = 0; i < size; ++i) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.putForCreate(key, value);
        }
    }

    private void putForCreate(K key, V value) throws StreamCorruptedException {
        Object item;
        Object k = IdentityHashMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityHashMap.hash(k, len);
        while ((item = tab[i]) != null) {
            if (item == k) {
                throw new StreamCorruptedException();
            }
            i = IdentityHashMap.nextKeyIndex(i, len);
        }
        tab[i] = k;
        tab[i + 1] = value;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(action);
        int expectedModCount = this.modCount;
        Object[] t = this.table;
        for (int index = 0; index < t.length; index += 2) {
            Object k = t[index];
            if (k != null) {
                action.accept(IdentityHashMap.unmaskNull(k), t[index + 1]);
            }
            if (this.modCount == expectedModCount) continue;
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Objects.requireNonNull(function);
        int expectedModCount = this.modCount;
        Object[] t = this.table;
        for (int index = 0; index < t.length; index += 2) {
            Object k = t[index];
            if (k != null) {
                t[index + 1] = function.apply(IdentityHashMap.unmaskNull(k), t[index + 1]);
            }
            if (this.modCount == expectedModCount) continue;
            throw new ConcurrentModificationException();
        }
    }

    static final class EntrySpliterator<K, V>
    extends IdentityHashMapSpliterator<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        EntrySpliterator(IdentityHashMap<K, V> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        public EntrySpliterator<K, V> trySplit() {
            EntrySpliterator<K, V> entrySpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1 & 0xFFFFFFFE;
            if (lo >= mid) {
                entrySpliterator = null;
            } else {
                this.index = mid;
                EntrySpliterator<K, V> entrySpliterator2 = new EntrySpliterator<K, V>(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                entrySpliterator = entrySpliterator2;
            }
            return entrySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            IdentityHashMap m = this.map;
            if (m != null) {
                int i;
                Object[] a = m.table;
                if (m.table != null && (i = this.index) >= 0) {
                    int hi;
                    this.index = hi = this.getFence();
                    if (hi <= a.length) {
                        while (i < hi) {
                            Object key = a[i];
                            if (key != null) {
                                Object k = IdentityHashMap.unmaskNull(key);
                                Object v = a[i + 1];
                                action.accept(new AbstractMap.SimpleImmutableEntry<Object, Object>(k, v));
                            }
                            i += 2;
                        }
                        if (m.modCount == this.expectedModCount) {
                            return;
                        }
                    }
                }
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] a = this.map.table;
            int hi = this.getFence();
            while (this.index < hi) {
                Object key = a[this.index];
                Object v = a[this.index + 1];
                this.index += 2;
                if (key == null) continue;
                Object k = IdentityHashMap.unmaskNull(key);
                action.accept(new AbstractMap.SimpleImmutableEntry<Object, Object>(k, v));
                if (this.map.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public int characteristics() {
            return (this.fence < 0 || this.est == this.map.size ? 64 : 0) | 1;
        }
    }

    static final class ValueSpliterator<K, V>
    extends IdentityHashMapSpliterator<K, V>
    implements Spliterator<V> {
        ValueSpliterator(IdentityHashMap<K, V> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        public ValueSpliterator<K, V> trySplit() {
            ValueSpliterator<K, V> valueSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1 & 0xFFFFFFFE;
            if (lo >= mid) {
                valueSpliterator = null;
            } else {
                this.index = mid;
                ValueSpliterator<K, V> valueSpliterator2 = new ValueSpliterator<K, V>(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                valueSpliterator = valueSpliterator2;
            }
            return valueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            IdentityHashMap m = this.map;
            if (m != null) {
                int i;
                Object[] a = m.table;
                if (m.table != null && (i = this.index) >= 0) {
                    int hi;
                    this.index = hi = this.getFence();
                    if (hi <= a.length) {
                        while (i < hi) {
                            if (a[i] != null) {
                                Object v = a[i + 1];
                                action.accept(v);
                            }
                            i += 2;
                        }
                        if (m.modCount == this.expectedModCount) {
                            return;
                        }
                    }
                }
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] a = this.map.table;
            int hi = this.getFence();
            while (this.index < hi) {
                Object key = a[this.index];
                Object v = a[this.index + 1];
                this.index += 2;
                if (key == null) continue;
                action.accept(v);
                if (this.map.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public int characteristics() {
            return this.fence < 0 || this.est == this.map.size ? 64 : 0;
        }
    }

    static final class KeySpliterator<K, V>
    extends IdentityHashMapSpliterator<K, V>
    implements Spliterator<K> {
        KeySpliterator(IdentityHashMap<K, V> map, int origin, int fence, int est, int expectedModCount) {
            super(map, origin, fence, est, expectedModCount);
        }

        public KeySpliterator<K, V> trySplit() {
            KeySpliterator<K, V> keySpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1 & 0xFFFFFFFE;
            if (lo >= mid) {
                keySpliterator = null;
            } else {
                this.index = mid;
                KeySpliterator<K, V> keySpliterator2 = new KeySpliterator<K, V>(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                keySpliterator = keySpliterator2;
            }
            return keySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            IdentityHashMap m = this.map;
            if (m != null) {
                int i;
                Object[] a = m.table;
                if (m.table != null && (i = this.index) >= 0) {
                    int hi;
                    this.index = hi = this.getFence();
                    if (hi <= a.length) {
                        while (i < hi) {
                            Object key = a[i];
                            if (key != null) {
                                action.accept(IdentityHashMap.unmaskNull(key));
                            }
                            i += 2;
                        }
                        if (m.modCount == this.expectedModCount) {
                            return;
                        }
                    }
                }
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] a = this.map.table;
            int hi = this.getFence();
            while (this.index < hi) {
                Object key = a[this.index];
                this.index += 2;
                if (key == null) continue;
                action.accept(IdentityHashMap.unmaskNull(key));
                if (this.map.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public int characteristics() {
            return (this.fence < 0 || this.est == this.map.size ? 64 : 0) | 1;
        }
    }

    static class IdentityHashMapSpliterator<K, V> {
        final IdentityHashMap<K, V> map;
        int index;
        int fence;
        int est;
        int expectedModCount;

        IdentityHashMapSpliterator(IdentityHashMap<K, V> map, int origin, int fence, int est, int expectedModCount) {
            this.map = map;
            this.index = origin;
            this.fence = fence;
            this.est = est;
            this.expectedModCount = expectedModCount;
        }

        final int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                this.est = this.map.size;
                this.expectedModCount = this.map.modCount;
                hi = this.fence = this.map.table.length;
            }
            return hi;
        }

        public final long estimateSize() {
            this.getFence();
            return this.est;
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return IdentityHashMap.this.containsMapping(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return IdentityHashMap.this.removeMapping(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return IdentityHashMap.this.size;
        }

        @Override
        public void clear() {
            IdentityHashMap.this.clear();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            Objects.requireNonNull(c);
            boolean modified = false;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                if (!c.contains(i.next())) continue;
                i.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int expectedModCount = IdentityHashMap.this.modCount;
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            Object[] tab = IdentityHashMap.this.table;
            int ti = 0;
            for (int si = 0; si < tab.length; si += 2) {
                Object key = tab[si];
                if (key == null) continue;
                if (ti >= size) {
                    throw new ConcurrentModificationException();
                }
                a[ti++] = new AbstractMap.SimpleEntry<Object, Object>(IdentityHashMap.unmaskNull(key), tab[si + 1]);
            }
            if (ti < size || expectedModCount != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (ti < a.length) {
                a[ti] = null;
            }
            return a;
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator(IdentityHashMap.this, 0, -1, 0, 0);
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return IdentityHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return IdentityHashMap.this.containsValue(o);
        }

        @Override
        public boolean remove(Object o) {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                if (i.next() != o) continue;
                i.remove();
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            IdentityHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int expectedModCount = IdentityHashMap.this.modCount;
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            Object[] tab = IdentityHashMap.this.table;
            int ti = 0;
            for (int si = 0; si < tab.length; si += 2) {
                if (tab[si] == null) continue;
                if (ti >= size) {
                    throw new ConcurrentModificationException();
                }
                a[ti++] = tab[si + 1];
            }
            if (ti < size || expectedModCount != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (ti < a.length) {
                a[ti] = null;
            }
            return a;
        }

        @Override
        public Spliterator<V> spliterator() {
            return new ValueSpliterator(IdentityHashMap.this, 0, -1, 0, 0);
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return IdentityHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return IdentityHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            int oldSize = IdentityHashMap.this.size;
            IdentityHashMap.this.remove(o);
            return IdentityHashMap.this.size != oldSize;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            Objects.requireNonNull(c);
            boolean modified = false;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                if (!c.contains(i.next())) continue;
                i.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public void clear() {
            IdentityHashMap.this.clear();
        }

        @Override
        public int hashCode() {
            int result = 0;
            for (Object key : this) {
                result += System.identityHashCode(key);
            }
            return result;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int expectedModCount = IdentityHashMap.this.modCount;
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            Object[] tab = IdentityHashMap.this.table;
            int ti = 0;
            for (int si = 0; si < tab.length; si += 2) {
                Object key = tab[si];
                if (key == null) continue;
                if (ti >= size) {
                    throw new ConcurrentModificationException();
                }
                a[ti++] = IdentityHashMap.unmaskNull(key);
            }
            if (ti < size || expectedModCount != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (ti < a.length) {
                a[ti] = null;
            }
            return a;
        }

        @Override
        public Spliterator<K> spliterator() {
            return new KeySpliterator(IdentityHashMap.this, 0, -1, 0, 0);
        }
    }

    private class EntryIterator
    extends IdentityHashMapIterator<Map.Entry<K, V>> {
        private java.util.IdentityHashMap$EntryIterator.Entry lastReturnedEntry;

        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            this.lastReturnedEntry = new Entry(this.nextIndex());
            return this.lastReturnedEntry;
        }

        @Override
        public void remove() {
            this.lastReturnedIndex = null == this.lastReturnedEntry ? -1 : ((Entry)this.lastReturnedEntry).index;
            super.remove();
            ((Entry)this.lastReturnedEntry).index = this.lastReturnedIndex;
            this.lastReturnedEntry = null;
        }

        private class Entry
        implements Map.Entry<K, V> {
            private int index;

            private Entry(int index) {
                this.index = index;
            }

            @Override
            public K getKey() {
                this.checkIndexForEntryUse();
                return IdentityHashMap.unmaskNull(EntryIterator.this.traversalTable[this.index]);
            }

            @Override
            public V getValue() {
                this.checkIndexForEntryUse();
                return EntryIterator.this.traversalTable[this.index + 1];
            }

            @Override
            public V setValue(V value) {
                this.checkIndexForEntryUse();
                Object oldValue = EntryIterator.this.traversalTable[this.index + 1];
                EntryIterator.this.traversalTable[this.index + 1] = value;
                if (EntryIterator.this.traversalTable != IdentityHashMap.this.table) {
                    IdentityHashMap.this.put(EntryIterator.this.traversalTable[this.index], value);
                }
                return oldValue;
            }

            @Override
            public boolean equals(Object o) {
                if (this.index < 0) {
                    return super.equals(o);
                }
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return e.getKey() == IdentityHashMap.unmaskNull(EntryIterator.this.traversalTable[this.index]) && e.getValue() == EntryIterator.this.traversalTable[this.index + 1];
            }

            @Override
            public int hashCode() {
                if (EntryIterator.this.lastReturnedIndex < 0) {
                    return super.hashCode();
                }
                return System.identityHashCode(IdentityHashMap.unmaskNull(EntryIterator.this.traversalTable[this.index])) ^ System.identityHashCode(EntryIterator.this.traversalTable[this.index + 1]);
            }

            public String toString() {
                if (this.index < 0) {
                    return super.toString();
                }
                return IdentityHashMap.unmaskNull(EntryIterator.this.traversalTable[this.index]) + "=" + EntryIterator.this.traversalTable[this.index + 1];
            }

            private void checkIndexForEntryUse() {
                if (this.index < 0) {
                    throw new IllegalStateException("Entry was removed");
                }
            }
        }
    }

    private class ValueIterator
    extends IdentityHashMapIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.traversalTable[this.nextIndex() + 1];
        }
    }

    private class KeyIterator
    extends IdentityHashMapIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return IdentityHashMap.unmaskNull(this.traversalTable[this.nextIndex()]);
        }
    }

    private abstract class IdentityHashMapIterator<T>
    implements Iterator<T> {
        int index;
        int expectedModCount;
        int lastReturnedIndex;
        boolean indexValid;
        Object[] traversalTable;

        private IdentityHashMapIterator() {
            this.index = IdentityHashMap.this.size != 0 ? 0 : IdentityHashMap.this.table.length;
            this.expectedModCount = IdentityHashMap.this.modCount;
            this.lastReturnedIndex = -1;
            this.traversalTable = IdentityHashMap.this.table;
        }

        @Override
        public boolean hasNext() {
            Object[] tab = this.traversalTable;
            for (int i = this.index; i < tab.length; i += 2) {
                Object key = tab[i];
                if (key == null) continue;
                this.index = i;
                this.indexValid = true;
                return true;
            }
            this.index = tab.length;
            return false;
        }

        protected int nextIndex() {
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.indexValid && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexValid = false;
            this.lastReturnedIndex = this.index;
            this.index += 2;
            return this.lastReturnedIndex;
        }

        @Override
        public void remove() {
            Object item;
            if (this.lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.expectedModCount = ++IdentityHashMap.this.modCount;
            int deletedSlot = this.lastReturnedIndex;
            this.lastReturnedIndex = -1;
            this.index = deletedSlot;
            this.indexValid = false;
            Object[] tab = this.traversalTable;
            int len = tab.length;
            int d = deletedSlot;
            Object key = tab[d];
            tab[d] = null;
            tab[d + 1] = null;
            if (tab != IdentityHashMap.this.table) {
                IdentityHashMap.this.remove(key);
                this.expectedModCount = IdentityHashMap.this.modCount;
                return;
            }
            --IdentityHashMap.this.size;
            int i = IdentityHashMap.nextKeyIndex(d, len);
            while ((item = tab[i]) != null) {
                int r = IdentityHashMap.hash(item, len);
                if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                    if (i < deletedSlot && d >= deletedSlot && this.traversalTable == IdentityHashMap.this.table) {
                        int remaining = len - deletedSlot;
                        Object[] newTable = new Object[remaining];
                        System.arraycopy(tab, deletedSlot, newTable, 0, remaining);
                        this.traversalTable = newTable;
                        this.index = 0;
                    }
                    tab[d] = item;
                    tab[d + 1] = tab[i + 1];
                    tab[i] = null;
                    tab[i + 1] = null;
                    d = i;
                }
                i = IdentityHashMap.nextKeyIndex(i, len);
            }
        }
    }
}

