/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

class RegularEnumSet<E extends Enum<E>>
extends EnumSet<E> {
    private static final long serialVersionUID = 3411599620347842686L;
    private long elements = 0L;

    RegularEnumSet(Class<E> elementType, Enum<?>[] universe) {
        super(elementType, universe);
    }

    @Override
    void addRange(E from, E to) {
        this.elements = -1L >>> ((Enum)from).ordinal() - ((Enum)to).ordinal() - 1 << ((Enum)from).ordinal();
    }

    @Override
    void addAll() {
        if (this.universe.length != 0) {
            this.elements = -1L >>> -this.universe.length;
        }
    }

    @Override
    void complement() {
        if (this.universe.length != 0) {
            this.elements ^= 0xFFFFFFFFFFFFFFFFL;
            this.elements &= -1L >>> -this.universe.length;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new EnumSetIterator();
    }

    @Override
    public int size() {
        return Long.bitCount(this.elements);
    }

    @Override
    public boolean isEmpty() {
        return this.elements == 0L;
    }

    @Override
    public boolean contains(Object e) {
        if (e == null) {
            return false;
        }
        Class<?> eClass = e.getClass();
        if (eClass != this.elementType && eClass.getSuperclass() != this.elementType) {
            return false;
        }
        return (this.elements & 1L << ((Enum)e).ordinal()) != 0L;
    }

    @Override
    public boolean add(E e) {
        this.typeCheck(e);
        long oldElements = this.elements;
        this.elements |= 1L << ((Enum)e).ordinal();
        return this.elements != oldElements;
    }

    @Override
    public boolean remove(Object e) {
        if (e == null) {
            return false;
        }
        Class<?> eClass = e.getClass();
        if (eClass != this.elementType && eClass.getSuperclass() != this.elementType) {
            return false;
        }
        long oldElements = this.elements;
        this.elements &= 1L << ((Enum)e).ordinal() ^ 0xFFFFFFFFFFFFFFFFL;
        return this.elements != oldElements;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (!(c instanceof RegularEnumSet)) {
            return super.containsAll(c);
        }
        RegularEnumSet es = (RegularEnumSet)c;
        if (es.elementType != this.elementType) {
            return es.isEmpty();
        }
        return (es.elements & (this.elements ^ 0xFFFFFFFFFFFFFFFFL)) == 0L;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (!(c instanceof RegularEnumSet)) {
            return super.addAll(c);
        }
        RegularEnumSet es = (RegularEnumSet)c;
        if (es.elementType != this.elementType) {
            if (es.isEmpty()) {
                return false;
            }
            throw new ClassCastException(es.elementType + " != " + this.elementType);
        }
        long oldElements = this.elements;
        this.elements |= es.elements;
        return this.elements != oldElements;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (!(c instanceof RegularEnumSet)) {
            return super.removeAll(c);
        }
        RegularEnumSet es = (RegularEnumSet)c;
        if (es.elementType != this.elementType) {
            return false;
        }
        long oldElements = this.elements;
        this.elements &= es.elements ^ 0xFFFFFFFFFFFFFFFFL;
        return this.elements != oldElements;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (!(c instanceof RegularEnumSet)) {
            return super.retainAll(c);
        }
        RegularEnumSet es = (RegularEnumSet)c;
        if (es.elementType != this.elementType) {
            boolean changed = this.elements != 0L;
            this.elements = 0L;
            return changed;
        }
        long oldElements = this.elements;
        this.elements &= es.elements;
        return this.elements != oldElements;
    }

    @Override
    public void clear() {
        this.elements = 0L;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof RegularEnumSet)) {
            return super.equals(o);
        }
        RegularEnumSet es = (RegularEnumSet)o;
        if (es.elementType != this.elementType) {
            return this.elements == 0L && es.elements == 0L;
        }
        return es.elements == this.elements;
    }

    private class EnumSetIterator<E extends Enum<E>>
    implements Iterator<E> {
        long unseen;
        long lastReturned = 0L;

        EnumSetIterator() {
            this.unseen = RegularEnumSet.this.elements;
        }

        @Override
        public boolean hasNext() {
            return this.unseen != 0L;
        }

        @Override
        public E next() {
            if (this.unseen == 0L) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.unseen & -this.unseen;
            this.unseen -= this.lastReturned;
            return (E)RegularEnumSet.this.universe[Long.numberOfTrailingZeros(this.lastReturned)];
        }

        @Override
        public void remove() {
            if (this.lastReturned == 0L) {
                throw new IllegalStateException();
            }
            RegularEnumSet.this.elements = RegularEnumSet.this.elements & (this.lastReturned ^ 0xFFFFFFFFFFFFFFFFL);
            this.lastReturned = 0L;
        }
    }
}

