/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.InvalidOpenTypeException;
import javax.management.openmbean.KeyAlreadyExistsException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;

public class TabularDataSupport
implements TabularData,
Map<Object, Object>,
Cloneable,
Serializable {
    static final long serialVersionUID = 5720150593236309827L;
    private Map<Object, CompositeData> dataMap;
    private final TabularType tabularType;
    private transient String[] indexNamesArray;

    public TabularDataSupport(TabularType tabularType) {
        this(tabularType, 16, 0.75f);
    }

    public TabularDataSupport(TabularType tabularType, int initialCapacity, float loadFactor) {
        if (tabularType == null) {
            throw new IllegalArgumentException("Argument tabularType cannot be null.");
        }
        this.tabularType = tabularType;
        List<String> tmpNames = tabularType.getIndexNames();
        this.indexNamesArray = tmpNames.toArray(new String[tmpNames.size()]);
        String useHashMapProp = AccessController.doPrivileged(new GetPropertyAction("jmx.tabular.data.hash.map"));
        boolean useHashMap = "true".equalsIgnoreCase(useHashMapProp);
        this.dataMap = useHashMap ? new HashMap<Object, CompositeData>(initialCapacity, loadFactor) : new LinkedHashMap(initialCapacity, loadFactor);
    }

    @Override
    public TabularType getTabularType() {
        return this.tabularType;
    }

    @Override
    public Object[] calculateIndex(CompositeData value) {
        this.checkValueType(value);
        return this.internalCalculateIndex(value).toArray();
    }

    @Override
    public boolean containsKey(Object key) {
        Object[] k;
        try {
            k = (Object[])key;
        }
        catch (ClassCastException e) {
            return false;
        }
        return this.containsKey(k);
    }

    @Override
    public boolean containsKey(Object[] key) {
        return key == null ? false : this.dataMap.containsKey(Arrays.asList(key));
    }

    @Override
    public boolean containsValue(CompositeData value) {
        return this.dataMap.containsValue(value);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.dataMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.get((Object[])key);
    }

    @Override
    public CompositeData get(Object[] key) {
        this.checkKeyType(key);
        return this.dataMap.get(Arrays.asList(key));
    }

    @Override
    public Object put(Object key, Object value) {
        this.internalPut((CompositeData)value);
        return value;
    }

    @Override
    public void put(CompositeData value) {
        this.internalPut(value);
    }

    private CompositeData internalPut(CompositeData value) {
        List<?> index = this.checkValueAndIndex(value);
        return this.dataMap.put(index, value);
    }

    @Override
    public Object remove(Object key) {
        return this.remove((Object[])key);
    }

    @Override
    public CompositeData remove(Object[] key) {
        this.checkKeyType(key);
        return this.dataMap.remove(Arrays.asList(key));
    }

    @Override
    public void putAll(Map<?, ?> t) {
        CompositeData[] values;
        if (t == null || t.size() == 0) {
            return;
        }
        try {
            values = t.values().toArray(new CompositeData[t.size()]);
        }
        catch (ArrayStoreException e) {
            throw new ClassCastException("Map argument t contains values which are not instances of <tt>CompositeData</tt>");
        }
        this.putAll(values);
    }

    @Override
    public void putAll(CompositeData[] values) {
        int i;
        if (values == null || values.length == 0) {
            return;
        }
        ArrayList indexes = new ArrayList(values.length + 1);
        for (i = 0; i < values.length; ++i) {
            List<?> index = this.checkValueAndIndex(values[i]);
            if (indexes.contains(index)) {
                throw new KeyAlreadyExistsException("Argument elements values[" + i + "] and values[" + indexes.indexOf(index) + "] have the same indexes, calculated according to this TabularData instance's tabularType.");
            }
            indexes.add(index);
        }
        for (i = 0; i < values.length; ++i) {
            this.dataMap.put(indexes.get(i), values[i]);
        }
    }

    @Override
    public void clear() {
        this.dataMap.clear();
    }

    @Override
    public int size() {
        return this.dataMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<Object> keySet() {
        return this.dataMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return (Collection)Util.cast(this.dataMap.values());
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return (Set)Util.cast(this.dataMap.entrySet());
    }

    public Object clone() {
        try {
            TabularDataSupport c = (TabularDataSupport)super.clone();
            c.dataMap = new HashMap<Object, CompositeData>(c.dataMap);
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString(), e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        TabularData other;
        if (obj == null) {
            return false;
        }
        try {
            other = (TabularData)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (!this.getTabularType().equals(other.getTabularType())) {
            return false;
        }
        if (this.size() != other.size()) {
            return false;
        }
        for (CompositeData value : this.dataMap.values()) {
            if (other.containsValue(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        result += this.tabularType.hashCode();
        for (Object value : this.values()) {
            result += value.hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(tabularType=" + this.tabularType.toString() + ",contents=" + this.dataMap.toString() + ")";
    }

    private List<?> internalCalculateIndex(CompositeData value) {
        return Collections.unmodifiableList(Arrays.asList(value.getAll(this.indexNamesArray)));
    }

    private void checkKeyType(Object[] key) {
        if (key == null || key.length == 0) {
            throw new NullPointerException("Argument key cannot be null or empty.");
        }
        if (key.length != this.indexNamesArray.length) {
            throw new InvalidKeyException("Argument key's length=" + key.length + " is different from the number of item values, which is " + this.indexNamesArray.length + ", specified for the indexing rows in this TabularData instance.");
        }
        for (int i = 0; i < key.length; ++i) {
            OpenType<?> keyElementType = this.tabularType.getRowType().getType(this.indexNamesArray[i]);
            if (key[i] == null || keyElementType.isValue(key[i])) continue;
            throw new InvalidKeyException("Argument element key[" + i + "] is not a value for the open type expected for this element of the index, whose name is \"" + this.indexNamesArray[i] + "\" and whose open type is " + keyElementType);
        }
    }

    private void checkValueType(CompositeData value) {
        if (value == null) {
            throw new NullPointerException("Argument value cannot be null.");
        }
        if (!this.tabularType.getRowType().isValue(value)) {
            throw new InvalidOpenTypeException("Argument value's composite type [" + value.getCompositeType() + "] is not assignable to this TabularData instance's row type [" + this.tabularType.getRowType() + "].");
        }
    }

    private List<?> checkValueAndIndex(CompositeData value) {
        this.checkValueType(value);
        List<?> index = this.internalCalculateIndex(value);
        if (this.dataMap.containsKey(index)) {
            throw new KeyAlreadyExistsException("Argument value's index, calculated according to this TabularData instance's tabularType, already refers to a value in this table.");
        }
        return index;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        List<String> tmpNames = this.tabularType.getIndexNames();
        this.indexNamesArray = tmpNames.toArray(new String[tmpNames.size()]);
    }
}

