/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.security.AccessController;
import java.util.Arrays;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.BytePackedRaster;
import sun.awt.windows.WPrinterJob;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.FontUtilities;
import sun.font.PhysicalFont;
import sun.font.TrueTypeFont;
import sun.print.PathGraphics;
import sun.print.ProxyGraphics2D;
import sun.security.action.GetPropertyAction;

final class WPathGraphics
extends PathGraphics {
    private static final int DEFAULT_USER_RES = 72;
    private static final float MIN_DEVICE_LINEWIDTH = 1.2f;
    private static final float MAX_THINLINE_INCHES = 0.014f;
    private static boolean useGDITextLayout = true;
    private static boolean preferGDITextLayout = false;

    WPathGraphics(Graphics2D graphics, PrinterJob printerJob, Printable painter, PageFormat pageFormat, int pageIndex, boolean canRedraw) {
        super(graphics, printerJob, painter, pageFormat, pageIndex, canRedraw);
    }

    @Override
    public Graphics create() {
        return new WPathGraphics((Graphics2D)this.getDelegate().create(), this.getPrinterJob(), this.getPrintable(), this.getPageFormat(), this.getPageIndex(), this.canDoRedraws());
    }

    @Override
    public void draw(Shape s) {
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke minLineStroke = null;
            BasicStroke lineStroke = (BasicStroke)stroke;
            float lineWidth = lineStroke.getLineWidth();
            Point2D.Float penSize = new Point2D.Float(lineWidth, lineWidth);
            AffineTransform deviceTransform = this.getTransform();
            deviceTransform.deltaTransform(penSize, penSize);
            float deviceLineWidth = Math.min(Math.abs(penSize.x), Math.abs(penSize.y));
            if (deviceLineWidth < 1.2f) {
                Point2D.Float minPenSize = new Point2D.Float(1.2f, 1.2f);
                try {
                    AffineTransform inverse = deviceTransform.createInverse();
                    inverse.deltaTransform(minPenSize, minPenSize);
                    float minLineWidth = Math.max(Math.abs(minPenSize.x), Math.abs(minPenSize.y));
                    minLineStroke = new BasicStroke(minLineWidth, lineStroke.getEndCap(), lineStroke.getLineJoin(), lineStroke.getMiterLimit(), lineStroke.getDashArray(), lineStroke.getDashPhase());
                    this.setStroke(minLineStroke);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
            super.draw(s);
            if (minLineStroke != null) {
                this.setStroke(lineStroke);
            }
        } else {
            super.draw(s);
        }
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        this.drawString(str, x, y, this.getFont(), this.getFontRenderContext(), 0.0f);
    }

    @Override
    protected int platformFontCount(Font font, String str) {
        boolean directToGDI;
        AffineTransform deviceTransform = this.getTransform();
        AffineTransform fontTransform = new AffineTransform(deviceTransform);
        fontTransform.concatenate(this.getFont().getTransform());
        int transformType = fontTransform.getType();
        boolean bl = directToGDI = transformType != 32 && (transformType & 0x40) == 0;
        if (!directToGDI) {
            return 0;
        }
        Font2D font2D = FontUtilities.getFont2D(font);
        if (font2D instanceof CompositeFont || font2D instanceof TrueTypeFont) {
            return 1;
        }
        return 0;
    }

    private static boolean isXP() {
        String osVersion = System.getProperty("os.version");
        if (osVersion != null) {
            Float version = Float.valueOf(osVersion);
            return version.floatValue() >= 5.1f;
        }
        return false;
    }

    private boolean strNeedsTextLayout(String str, Font font) {
        char[] chars = str.toCharArray();
        boolean isComplex = FontUtilities.isComplexText(chars, 0, chars.length);
        if (!isComplex) {
            return false;
        }
        if (!useGDITextLayout) {
            return true;
        }
        return !preferGDITextLayout && (!WPathGraphics.isXP() || !FontUtilities.textLayoutIsCompatible(font));
    }

    private int getAngle(Point2D.Double pt) {
        double angle = Math.toDegrees(Math.atan2(pt.y, pt.x));
        if (angle < 0.0) {
            angle += 360.0;
        }
        if (angle != 0.0) {
            angle = 360.0 - angle;
        }
        return (int)Math.round(angle * 10.0);
    }

    private float getAwScale(double scaleFactorX, double scaleFactorY) {
        float awScale = (float)(scaleFactorX / scaleFactorY);
        if (awScale > 0.999f && awScale < 1.001f) {
            awScale = 1.0f;
        }
        return awScale;
    }

    @Override
    public void drawString(String str, float x, float y, Font font, FontRenderContext frc, float targetW) {
        if (str.length() == 0) {
            return;
        }
        if (WPrinterJob.shapeTextProp) {
            super.drawString(str, x, y, font, frc, targetW);
            return;
        }
        boolean layoutNeeded = this.strNeedsTextLayout(str, font);
        if ((font.hasLayoutAttributes() || layoutNeeded) && !this.printingGlyphVector) {
            TextLayout layout = new TextLayout(str, font, frc);
            layout.draw(this, x, y);
            return;
        }
        if (layoutNeeded) {
            super.drawString(str, x, y, font, frc, targetW);
            return;
        }
        AffineTransform deviceTransform = this.getTransform();
        AffineTransform fontTransform = new AffineTransform(deviceTransform);
        fontTransform.concatenate(font.getTransform());
        int transformType = fontTransform.getType();
        boolean directToGDI = transformType != 32 && (transformType & 0x40) == 0;
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        try {
            wPrinterJob.setTextColor((Color)this.getPaint());
        }
        catch (ClassCastException e) {
            directToGDI = false;
        }
        if (!directToGDI) {
            super.drawString(str, x, y, font, frc, targetW);
            return;
        }
        Point2D.Float userpos = new Point2D.Float(x, y);
        Point2D.Float devpos = new Point2D.Float();
        if (font.isTransformed()) {
            AffineTransform fontTx = font.getTransform();
            float translateX = (float)fontTx.getTranslateX();
            float translateY = (float)fontTx.getTranslateY();
            if ((double)Math.abs(translateX) < 1.0E-5) {
                translateX = 0.0f;
            }
            if ((double)Math.abs(translateY) < 1.0E-5) {
                translateY = 0.0f;
            }
            userpos.x += translateX;
            userpos.y += translateY;
        }
        deviceTransform.transform(userpos, devpos);
        if (this.getClip() != null) {
            this.deviceClip(this.getClip().getPathIterator(deviceTransform));
        }
        float fontSize = font.getSize2D();
        double devResX = wPrinterJob.getXRes();
        double devResY = wPrinterJob.getYRes();
        double fontDevScaleY = devResY / 72.0;
        int orient = this.getPageFormat().getOrientation();
        if (orient == 0 || orient == 2) {
            double tmp = devResX;
            devResX = devResY;
            devResY = tmp;
        }
        double devScaleX = devResX / 72.0;
        double devScaleY = devResY / 72.0;
        fontTransform.scale(1.0 / devScaleX, 1.0 / devScaleY);
        Point2D.Double pty = new Point2D.Double(0.0, 1.0);
        fontTransform.deltaTransform(pty, pty);
        double scaleFactorY = Math.sqrt(pty.x * pty.x + pty.y * pty.y);
        float scaledFontSizeY = (float)((double)fontSize * scaleFactorY * fontDevScaleY);
        Point2D.Double ptx = new Point2D.Double(1.0, 0.0);
        fontTransform.deltaTransform(ptx, ptx);
        double scaleFactorX = Math.sqrt(ptx.x * ptx.x + ptx.y * ptx.y);
        float awScale = this.getAwScale(scaleFactorX, scaleFactorY);
        int iangle = this.getAngle(ptx);
        ptx = new Point2D.Double(1.0, 0.0);
        deviceTransform.deltaTransform(ptx, ptx);
        double advanceScaleX = Math.sqrt(ptx.x * ptx.x + ptx.y * ptx.y);
        pty = new Point2D.Double(0.0, 1.0);
        deviceTransform.deltaTransform(pty, pty);
        double advanceScaleY = Math.sqrt(pty.x * pty.x + pty.y * pty.y);
        Font2D font2D = FontUtilities.getFont2D(font);
        if (font2D instanceof TrueTypeFont) {
            this.textOut(str, font, (TrueTypeFont)font2D, frc, scaledFontSizeY, iangle, awScale, advanceScaleX, advanceScaleY, x, y, devpos.x, devpos.y, targetW);
        } else if (font2D instanceof CompositeFont) {
            CompositeFont compFont = (CompositeFont)font2D;
            float userx = x;
            float usery = y;
            float devx = devpos.x;
            float devy = devpos.y;
            char[] chars = str.toCharArray();
            int len = chars.length;
            int[] glyphs = new int[len];
            compFont.getMapper().charsToGlyphs(len, chars, glyphs);
            int startChar = 0;
            int endChar = 0;
            int slot = 0;
            while (endChar < len) {
                startChar = endChar;
                slot = glyphs[startChar] >>> 24;
                while (endChar < len && glyphs[endChar] >>> 24 == slot) {
                    ++endChar;
                }
                String substr = new String(chars, startChar, endChar - startChar);
                PhysicalFont slotFont = compFont.getSlotFont(slot);
                this.textOut(substr, font, slotFont, frc, scaledFontSizeY, iangle, awScale, advanceScaleX, advanceScaleY, userx, usery, devx, devy, 0.0f);
                Rectangle2D bds = font.getStringBounds(substr, frc);
                float xAdvance = (float)bds.getWidth();
                userx += xAdvance;
                userpos.x += xAdvance;
                deviceTransform.transform(userpos, devpos);
                devx = devpos.x;
                devy = devpos.y;
            }
        } else {
            super.drawString(str, x, y, font, frc, targetW);
        }
    }

    @Override
    protected boolean printGlyphVector(GlyphVector gv, float x, float y) {
        if ((gv.getLayoutFlags() & 1) != 0) {
            return false;
        }
        if (gv.getNumGlyphs() == 0) {
            return true;
        }
        AffineTransform deviceTransform = this.getTransform();
        AffineTransform fontTransform = new AffineTransform(deviceTransform);
        Font font = gv.getFont();
        fontTransform.concatenate(font.getTransform());
        int transformType = fontTransform.getType();
        boolean directToGDI = transformType != 32 && (transformType & 0x40) == 0;
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        try {
            wPrinterJob.setTextColor((Color)this.getPaint());
        }
        catch (ClassCastException e) {
            directToGDI = false;
        }
        if (WPrinterJob.shapeTextProp || !directToGDI) {
            return false;
        }
        Point2D.Float userpos = new Point2D.Float(x, y);
        Point2D g0pos = gv.getGlyphPosition(0);
        userpos.x += (float)g0pos.getX();
        userpos.y += (float)g0pos.getY();
        Point2D.Float devpos = new Point2D.Float();
        if (font.isTransformed()) {
            AffineTransform fontTx = font.getTransform();
            float translateX = (float)fontTx.getTranslateX();
            float translateY = (float)fontTx.getTranslateY();
            if ((double)Math.abs(translateX) < 1.0E-5) {
                translateX = 0.0f;
            }
            if ((double)Math.abs(translateY) < 1.0E-5) {
                translateY = 0.0f;
            }
            userpos.x += translateX;
            userpos.y += translateY;
        }
        deviceTransform.transform(userpos, devpos);
        if (this.getClip() != null) {
            this.deviceClip(this.getClip().getPathIterator(deviceTransform));
        }
        float fontSize = font.getSize2D();
        double devResX = wPrinterJob.getXRes();
        double devResY = wPrinterJob.getYRes();
        double fontDevScaleY = devResY / 72.0;
        int orient = this.getPageFormat().getOrientation();
        if (orient == 0 || orient == 2) {
            double tmp = devResX;
            devResX = devResY;
            devResY = tmp;
        }
        double devScaleX = devResX / 72.0;
        double devScaleY = devResY / 72.0;
        fontTransform.scale(1.0 / devScaleX, 1.0 / devScaleY);
        Point2D.Double pty = new Point2D.Double(0.0, 1.0);
        fontTransform.deltaTransform(pty, pty);
        double scaleFactorY = Math.sqrt(pty.x * pty.x + pty.y * pty.y);
        float scaledFontSizeY = (float)((double)fontSize * scaleFactorY * fontDevScaleY);
        Point2D.Double ptx = new Point2D.Double(1.0, 0.0);
        fontTransform.deltaTransform(ptx, ptx);
        double scaleFactorX = Math.sqrt(ptx.x * ptx.x + ptx.y * ptx.y);
        float awScale = this.getAwScale(scaleFactorX, scaleFactorY);
        int iangle = this.getAngle(ptx);
        ptx = new Point2D.Double(1.0, 0.0);
        deviceTransform.deltaTransform(ptx, ptx);
        double advanceScaleX = Math.sqrt(ptx.x * ptx.x + ptx.y * ptx.y);
        pty = new Point2D.Double(0.0, 1.0);
        deviceTransform.deltaTransform(pty, pty);
        double advanceScaleY = Math.sqrt(pty.x * pty.x + pty.y * pty.y);
        int numGlyphs = gv.getNumGlyphs();
        int[] glyphCodes = gv.getGlyphCodes(0, numGlyphs, null);
        float[] glyphPos = gv.getGlyphPositions(0, numGlyphs, null);
        int invisibleGlyphCnt = 0;
        for (int gc = 0; gc < numGlyphs; ++gc) {
            if ((glyphCodes[gc] & 0xFFFF) < 65534) continue;
            ++invisibleGlyphCnt;
        }
        if (invisibleGlyphCnt > 0) {
            int visibleGlyphCnt = numGlyphs - invisibleGlyphCnt;
            int[] visibleGlyphCodes = new int[visibleGlyphCnt];
            float[] visiblePositions = new float[visibleGlyphCnt * 2];
            int index = 0;
            for (int i = 0; i < numGlyphs; ++i) {
                if ((glyphCodes[i] & 0xFFFF) >= 65534) continue;
                visibleGlyphCodes[index] = glyphCodes[i];
                visiblePositions[index * 2] = glyphPos[i * 2];
                visiblePositions[index * 2 + 1] = glyphPos[i * 2 + 1];
                ++index;
            }
            numGlyphs = visibleGlyphCnt;
            glyphCodes = visibleGlyphCodes;
            glyphPos = visiblePositions;
        }
        AffineTransform advanceTransform = AffineTransform.getScaleInstance(advanceScaleX, advanceScaleY);
        float[] glyphAdvPos = new float[glyphPos.length];
        advanceTransform.transform(glyphPos, 0, glyphAdvPos, 0, glyphPos.length / 2);
        Font2D font2D = FontUtilities.getFont2D(font);
        if (font2D instanceof TrueTypeFont) {
            int style;
            String family = font2D.getFamilyName(null);
            if (!wPrinterJob.setFont(family, scaledFontSizeY, style = font.getStyle() | font2D.getStyle(), iangle, awScale)) {
                return false;
            }
            wPrinterJob.glyphsOut(glyphCodes, devpos.x, devpos.y, glyphAdvPos);
        } else if (font2D instanceof CompositeFont) {
            CompositeFont compFont = (CompositeFont)font2D;
            float userx = x;
            float usery = y;
            float devx = devpos.x;
            float devy = devpos.y;
            int start = 0;
            int end = 0;
            int slot = 0;
            while (end < numGlyphs) {
                int style;
                start = end;
                slot = glyphCodes[start] >>> 24;
                while (end < numGlyphs && glyphCodes[end] >>> 24 == slot) {
                    ++end;
                }
                PhysicalFont slotFont = compFont.getSlotFont(slot);
                if (!(slotFont instanceof TrueTypeFont)) {
                    return false;
                }
                String family = slotFont.getFamilyName(null);
                if (!wPrinterJob.setFont(family, scaledFontSizeY, style = font.getStyle() | slotFont.getStyle(), iangle, awScale)) {
                    return false;
                }
                int[] glyphs = Arrays.copyOfRange(glyphCodes, start, end);
                float[] posns = Arrays.copyOfRange(glyphAdvPos, start * 2, end * 2);
                if (start != 0) {
                    Point2D.Float p = new Point2D.Float(x + glyphPos[start * 2], y + glyphPos[start * 2 + 1]);
                    deviceTransform.transform(p, p);
                    devx = p.x;
                    devy = p.y;
                }
                wPrinterJob.glyphsOut(glyphs, devx, devy, posns);
            }
        } else {
            return false;
        }
        return true;
    }

    private void textOut(String str, Font font, PhysicalFont font2D, FontRenderContext frc, float deviceSize, int rotation, float awScale, double scaleFactorX, double scaleFactorY, float userx, float usery, float devx, float devy, float targetW) {
        String family = font2D.getFamilyName(null);
        int style = font.getStyle() | font2D.getStyle();
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        boolean setFont = wPrinterJob.setFont(family, deviceSize, style, rotation, awScale);
        if (!setFont) {
            super.drawString(str, userx, usery, font, frc, targetW);
            return;
        }
        float[] glyphPos = null;
        if (!this.okGDIMetrics(str, font, frc, scaleFactorX)) {
            str = wPrinterJob.removeControlChars(str);
            char[] chars = str.toCharArray();
            int len = chars.length;
            GlyphVector gv = null;
            if (!FontUtilities.isComplexText(chars, 0, len)) {
                gv = font.createGlyphVector(frc, str);
            }
            if (gv == null) {
                super.drawString(str, userx, usery, font, frc, targetW);
                return;
            }
            glyphPos = gv.getGlyphPositions(0, len, null);
            Point2D gvAdvPt = gv.getGlyphPosition(gv.getNumGlyphs());
            AffineTransform advanceTransform = AffineTransform.getScaleInstance(scaleFactorX, scaleFactorY);
            float[] glyphAdvPos = new float[glyphPos.length];
            advanceTransform.transform(glyphPos, 0, glyphAdvPos, 0, glyphPos.length / 2);
            glyphPos = glyphAdvPos;
        }
        wPrinterJob.textOut(str, devx, devy, glyphPos);
    }

    private boolean okGDIMetrics(String str, Font font, FontRenderContext frc, double scaleX) {
        Rectangle2D bds = font.getStringBounds(str, frc);
        double jdkAdvance = bds.getWidth();
        jdkAdvance = Math.round(jdkAdvance * scaleX);
        int gdiAdvance = ((WPrinterJob)this.getPrinterJob()).getGDIAdvance(str);
        if (jdkAdvance > 0.0 && gdiAdvance > 0) {
            double diff = Math.abs((double)gdiAdvance - jdkAdvance);
            double ratio = (double)gdiAdvance / jdkAdvance;
            if (ratio < 1.0) {
                ratio = 1.0 / ratio;
            }
            return diff <= 1.0 || ratio < 1.01;
        }
        return true;
    }

    @Override
    protected boolean drawImageToPlatform(Image image, AffineTransform xform, Color bgcolor, int srcX, int srcY, int srcWidth, int srcHeight, boolean handlingTransparency) {
        boolean clampScale;
        BufferedImage img = this.getBufferedImage(image);
        if (img == null) {
            return true;
        }
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        AffineTransform fullTransform = this.getTransform();
        if (xform == null) {
            xform = new AffineTransform();
        }
        fullTransform.concatenate(xform);
        double[] fullMatrix = new double[6];
        fullTransform.getMatrix(fullMatrix);
        Point2D.Float unitVectorX = new Point2D.Float(1.0f, 0.0f);
        Point2D.Float unitVectorY = new Point2D.Float(0.0f, 1.0f);
        fullTransform.deltaTransform(unitVectorX, unitVectorX);
        fullTransform.deltaTransform(unitVectorY, unitVectorY);
        Point2D.Float origin = new Point2D.Float(0.0f, 0.0f);
        double scaleX = unitVectorX.distance(origin);
        double scaleY = unitVectorY.distance(origin);
        double devResX = wPrinterJob.getXRes();
        double devResY = wPrinterJob.getYRes();
        double devScaleX = devResX / 72.0;
        double devScaleY = devResY / 72.0;
        int transformType = fullTransform.getType();
        boolean bl = clampScale = (transformType & 0x30) != 0;
        if (clampScale) {
            if (scaleX > devScaleX) {
                scaleX = devScaleX;
            }
            if (scaleY > devScaleY) {
                scaleY = devScaleY;
            }
        }
        if (scaleX != 0.0 && scaleY != 0.0) {
            AffineTransform rotTransform = new AffineTransform(fullMatrix[0] / scaleX, fullMatrix[1] / scaleY, fullMatrix[2] / scaleX, fullMatrix[3] / scaleY, fullMatrix[4] / scaleX, fullMatrix[5] / scaleY);
            Rectangle2D.Float srcRect = new Rectangle2D.Float(srcX, srcY, srcWidth, srcHeight);
            Shape rotShape = rotTransform.createTransformedShape(srcRect);
            Rectangle2D rotBounds = rotShape.getBounds2D();
            rotBounds.setRect(rotBounds.getX(), rotBounds.getY(), rotBounds.getWidth() + 0.001, rotBounds.getHeight() + 0.001);
            int boundsWidth = (int)rotBounds.getWidth();
            int boundsHeight = (int)rotBounds.getHeight();
            if (boundsWidth > 0 && boundsHeight > 0) {
                byte[] data;
                boolean drawOpaque = true;
                if (!handlingTransparency && this.hasTransparentPixels(img)) {
                    drawOpaque = false;
                    if (this.isBitmaskTransparency(img)) {
                        if (bgcolor == null) {
                            if (this.drawBitmaskImage(img, xform, bgcolor, srcX, srcY, srcWidth, srcHeight)) {
                                return true;
                            }
                        } else if (bgcolor.getTransparency() == 1) {
                            drawOpaque = true;
                        }
                    }
                    if (!this.canDoRedraws()) {
                        drawOpaque = true;
                    }
                } else {
                    bgcolor = null;
                }
                if ((srcX + srcWidth > img.getWidth(null) || srcY + srcHeight > img.getHeight(null)) && this.canDoRedraws()) {
                    drawOpaque = false;
                }
                if (!drawOpaque) {
                    fullTransform.getMatrix(fullMatrix);
                    AffineTransform tx = new AffineTransform(fullMatrix[0] / devScaleX, fullMatrix[1] / devScaleY, fullMatrix[2] / devScaleX, fullMatrix[3] / devScaleY, fullMatrix[4] / devScaleX, fullMatrix[5] / devScaleY);
                    Rectangle2D.Float rect = new Rectangle2D.Float(srcX, srcY, srcWidth, srcHeight);
                    Shape shape = fullTransform.createTransformedShape(rect);
                    Rectangle2D region = shape.getBounds2D();
                    region.setRect(region.getX(), region.getY(), region.getWidth() + 0.001, region.getHeight() + 0.001);
                    int w = (int)region.getWidth();
                    int h = (int)region.getHeight();
                    int nbytes = w * h * 3;
                    int maxBytes = 0x800000;
                    double origDpi = devResX < devResY ? devResX : devResY;
                    int dpi = (int)origDpi;
                    double scaleFactor = 1.0;
                    double maxSFX = (double)w / (double)boundsWidth;
                    double maxSFY = (double)h / (double)boundsHeight;
                    double maxSF = maxSFX > maxSFY ? maxSFY : maxSFX;
                    int minDpi = (int)((double)dpi / maxSF);
                    if (minDpi < 72) {
                        minDpi = 72;
                    }
                    while (nbytes > maxBytes && dpi > minDpi) {
                        scaleFactor *= 2.0;
                        dpi /= 2;
                        nbytes /= 4;
                    }
                    if (dpi < minDpi) {
                        scaleFactor = origDpi / (double)minDpi;
                    }
                    region.setRect(region.getX() / scaleFactor, region.getY() / scaleFactor, region.getWidth() / scaleFactor, region.getHeight() / scaleFactor);
                    wPrinterJob.saveState(this.getTransform(), this.getClip(), region, scaleFactor, scaleFactor);
                    return true;
                }
                int dibType = 5;
                IndexColorModel icm = null;
                ColorModel cm = img.getColorModel();
                int imgType = img.getType();
                if (cm instanceof IndexColorModel && cm.getPixelSize() <= 8 && (imgType == 12 || imgType == 13)) {
                    icm = (IndexColorModel)cm;
                    dibType = imgType;
                    if (imgType == 12 && cm.getPixelSize() == 2) {
                        int[] rgbs = new int[16];
                        icm.getRGBs(rgbs);
                        boolean transparent = icm.getTransparency() != 1;
                        int transpixel = icm.getTransparentPixel();
                        icm = new IndexColorModel(4, 16, rgbs, 0, transparent, transpixel, 0);
                    }
                }
                int iw = (int)rotBounds.getWidth();
                int ih = (int)rotBounds.getHeight();
                BufferedImage deepImage = null;
                boolean newImage = true;
                if (newImage) {
                    deepImage = icm == null ? new BufferedImage(iw, ih, dibType) : new BufferedImage(iw, ih, dibType, icm);
                    Graphics2D imageGraphics = deepImage.createGraphics();
                    imageGraphics.clipRect(0, 0, deepImage.getWidth(), deepImage.getHeight());
                    imageGraphics.translate(-rotBounds.getX(), -rotBounds.getY());
                    imageGraphics.transform(rotTransform);
                    if (bgcolor == null) {
                        bgcolor = Color.white;
                    }
                    imageGraphics.drawImage(img, srcX, srcY, srcX + srcWidth, srcY + srcHeight, srcX, srcY, srcX + srcWidth, srcY + srcHeight, bgcolor, null);
                    imageGraphics.dispose();
                } else {
                    deepImage = img;
                }
                Rectangle2D.Float scaledBounds = new Rectangle2D.Float((float)(rotBounds.getX() * scaleX), (float)(rotBounds.getY() * scaleY), (float)(rotBounds.getWidth() * scaleX), (float)(rotBounds.getHeight() * scaleY));
                WritableRaster raster = deepImage.getRaster();
                if (raster instanceof ByteComponentRaster) {
                    data = ((ByteComponentRaster)raster).getDataStorage();
                } else if (raster instanceof BytePackedRaster) {
                    data = ((BytePackedRaster)raster).getDataStorage();
                } else {
                    return false;
                }
                int bitsPerPixel = 24;
                SampleModel sm = deepImage.getSampleModel();
                if (sm instanceof ComponentSampleModel) {
                    ComponentSampleModel csm = (ComponentSampleModel)sm;
                    bitsPerPixel = csm.getPixelStride() * 8;
                } else if (sm instanceof MultiPixelPackedSampleModel) {
                    MultiPixelPackedSampleModel mppsm = (MultiPixelPackedSampleModel)sm;
                    bitsPerPixel = mppsm.getPixelBitStride();
                } else if (icm != null) {
                    int diw = deepImage.getWidth();
                    int dih = deepImage.getHeight();
                    if (diw > 0 && dih > 0) {
                        bitsPerPixel = data.length * 8 / diw / dih;
                    }
                }
                Shape holdClip = this.getClip();
                this.clip(xform.createTransformedShape(srcRect));
                this.deviceClip(this.getClip().getPathIterator(this.getTransform()));
                wPrinterJob.drawDIBImage(data, scaledBounds.x, scaledBounds.y, (float)Math.rint((double)scaledBounds.width + 0.5), (float)Math.rint((double)scaledBounds.height + 0.5), 0.0f, 0.0f, deepImage.getWidth(), deepImage.getHeight(), bitsPerPixel, icm);
                this.setClip(holdClip);
            }
        }
        return true;
    }

    @Override
    public void redrawRegion(Rectangle2D region, double scaleX, double scaleY, Shape savedClip, AffineTransform savedTransform) throws PrinterException {
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        Printable painter = this.getPrintable();
        PageFormat pageFormat = this.getPageFormat();
        int pageIndex = this.getPageIndex();
        BufferedImage deepImage = new BufferedImage((int)region.getWidth(), (int)region.getHeight(), 5);
        Graphics2D g = deepImage.createGraphics();
        ProxyGraphics2D proxy = new ProxyGraphics2D(g, wPrinterJob);
        proxy.setColor(Color.white);
        proxy.fillRect(0, 0, deepImage.getWidth(), deepImage.getHeight());
        proxy.clipRect(0, 0, deepImage.getWidth(), deepImage.getHeight());
        proxy.translate(-region.getX(), -region.getY());
        float sourceResX = (float)(wPrinterJob.getXRes() / scaleX);
        float sourceResY = (float)(wPrinterJob.getYRes() / scaleY);
        proxy.scale(sourceResX / 72.0f, sourceResY / 72.0f);
        proxy.translate(-wPrinterJob.getPhysicalPrintableX(pageFormat.getPaper()) / wPrinterJob.getXRes() * 72.0, -wPrinterJob.getPhysicalPrintableY(pageFormat.getPaper()) / wPrinterJob.getYRes() * 72.0);
        proxy.transform(new AffineTransform(this.getPageFormat().getMatrix()));
        proxy.setPaint(Color.black);
        painter.print(proxy, pageFormat, pageIndex);
        g.dispose();
        if (savedClip != null) {
            this.deviceClip(savedClip.getPathIterator(savedTransform));
        }
        Rectangle2D.Float scaledBounds = new Rectangle2D.Float((float)(region.getX() * scaleX), (float)(region.getY() * scaleY), (float)(region.getWidth() * scaleX), (float)(region.getHeight() * scaleY));
        ByteComponentRaster tile = (ByteComponentRaster)deepImage.getRaster();
        wPrinterJob.drawImage3ByteBGR(tile.getDataStorage(), scaledBounds.x, scaledBounds.y, scaledBounds.width, scaledBounds.height, 0.0f, 0.0f, deepImage.getWidth(), deepImage.getHeight());
    }

    @Override
    protected void deviceFill(PathIterator pathIter, Color color) {
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        this.convertToWPath(pathIter);
        wPrinterJob.selectSolidBrush(color);
        wPrinterJob.fillPath();
    }

    @Override
    protected void deviceClip(PathIterator pathIter) {
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        this.convertToWPath(pathIter);
        wPrinterJob.selectClipPath();
    }

    @Override
    protected void deviceFrameRect(int x, int y, int width, int height, Color color) {
        boolean usePath;
        AffineTransform deviceTransform = this.getTransform();
        int transformType = deviceTransform.getType();
        boolean bl = usePath = (transformType & 0x30) != 0;
        if (usePath) {
            this.draw(new Rectangle2D.Float(x, y, width, height));
            return;
        }
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke lineStroke = (BasicStroke)stroke;
            int endCap = lineStroke.getEndCap();
            int lineJoin = lineStroke.getLineJoin();
            if (endCap == 2 && lineJoin == 0 && lineStroke.getMiterLimit() == 10.0f) {
                float lineWidth = lineStroke.getLineWidth();
                Point2D.Float penSize = new Point2D.Float(lineWidth, lineWidth);
                deviceTransform.deltaTransform(penSize, penSize);
                float deviceLineWidth = Math.min(Math.abs(penSize.x), Math.abs(penSize.y));
                Point2D.Float ul_pos = new Point2D.Float(x, y);
                deviceTransform.transform(ul_pos, ul_pos);
                Point2D.Float lr_pos = new Point2D.Float(x + width, y + height);
                deviceTransform.transform(lr_pos, lr_pos);
                float w = (float)(lr_pos.getX() - ul_pos.getX());
                float h = (float)(lr_pos.getY() - ul_pos.getY());
                WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
                if (wPrinterJob.selectStylePen(endCap, lineJoin, deviceLineWidth, color)) {
                    wPrinterJob.frameRect((float)ul_pos.getX(), (float)ul_pos.getY(), w, h);
                } else {
                    double lowerRes = Math.min(wPrinterJob.getXRes(), wPrinterJob.getYRes());
                    if ((double)deviceLineWidth / lowerRes < (double)0.014f) {
                        wPrinterJob.selectPen(deviceLineWidth, color);
                        wPrinterJob.frameRect((float)ul_pos.getX(), (float)ul_pos.getY(), w, h);
                    } else {
                        this.draw(new Rectangle2D.Float(x, y, width, height));
                    }
                }
            } else {
                this.draw(new Rectangle2D.Float(x, y, width, height));
            }
        }
    }

    @Override
    protected void deviceFillRect(int x, int y, int width, int height, Color color) {
        boolean usePath;
        AffineTransform deviceTransform = this.getTransform();
        int transformType = deviceTransform.getType();
        boolean bl = usePath = (transformType & 0x30) != 0;
        if (usePath) {
            this.fill(new Rectangle2D.Float(x, y, width, height));
            return;
        }
        Point2D.Float tlc_pos = new Point2D.Float(x, y);
        deviceTransform.transform(tlc_pos, tlc_pos);
        Point2D.Float brc_pos = new Point2D.Float(x + width, y + height);
        deviceTransform.transform(brc_pos, brc_pos);
        float deviceWidth = (float)(brc_pos.getX() - tlc_pos.getX());
        float deviceHeight = (float)(brc_pos.getY() - tlc_pos.getY());
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        wPrinterJob.fillRect((float)tlc_pos.getX(), (float)tlc_pos.getY(), deviceWidth, deviceHeight, color);
    }

    @Override
    protected void deviceDrawLine(int xBegin, int yBegin, int xEnd, int yEnd, Color color) {
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            WPrinterJob wPrinterJob;
            BasicStroke lineStroke = (BasicStroke)stroke;
            if (lineStroke.getDashArray() != null) {
                this.draw(new Line2D.Float(xBegin, yBegin, xEnd, yEnd));
                return;
            }
            float lineWidth = lineStroke.getLineWidth();
            Point2D.Float penSize = new Point2D.Float(lineWidth, lineWidth);
            AffineTransform deviceTransform = this.getTransform();
            deviceTransform.deltaTransform(penSize, penSize);
            float deviceLineWidth = Math.min(Math.abs(penSize.x), Math.abs(penSize.y));
            Point2D.Float begin_pos = new Point2D.Float(xBegin, yBegin);
            deviceTransform.transform(begin_pos, begin_pos);
            Point2D.Float end_pos = new Point2D.Float(xEnd, yEnd);
            deviceTransform.transform(end_pos, end_pos);
            int endCap = lineStroke.getEndCap();
            int lineJoin = lineStroke.getLineJoin();
            if (end_pos.getX() == begin_pos.getX() && end_pos.getY() == begin_pos.getY()) {
                endCap = 1;
            }
            if ((wPrinterJob = (WPrinterJob)this.getPrinterJob()).selectStylePen(endCap, lineJoin, deviceLineWidth, color)) {
                wPrinterJob.moveTo((float)begin_pos.getX(), (float)begin_pos.getY());
                wPrinterJob.lineTo((float)end_pos.getX(), (float)end_pos.getY());
            } else {
                double lowerRes = Math.min(wPrinterJob.getXRes(), wPrinterJob.getYRes());
                if (endCap == 1 || (xBegin == xEnd || yBegin == yEnd) && (double)deviceLineWidth / lowerRes < (double)0.014f) {
                    wPrinterJob.selectPen(deviceLineWidth, color);
                    wPrinterJob.moveTo((float)begin_pos.getX(), (float)begin_pos.getY());
                    wPrinterJob.lineTo((float)end_pos.getX(), (float)end_pos.getY());
                } else {
                    this.draw(new Line2D.Float(xBegin, yBegin, xEnd, yEnd));
                }
            }
        }
    }

    private void convertToWPath(PathIterator pathIter) {
        float[] segment = new float[6];
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        int polyFillRule = pathIter.getWindingRule() == 0 ? 1 : 2;
        wPrinterJob.setPolyFillMode(polyFillRule);
        wPrinterJob.beginPath();
        while (!pathIter.isDone()) {
            int segmentType = pathIter.currentSegment(segment);
            switch (segmentType) {
                case 0: {
                    wPrinterJob.moveTo(segment[0], segment[1]);
                    break;
                }
                case 1: {
                    wPrinterJob.lineTo(segment[0], segment[1]);
                    break;
                }
                case 2: {
                    int lastX = wPrinterJob.getPenX();
                    int lastY = wPrinterJob.getPenY();
                    float c1x = (float)lastX + (segment[0] - (float)lastX) * 2.0f / 3.0f;
                    float c1y = (float)lastY + (segment[1] - (float)lastY) * 2.0f / 3.0f;
                    float c2x = segment[2] - (segment[2] - segment[0]) * 2.0f / 3.0f;
                    float c2y = segment[3] - (segment[3] - segment[1]) * 2.0f / 3.0f;
                    wPrinterJob.polyBezierTo(c1x, c1y, c2x, c2y, segment[2], segment[3]);
                    break;
                }
                case 3: {
                    wPrinterJob.polyBezierTo(segment[0], segment[1], segment[2], segment[3], segment[4], segment[5]);
                    break;
                }
                case 4: {
                    wPrinterJob.closeFigure();
                }
            }
            pathIter.next();
        }
        wPrinterJob.endPath();
    }

    static {
        String textLayoutStr = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.print.enableGDITextLayout"));
        if (textLayoutStr != null && !(useGDITextLayout = Boolean.getBoolean(textLayoutStr)) && textLayoutStr.equalsIgnoreCase("prefer")) {
            useGDITextLayout = true;
            preferGDITextLayout = true;
        }
    }
}

