/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileLock;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sun.nio.ch.FileLockImpl;
import sun.nio.ch.FileLockTable;

abstract class AsynchronousFileChannelImpl
extends AsynchronousFileChannel {
    protected final ReadWriteLock closeLock = new ReentrantReadWriteLock();
    protected volatile boolean closed;
    protected final FileDescriptor fdObj;
    protected final boolean reading;
    protected final boolean writing;
    protected final ExecutorService executor;
    private volatile FileLockTable fileLockTable;

    protected AsynchronousFileChannelImpl(FileDescriptor fdObj, boolean reading, boolean writing, ExecutorService executor) {
        this.fdObj = fdObj;
        this.reading = reading;
        this.writing = writing;
        this.executor = executor;
    }

    final ExecutorService executor() {
        return this.executor;
    }

    @Override
    public final boolean isOpen() {
        return !this.closed;
    }

    protected final void begin() throws IOException {
        this.closeLock.readLock().lock();
        if (this.closed) {
            throw new ClosedChannelException();
        }
    }

    protected final void end() {
        this.closeLock.readLock().unlock();
    }

    protected final void end(boolean completed) throws IOException {
        this.end();
        if (!completed && !this.isOpen()) {
            throw new AsynchronousCloseException();
        }
    }

    abstract <A> Future<FileLock> implLock(long var1, long var3, boolean var5, A var6, CompletionHandler<FileLock, ? super A> var7);

    @Override
    public final Future<FileLock> lock(long position, long size, boolean shared) {
        return this.implLock(position, size, shared, null, null);
    }

    @Override
    public final <A> void lock(long position, long size, boolean shared, A attachment, CompletionHandler<FileLock, ? super A> handler) {
        if (handler == null) {
            throw new NullPointerException("'handler' is null");
        }
        this.implLock(position, size, shared, attachment, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureFileLockTableInitialized() throws IOException {
        if (this.fileLockTable == null) {
            AsynchronousFileChannelImpl asynchronousFileChannelImpl = this;
            synchronized (asynchronousFileChannelImpl) {
                if (this.fileLockTable == null) {
                    this.fileLockTable = FileLockTable.newSharedFileLockTable(this, this.fdObj);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void invalidateAllLocks() throws IOException {
        if (this.fileLockTable != null) {
            Iterator<FileLock> iterator = this.fileLockTable.removeAll().iterator();
            while (iterator.hasNext()) {
                FileLock fl;
                FileLock fileLock = fl = iterator.next();
                synchronized (fileLock) {
                    if (fl.isValid()) {
                        FileLockImpl fli = (FileLockImpl)fl;
                        this.implRelease(fli);
                        fli.invalidate();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final FileLockImpl addToFileLockTable(long position, long size, boolean shared) {
        FileLockImpl fli;
        try {
            this.closeLock.readLock().lock();
            if (this.closed) {
                FileLockImpl fileLockImpl = null;
                return fileLockImpl;
            }
            try {
                this.ensureFileLockTableInitialized();
            }
            catch (IOException x) {
                throw new AssertionError((Object)x);
            }
            fli = new FileLockImpl(this, position, size, shared);
            this.fileLockTable.add(fli);
        }
        finally {
            this.end();
        }
        return fli;
    }

    protected final void removeFromFileLockTable(FileLockImpl fli) {
        this.fileLockTable.remove(fli);
    }

    protected abstract void implRelease(FileLockImpl var1) throws IOException;

    final void release(FileLockImpl fli) throws IOException {
        try {
            this.begin();
            this.implRelease(fli);
            this.removeFromFileLockTable(fli);
        }
        finally {
            this.end();
        }
    }

    abstract <A> Future<Integer> implRead(ByteBuffer var1, long var2, A var4, CompletionHandler<Integer, ? super A> var5);

    @Override
    public final Future<Integer> read(ByteBuffer dst, long position) {
        return this.implRead(dst, position, null, null);
    }

    @Override
    public final <A> void read(ByteBuffer dst, long position, A attachment, CompletionHandler<Integer, ? super A> handler) {
        if (handler == null) {
            throw new NullPointerException("'handler' is null");
        }
        this.implRead(dst, position, attachment, handler);
    }

    abstract <A> Future<Integer> implWrite(ByteBuffer var1, long var2, A var4, CompletionHandler<Integer, ? super A> var5);

    @Override
    public final Future<Integer> write(ByteBuffer src, long position) {
        return this.implWrite(src, position, null, null);
    }

    @Override
    public final <A> void write(ByteBuffer src, long position, A attachment, CompletionHandler<Integer, ? super A> handler) {
        if (handler == null) {
            throw new NullPointerException("'handler' is null");
        }
        this.implWrite(src, position, attachment, handler);
    }
}

