/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.GaloisCounterMode;
import com.sun.crypto.provider.SymmetricCipher;
import javax.crypto.IllegalBlockSizeException;

final class GCTR {
    private final SymmetricCipher aes;
    private final byte[] icb;
    private byte[] counter;
    private byte[] counterSave = null;

    GCTR(SymmetricCipher cipher, byte[] initialCounterBlk) {
        this.aes = cipher;
        if (initialCounterBlk.length != 16) {
            throw new RuntimeException("length of initial counter block (" + initialCounterBlk.length + ") not equal to AES_BLOCK_SIZE (" + 16 + ")");
        }
        this.icb = initialCounterBlk;
        this.counter = (byte[])this.icb.clone();
    }

    int update(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) {
        if (inLen - inOfs > in.length) {
            throw new RuntimeException("input length out of bound");
        }
        if (inLen < 0 || inLen % 16 != 0) {
            throw new RuntimeException("input length unsupported");
        }
        if (out.length - outOfs < inLen) {
            throw new RuntimeException("output buffer too small");
        }
        byte[] encryptedCntr = new byte[16];
        int numOfCompleteBlocks = inLen / 16;
        for (int i = 0; i < numOfCompleteBlocks; ++i) {
            this.aes.encryptBlock(this.counter, 0, encryptedCntr, 0);
            for (int n = 0; n < 16; ++n) {
                int index = i * 16 + n;
                out[outOfs + index] = (byte)(in[inOfs + index] ^ encryptedCntr[n]);
            }
            GaloisCounterMode.increment32(this.counter);
        }
        return inLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doFinal(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws IllegalBlockSizeException {
        try {
            if (inLen < 0) {
                throw new IllegalBlockSizeException("Negative input size!");
            }
            if (inLen > 0) {
                int lastBlockSize = inLen % 16;
                int completeBlkLen = inLen - lastBlockSize;
                this.update(in, inOfs, completeBlkLen, out, outOfs);
                if (lastBlockSize != 0) {
                    byte[] encryptedCntr = new byte[16];
                    this.aes.encryptBlock(this.counter, 0, encryptedCntr, 0);
                    for (int n = 0; n < lastBlockSize; ++n) {
                        out[outOfs + completeBlkLen + n] = (byte)(in[inOfs + completeBlkLen + n] ^ encryptedCntr[n]);
                    }
                }
            }
        }
        finally {
            this.reset();
        }
        return inLen;
    }

    void reset() {
        System.arraycopy(this.icb, 0, this.counter, 0, this.icb.length);
        this.counterSave = null;
    }

    void save() {
        this.counterSave = (byte[])this.counter.clone();
    }

    void restore() {
        if (this.counterSave != null) {
            this.counter = this.counterSave;
        }
    }
}

