/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.12
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.gnu.glpk;


/**
 * Wrapper class generated by SWIG.
 * <p>Please, refer to doc/glpk-java.pdf of the GLPK for Java distribution
 * and to doc/glpk.pdf of the GLPK source distribution
 * for details. You can download the source distribution from
 * <a href="ftp://ftp.gnu.org/gnu/glpk">ftp://ftp.gnu.org/gnu/glpk</a>.
 *
 * <p>For handling arrays of int and double the following methods are
 * provided:
 * @see #new_doubleArray(int)
 * @see #delete_doubleArray(SWIGTYPE_p_double)
 * @see #doubleArray_getitem(SWIGTYPE_p_double, int)
 * @see #doubleArray_setitem(SWIGTYPE_p_double, int, double)
 * @see #new_intArray(int)
 * @see #delete_intArray(SWIGTYPE_p_int)
 * @see #intArray_getitem(SWIGTYPE_p_int, int)
 * @see #intArray_setitem(SWIGTYPE_p_int, int, int)
 */
public class GLPK implements GLPKConstants {
  
/**
 * Creates a new array of int.
 * <p>The memory is allocated with calloc(). To free the memory you will have
 * to call delete&#95;intArray.
 *
 * An OutOfMemoryError error indicates that the C-runtime heap of the process
 * (not the Java object heap) is full.
 *
 * @param nelements number of elements
 * @return array
 */
public static SWIGTYPE_p_int new_intArray(int nelements) {
    long cPtr = GLPKJNI.new_intArray(nelements);
    return (cPtr == 0) ? null : new SWIGTYPE_p_int(cPtr, false);
  }

  
/**
 * Deletes an array of int.
 * <p>The memory is deallocated with free().
 *
 * @param ary array
 */
public static void delete_intArray(SWIGTYPE_p_int ary) {
    GLPKJNI.delete_intArray(SWIGTYPE_p_int.getCPtr(ary));
  }

  
/**
 * Retrieves an element of an array of int.
 * <p>BEWARE: The validity of the index is not checked.
 *
 * @param ary array
 * @param index index of the element
 * @return array element
 */
public static int intArray_getitem(SWIGTYPE_p_int ary, int index) {
    return GLPKJNI.intArray_getitem(SWIGTYPE_p_int.getCPtr(ary), index);
  }

  
/**
 * Sets the value of an element of an array of int.
 * <p>BEWARE: The validity of the index is not checked.
 *
 * @param ary array
 * @param index index of the element
 * @param value new value
 */
public static void intArray_setitem(SWIGTYPE_p_int ary, int index, int value) {
    GLPKJNI.intArray_setitem(SWIGTYPE_p_int.getCPtr(ary), index, value);
  }

  
/**
 * Creates a new array of double.
 * <p>The memory is allocated with calloc(). To free the memory you will have
 * to call delete&#95;doubleArray.
 *
 * An OutOfMemoryError error indicates that the C-runtime heap of the process
 * (not the Java object heap) is full.
 *
 * @param nelements number of elements
 * @return array
 */
public static SWIGTYPE_p_double new_doubleArray(int nelements) {
    long cPtr = GLPKJNI.new_doubleArray(nelements);
    return (cPtr == 0) ? null : new SWIGTYPE_p_double(cPtr, false);
  }

  
/**
 * Deletes an array of double.
 * <p>The memory is deallocated with free().
 *
 * @param ary array
 */
public static void delete_doubleArray(SWIGTYPE_p_double ary) {
    GLPKJNI.delete_doubleArray(SWIGTYPE_p_double.getCPtr(ary));
  }

  
/**
 * Retrieves an element of an array of double.
 * <p>BEWARE: The validity of the index is not checked.
 *
 * @param ary array
 * @param index index of the element
 * @return array element
 */
public static double doubleArray_getitem(SWIGTYPE_p_double ary, int index) {
    return GLPKJNI.doubleArray_getitem(SWIGTYPE_p_double.getCPtr(ary), index);
  }

  
/**
 * Sets the value of an element of an array of double.
 * <p>BEWARE: The validity of the index is not checked.
 *
 * @param ary array
 * @param index index of the element
 * @param value new value
 */
public static void doubleArray_setitem(SWIGTYPE_p_double ary, int index, double value) {
    GLPKJNI.doubleArray_setitem(SWIGTYPE_p_double.getCPtr(ary), index, value);
  }

  
/**
 * Abort GLPK library with error message. This method can be used to stop the
 * solver using a GlpkTerminalListener.
 *
 * @param message message
 */
public static void glp_java_error(String message) {
    GLPKJNI.glp_java_error(message);
  }

  
/**
 * Sets the message level. This method enables and disables debug output of
 * GLPK for Java.
 *
 * @param msg_lvl message level
 *
 * @see GLPKConstants#GLP_JAVA_MSG_LVL_OFF
 * @see GLPKConstants#GLP_JAVA_MSG_LVL_ALL
 */
public static void glp_java_set_msg_lvl(int msg_lvl) {
    GLPKJNI.glp_java_set_msg_lvl(msg_lvl);
  }

  public static void glp_java_set_numeric_locale(String locale) {
    GLPKJNI.glp_java_set_numeric_locale(locale);
  }

  
/**
 * Get arc data.
 *
 * @param arc arc
 * @return data
 */
public static glp_java_arc_data glp_java_arc_get_data(glp_arc arc) {
    long cPtr = GLPKJNI.glp_java_arc_get_data(glp_arc.getCPtr(arc), arc);
    return (cPtr == 0) ? null : new glp_java_arc_data(cPtr, false);
  }

  
/**
 * Get vertex data.
 *
 * @param G graph
 * @param i index to vertex
 * @return data
 */
public static glp_java_vertex_data glp_java_vertex_data_get(glp_graph G, int i) {
    long cPtr = GLPKJNI.glp_java_vertex_data_get(glp_graph.getCPtr(G), G, i);
    return (cPtr == 0) ? null : new glp_java_vertex_data(cPtr, false);
  }

  
/**
 * Get vertex data.
 *
 * @param v vertex
 * @return data
 */
public static glp_java_vertex_data glp_java_vertex_get_data(glp_vertex v) {
    long cPtr = GLPKJNI.glp_java_vertex_get_data(glp_vertex.getCPtr(v), v);
    return (cPtr == 0) ? null : new glp_java_vertex_data(cPtr, false);
  }

  
/**
 * Get vertex.
 *
 * @param G graph
 * @param i index
 * @return vertex
 */
public static glp_vertex glp_java_vertex_get(glp_graph G, int i) {
    long cPtr = GLPKJNI.glp_java_vertex_get(glp_graph.getCPtr(G), G, i);
    return (cPtr == 0) ? null : new glp_vertex(cPtr, false);
  }

  
/**
 */
public static glp_prob glp_create_prob() {
    long cPtr = GLPKJNI.glp_create_prob();
    return (cPtr == 0) ? null : new glp_prob(cPtr, false);
  }

  
/**
 * glp_set_prob_name - assign (change) problem name .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_prob_name(glp_prob *lp, const char *name);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_prob_name assigns a given symbolic name (1 up to 255 characters) to the specified problem object.</p>
 * <p>If the parameter name is NULL or empty string, the routine erases an existing symbolic name of the problem object. </p>
 */
public static void glp_set_prob_name(glp_prob P, String name) {
    GLPKJNI.glp_set_prob_name(glp_prob.getCPtr(P), P, name);
  }

  
/**
 * glp_set_obj_name - assign (change) objective function name .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_obj_name(glp_prob *lp, const char *name);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_obj_name assigns a given symbolic name (1 up to 255 characters) to the objective function of the specified problem object.</p>
 * <p>If the parameter name is NULL or empty string, the routine erases an existing name of the objective function. </p>
 */
public static void glp_set_obj_name(glp_prob P, String name) {
    GLPKJNI.glp_set_obj_name(glp_prob.getCPtr(P), P, name);
  }

  
/**
 * glp_set_obj_dir - set (change) optimization direction flag .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_obj_dir(glp_prob *lp, int dir);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_obj_dir sets (changes) optimization direction flag (i.e. "sense" of the objective function) as specified by the parameter dir:</p>
 * <p>GLP_MIN - minimization; GLP_MAX - maximization. </p>
 */
public static void glp_set_obj_dir(glp_prob P, int dir) {
    GLPKJNI.glp_set_obj_dir(glp_prob.getCPtr(P), P, dir);
  }

  
/**
 * glp_add_rows - add new rows to problem object .
 * <p>SYNOPSIS</p>
 * <p>int glp_add_rows(glp_prob *lp, int nrs);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_add_rows adds nrs rows (constraints) to the specified problem object. New rows are always added to the end of the row list, so the ordinal numbers of existing rows remain unchanged.</p>
 * <p>Being added each new row is initially free (unbounded) and has empty list of the constraint coefficients.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_add_rows returns the ordinal number of the first new row added to the problem object. </p>
 */
public static int glp_add_rows(glp_prob P, int nrs) {
    return GLPKJNI.glp_add_rows(glp_prob.getCPtr(P), P, nrs);
  }

  
/**
 * glp_add_cols - add new columns to problem object .
 * <p>SYNOPSIS</p>
 * <p>int glp_add_cols(glp_prob *lp, int ncs);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_add_cols adds ncs columns (structural variables) to the specified problem object. New columns are always added to the end of the column list, so the ordinal numbers of existing columns remain unchanged.</p>
 * <p>Being added each new column is initially fixed at zero and has empty list of the constraint coefficients.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_add_cols returns the ordinal number of the first new column added to the problem object. </p>
 */
public static int glp_add_cols(glp_prob P, int ncs) {
    return GLPKJNI.glp_add_cols(glp_prob.getCPtr(P), P, ncs);
  }

  
/**
 * glp_set_row_name - assign (change) row name .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_row_name(glp_prob *lp, int i, const char *name);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_row_name assigns a given symbolic name (1 up to 255 characters) to i-th row (auxiliary variable) of the specified problem object.</p>
 * <p>If the parameter name is NULL or empty string, the routine erases an existing name of i-th row. </p>
 */
public static void glp_set_row_name(glp_prob P, int i, String name) {
    GLPKJNI.glp_set_row_name(glp_prob.getCPtr(P), P, i, name);
  }

  
/**
 * glp_set_col_name - assign (change) column name .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_col_name(glp_prob *lp, int j, const char *name);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_col_name assigns a given symbolic name (1 up to 255 characters) to j-th column (structural variable) of the specified problem object.</p>
 * <p>If the parameter name is NULL or empty string, the routine erases an existing name of j-th column. </p>
 */
public static void glp_set_col_name(glp_prob P, int j, String name) {
    GLPKJNI.glp_set_col_name(glp_prob.getCPtr(P), P, j, name);
  }

  
/**
 * glp_set_row_bnds - set (change) row bounds .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_row_bnds(glp_prob *lp, int i, int type, double lb, double ub);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_row_bnds sets (changes) the type and bounds of i-th row (auxiliary variable) of the specified problem object.</p>
 * <p>Parameters type, lb, and ub specify the type, lower bound, and upper bound, respectively, as follows:</p>
 * <p>Type Bounds Comments 
</p>
 * <p>GLP_FR -inf &lt; x &lt; +inf Free variable GLP_LO lb &lt;= x &lt; +inf Variable with lower bound GLP_UP -inf &lt; x &lt;= ub Variable with upper bound GLP_DB lb &lt;= x &lt;= ub Double-bounded variable GLP_FX x = lb Fixed variable</p>
 * <p>where x is the auxiliary variable associated with i-th row.</p>
 * <p>If the row has no lower bound, the parameter lb is ignored. If the row has no upper bound, the parameter ub is ignored. If the row is an equality constraint (i.e. the corresponding auxiliary variable is of fixed type), only the parameter lb is used while the parameter ub is ignored. </p>
 */
public static void glp_set_row_bnds(glp_prob P, int i, int type, double lb, double ub) {
    GLPKJNI.glp_set_row_bnds(glp_prob.getCPtr(P), P, i, type, lb, ub);
  }

  
/**
 * glp_set_col_bnds - set (change) column bounds .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_col_bnds(glp_prob *lp, int j, int type, double lb, double ub);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_col_bnds sets (changes) the type and bounds of j-th column (structural variable) of the specified problem object.</p>
 * <p>Parameters type, lb, and ub specify the type, lower bound, and upper bound, respectively, as follows:</p>
 * <p>Type Bounds Comments 
</p>
 * <p>GLP_FR -inf &lt; x &lt; +inf Free variable GLP_LO lb &lt;= x &lt; +inf Variable with lower bound GLP_UP -inf &lt; x &lt;= ub Variable with upper bound GLP_DB lb &lt;= x &lt;= ub Double-bounded variable GLP_FX x = lb Fixed variable</p>
 * <p>where x is the structural variable associated with j-th column.</p>
 * <p>If the column has no lower bound, the parameter lb is ignored. If the column has no upper bound, the parameter ub is ignored. If the column is of fixed type, only the parameter lb is used while the parameter ub is ignored. </p>
 */
public static void glp_set_col_bnds(glp_prob P, int j, int type, double lb, double ub) {
    GLPKJNI.glp_set_col_bnds(glp_prob.getCPtr(P), P, j, type, lb, ub);
  }

  
/**
 * glp_set_obj_coef - set (change) obj. .
 * <p>coefficient or constant term</p>
 * <p>SYNOPSIS</p>
 * <p>void glp_set_obj_coef(glp_prob *lp, int j, double coef);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_obj_coef sets (changes) objective coefficient at j-th column (structural variable) of the specified problem object.</p>
 * <p>If the parameter j is 0, the routine sets (changes) the constant term ("shift") of the objective function. </p>
 */
public static void glp_set_obj_coef(glp_prob P, int j, double coef) {
    GLPKJNI.glp_set_obj_coef(glp_prob.getCPtr(P), P, j, coef);
  }

  
/**
 * glp_set_mat_row - set (replace) row of the constraint matrix .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_mat_row(glp_prob *lp, int i, int len, const int ind[], const double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_mat_row stores (replaces) the contents of i-th row of the constraint matrix of the specified problem object.</p>
 * <p>Column indices and numeric values of new row elements must be placed in locations ind[1], ..., ind[len] and val[1], ..., val[len], where 0 &lt;= len &lt;= n is the new length of i-th row, n is the current number of columns in the problem object. Elements with identical column indices are not allowed. Zero elements are allowed, but they are not stored in the constraint matrix.</p>
 * <p>If the parameter len is zero, the parameters ind and/or val can be specified as NULL. </p>
 */
public static void glp_set_mat_row(glp_prob P, int i, int len, SWIGTYPE_p_int ind, SWIGTYPE_p_double val) {
    GLPKJNI.glp_set_mat_row(glp_prob.getCPtr(P), P, i, len, SWIGTYPE_p_int.getCPtr(ind), SWIGTYPE_p_double.getCPtr(val));
  }

  
/**
 * glp_set_mat_col - set (replace) column of the constraint matrix .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_mat_col(glp_prob *lp, int j, int len, const int ind[], const double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_mat_col stores (replaces) the contents of j-th column of the constraint matrix of the specified problem object.</p>
 * <p>Row indices and numeric values of new column elements must be placed in locations ind[1], ..., ind[len] and val[1], ..., val[len], where 0 &lt;= len &lt;= m is the new length of j-th column, m is the current number of rows in the problem object. Elements with identical column indices are not allowed. Zero elements are allowed, but they are not stored in the constraint matrix.</p>
 * <p>If the parameter len is zero, the parameters ind and/or val can be specified as NULL. </p>
 */
public static void glp_set_mat_col(glp_prob P, int j, int len, SWIGTYPE_p_int ind, SWIGTYPE_p_double val) {
    GLPKJNI.glp_set_mat_col(glp_prob.getCPtr(P), P, j, len, SWIGTYPE_p_int.getCPtr(ind), SWIGTYPE_p_double.getCPtr(val));
  }

  
/**
 * glp_load_matrix - load (replace) the whole constraint matrix .
 * <p>SYNOPSIS</p>
 * <p>void glp_load_matrix(glp_prob *lp, int ne, const int ia[], const int ja[], const double ar[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_load_matrix loads the constraint matrix passed in the arrays ia, ja, and ar into the specified problem object. Before loading the current contents of the constraint matrix is destroyed.</p>
 * <p>Constraint coefficients (elements of the constraint matrix) must be specified as triplets (ia[k], ja[k], ar[k]) for k = 1, ..., ne, where ia[k] is the row index, ja[k] is the column index, ar[k] is a numeric value of corresponding constraint coefficient. The parameter ne specifies the total number of (non-zero) elements in the matrix to be loaded. Coefficients with identical indices are not allowed. Zero coefficients are allowed, however, they are not stored in the constraint matrix.</p>
 * <p>If the parameter ne is zero, the parameters ia, ja, and ar can be specified as NULL. </p>
 */
public static void glp_load_matrix(glp_prob P, int ne, SWIGTYPE_p_int ia, SWIGTYPE_p_int ja, SWIGTYPE_p_double ar) {
    GLPKJNI.glp_load_matrix(glp_prob.getCPtr(P), P, ne, SWIGTYPE_p_int.getCPtr(ia), SWIGTYPE_p_int.getCPtr(ja), SWIGTYPE_p_double.getCPtr(ar));
  }

  
/**
 * glp_check_dup - check for duplicate elements in sparse matrix .
 * <p>SYNOPSIS</p>
 * <p>int glp_check_dup(int m, int n, int ne, const int ia[], const int ja[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_check_dup checks for duplicate elements (that is, elements with identical indices) in a sparse matrix specified in the coordinate format.</p>
 * <p>The parameters m and n specifies, respectively, the number of rows and columns in the matrix, m &gt;= 0, n &gt;= 0.</p>
 * <p>The parameter ne specifies the number of (structurally) non-zero elements in the matrix, ne &gt;= 0.</p>
 * <p>Elements of the matrix are specified as doublets (ia[k],ja[k]) for k = 1,...,ne, where ia[k] is a row index, ja[k] is a column index.</p>
 * <p>The routine glp_check_dup can be used prior to a call to the routine glp_load_matrix to check that the constraint matrix to be loaded has no duplicate elements.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_check_dup returns one of the following values:</p>
 * <p>0 - the matrix has no duplicate elements;</p>
 * <p>-k - indices ia[k] or/and ja[k] are out of range;</p>
 * <p>+k - element (ia[k],ja[k]) is duplicate. </p>
 */
public static int glp_check_dup(int m, int n, int ne, SWIGTYPE_p_int ia, SWIGTYPE_p_int ja) {
    return GLPKJNI.glp_check_dup(m, n, ne, SWIGTYPE_p_int.getCPtr(ia), SWIGTYPE_p_int.getCPtr(ja));
  }

  
/**
 * glp_sort_matrix - sort elements of the constraint matrix .
 * <p>SYNOPSIS</p>
 * <p>void glp_sort_matrix(glp_prob *P);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_sort_matrix sorts elements of the constraint matrix rebuilding its row and column linked lists. On exit from the routine the constraint matrix is not changed, however, elements in the row linked lists become ordered by ascending column indices, and the elements in the column linked lists become ordered by ascending row indices. </p>
 */
public static void glp_sort_matrix(glp_prob P) {
    GLPKJNI.glp_sort_matrix(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_del_rows - delete rows from problem object .
 * <p>SYNOPSIS</p>
 * <p>void glp_del_rows(glp_prob *lp, int nrs, const int num[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_del_rows deletes rows from the specified problem object. Ordinal numbers of rows to be deleted should be placed in locations num[1], ..., num[nrs], where nrs &gt; 0.</p>
 * <p>Note that deleting rows involves changing ordinal numbers of other rows remaining in the problem object. New ordinal numbers of the remaining rows are assigned under the assumption that the original order of rows is not changed. </p>
 */
public static void glp_del_rows(glp_prob P, int nrs, SWIGTYPE_p_int num) {
    GLPKJNI.glp_del_rows(glp_prob.getCPtr(P), P, nrs, SWIGTYPE_p_int.getCPtr(num));
  }

  
/**
 * glp_del_cols - delete columns from problem object .
 * <p>SYNOPSIS</p>
 * <p>void glp_del_cols(glp_prob *lp, int ncs, const int num[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_del_cols deletes columns from the specified problem object. Ordinal numbers of columns to be deleted should be placed in locations num[1], ..., num[ncs], where ncs &gt; 0.</p>
 * <p>Note that deleting columns involves changing ordinal numbers of other columns remaining in the problem object. New ordinal numbers of the remaining columns are assigned under the assumption that the original order of columns is not changed. </p>
 */
public static void glp_del_cols(glp_prob P, int ncs, SWIGTYPE_p_int num) {
    GLPKJNI.glp_del_cols(glp_prob.getCPtr(P), P, ncs, SWIGTYPE_p_int.getCPtr(num));
  }

  
/**
 * glp_copy_prob - copy problem object content .
 * <p>SYNOPSIS</p>
 * <p>void glp_copy_prob(glp_prob *dest, glp_prob *prob, int names);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_copy_prob copies the content of the problem object prob to the problem object dest.</p>
 * <p>The parameter names is a flag. If it is non-zero, the routine also copies all symbolic names; otherwise, if it is zero, symbolic names are not copied. </p>
 */
public static void glp_copy_prob(glp_prob dest, glp_prob prob, int names) {
    GLPKJNI.glp_copy_prob(glp_prob.getCPtr(dest), dest, glp_prob.getCPtr(prob), prob, names);
  }

  
/**
 */
public static void glp_erase_prob(glp_prob P) {
    GLPKJNI.glp_erase_prob(glp_prob.getCPtr(P), P);
  }

  
/**
 */
public static void glp_delete_prob(glp_prob P) {
    GLPKJNI.glp_delete_prob(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_get_prob_name - retrieve problem name .
 * <p>SYNOPSIS</p>
 * <p>const char *glp_get_prob_name(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_prob_name returns a pointer to an internal buffer, which contains symbolic name of the problem. However, if the problem has no assigned name, the routine returns NULL. </p>
 */
public static String glp_get_prob_name(glp_prob P) {
    return GLPKJNI.glp_get_prob_name(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_get_obj_name - retrieve objective function name .
 * <p>SYNOPSIS</p>
 * <p>const char *glp_get_obj_name(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_obj_name returns a pointer to an internal buffer, which contains a symbolic name of the objective function. However, if the objective function has no assigned name, the routine returns NULL. </p>
 */
public static String glp_get_obj_name(glp_prob P) {
    return GLPKJNI.glp_get_obj_name(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_get_obj_dir - retrieve optimization direction flag .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_obj_dir(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_obj_dir returns the optimization direction flag (i.e. "sense" of the objective function):</p>
 * <p>GLP_MIN - minimization; GLP_MAX - maximization. </p>
 */
public static int glp_get_obj_dir(glp_prob P) {
    return GLPKJNI.glp_get_obj_dir(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_get_num_rows - retrieve number of rows .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_num_rows(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_num_rows returns the current number of rows in the specified problem object. </p>
 */
public static int glp_get_num_rows(glp_prob P) {
    return GLPKJNI.glp_get_num_rows(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_get_num_cols - retrieve number of columns .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_num_cols(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_num_cols returns the current number of columns in the specified problem object. </p>
 */
public static int glp_get_num_cols(glp_prob P) {
    return GLPKJNI.glp_get_num_cols(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_get_row_name - retrieve row name .
 * <p>SYNOPSIS</p>
 * <p>const char *glp_get_row_name(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_name returns a pointer to an internal buffer, which contains symbolic name of i-th row. However, if i-th row has no assigned name, the routine returns NULL. </p>
 */
public static String glp_get_row_name(glp_prob P, int i) {
    return GLPKJNI.glp_get_row_name(glp_prob.getCPtr(P), P, i);
  }

  
/**
 * glp_get_col_name - retrieve column name .
 * <p>SYNOPSIS</p>
 * <p>const char *glp_get_col_name(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_name returns a pointer to an internal buffer, which contains symbolic name of j-th column. However, if j-th column has no assigned name, the routine returns NULL. </p>
 */
public static String glp_get_col_name(glp_prob P, int j) {
    return GLPKJNI.glp_get_col_name(glp_prob.getCPtr(P), P, j);
  }

  
/**
 * glp_get_row_type - retrieve row type .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_row_type(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_type returns the type of i-th row, i.e. the type of corresponding auxiliary variable, as follows:</p>
 * <p>GLP_FR - free (unbounded) variable; GLP_LO - variable with lower bound; GLP_UP - variable with upper bound; GLP_DB - double-bounded variable; GLP_FX - fixed variable. </p>
 */
public static int glp_get_row_type(glp_prob P, int i) {
    return GLPKJNI.glp_get_row_type(glp_prob.getCPtr(P), P, i);
  }

  
/**
 * glp_get_row_lb - retrieve row lower bound .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_row_lb(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_lb returns the lower bound of i-th row, i.e. the lower bound of corresponding auxiliary variable. However, if the row has no lower bound, the routine returns -DBL_MAX. </p>
 */
public static double glp_get_row_lb(glp_prob P, int i) {
    return GLPKJNI.glp_get_row_lb(glp_prob.getCPtr(P), P, i);
  }

  
/**
 * glp_get_row_ub - retrieve row upper bound .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_row_ub(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_ub returns the upper bound of i-th row, i.e. the upper bound of corresponding auxiliary variable. However, if the row has no upper bound, the routine returns +DBL_MAX. </p>
 */
public static double glp_get_row_ub(glp_prob P, int i) {
    return GLPKJNI.glp_get_row_ub(glp_prob.getCPtr(P), P, i);
  }

  
/**
 * glp_get_col_type - retrieve column type .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_col_type(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_type returns the type of j-th column, i.e. the type of corresponding structural variable, as follows:</p>
 * <p>GLP_FR - free (unbounded) variable; GLP_LO - variable with lower bound; GLP_UP - variable with upper bound; GLP_DB - double-bounded variable; GLP_FX - fixed variable. </p>
 */
public static int glp_get_col_type(glp_prob P, int j) {
    return GLPKJNI.glp_get_col_type(glp_prob.getCPtr(P), P, j);
  }

  
/**
 * glp_get_col_lb - retrieve column lower bound .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_col_lb(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_lb returns the lower bound of j-th column, i.e. the lower bound of corresponding structural variable. However, if the column has no lower bound, the routine returns -DBL_MAX. </p>
 */
public static double glp_get_col_lb(glp_prob P, int j) {
    return GLPKJNI.glp_get_col_lb(glp_prob.getCPtr(P), P, j);
  }

  
/**
 * glp_get_col_ub - retrieve column upper bound .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_col_ub(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_ub returns the upper bound of j-th column, i.e. the upper bound of corresponding structural variable. However, if the column has no upper bound, the routine returns +DBL_MAX. </p>
 */
public static double glp_get_col_ub(glp_prob P, int j) {
    return GLPKJNI.glp_get_col_ub(glp_prob.getCPtr(P), P, j);
  }

  
/**
 * glp_get_obj_coef - retrieve obj. .
 * <p>coefficient or constant term</p>
 * <p>SYNOPSIS</p>
 * <p>double glp_get_obj_coef(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_obj_coef returns the objective coefficient at j-th structural variable (column) of the specified problem object.</p>
 * <p>If the parameter j is zero, the routine returns the constant term ("shift") of the objective function. </p>
 */
public static double glp_get_obj_coef(glp_prob P, int j) {
    return GLPKJNI.glp_get_obj_coef(glp_prob.getCPtr(P), P, j);
  }

  
/**
 * glp_get_num_nz - retrieve number of constraint coefficients .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_num_nz(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_num_nz returns the number of (non-zero) elements in the constraint matrix of the specified problem object. </p>
 */
public static int glp_get_num_nz(glp_prob P) {
    return GLPKJNI.glp_get_num_nz(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_get_mat_row - retrieve row of the constraint matrix .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_mat_row(glp_prob *lp, int i, int ind[], double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_get_mat_row scans (non-zero) elements of i-th row of the constraint matrix of the specified problem object and stores their column indices and numeric values to locations ind[1], ..., ind[len] and val[1], ..., val[len], respectively, where 0 &lt;= len &lt;= n is the number of elements in i-th row, n is the number of columns.</p>
 * <p>The parameter ind and/or val can be specified as NULL, in which case corresponding information is not stored.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_mat_row returns the length len, i.e. the number of (non-zero) elements in i-th row. </p>
 */
public static int glp_get_mat_row(glp_prob P, int i, SWIGTYPE_p_int ind, SWIGTYPE_p_double val) {
    return GLPKJNI.glp_get_mat_row(glp_prob.getCPtr(P), P, i, SWIGTYPE_p_int.getCPtr(ind), SWIGTYPE_p_double.getCPtr(val));
  }

  
/**
 * glp_get_mat_col - retrieve column of the constraint matrix .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_mat_col(glp_prob *lp, int j, int ind[], double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_get_mat_col scans (non-zero) elements of j-th column of the constraint matrix of the specified problem object and stores their row indices and numeric values to locations ind[1], ..., ind[len] and val[1], ..., val[len], respectively, where 0 &lt;= len &lt;= m is the number of elements in j-th column, m is the number of rows.</p>
 * <p>The parameter ind or/and val can be specified as NULL, in which case corresponding information is not stored.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_mat_col returns the length len, i.e. the number of (non-zero) elements in j-th column. </p>
 */
public static int glp_get_mat_col(glp_prob P, int j, SWIGTYPE_p_int ind, SWIGTYPE_p_double val) {
    return GLPKJNI.glp_get_mat_col(glp_prob.getCPtr(P), P, j, SWIGTYPE_p_int.getCPtr(ind), SWIGTYPE_p_double.getCPtr(val));
  }

  
/**
 * glp_create_index - create the name index .
 * <p>SYNOPSIS</p>
 * <p>void glp_create_index(glp_prob *lp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_create_index creates the name index for the specified problem object. The name index is an auxiliary data structure, which is intended to quickly (i.e. for logarithmic time) find rows and columns by their names.</p>
 * <p>This routine can be called at any time. If the name index already exists, the routine does nothing. </p>
 */
public static void glp_create_index(glp_prob P) {
    GLPKJNI.glp_create_index(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_find_row - find row by its name .
 * <p>SYNOPSIS</p>
 * <p>int glp_find_row(glp_prob *lp, const char *name);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_find_row returns the ordinal number of a row, which is assigned (by the routine glp_set_row_name) the specified symbolic name. If no such row exists, the routine returns 0. </p>
 */
public static int glp_find_row(glp_prob P, String name) {
    return GLPKJNI.glp_find_row(glp_prob.getCPtr(P), P, name);
  }

  
/**
 * glp_find_col - find column by its name .
 * <p>SYNOPSIS</p>
 * <p>int glp_find_col(glp_prob *lp, const char *name);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_find_col returns the ordinal number of a column, which is assigned (by the routine glp_set_col_name) the specified symbolic name. If no such column exists, the routine returns 0. </p>
 */
public static int glp_find_col(glp_prob P, String name) {
    return GLPKJNI.glp_find_col(glp_prob.getCPtr(P), P, name);
  }

  
/**
 * glp_delete_index - delete the name index .
 * <p>SYNOPSIS</p>
 * <p>void glp_delete_index(glp_prob *lp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_delete_index deletes the name index previously created by the routine glp_create_index and frees the memory allocated to this auxiliary data structure.</p>
 * <p>This routine can be called at any time. If the name index does not exist, the routine does nothing. </p>
 */
public static void glp_delete_index(glp_prob P) {
    GLPKJNI.glp_delete_index(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_set_rii - set (change) row scale factor .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_rii(glp_prob *lp, int i, double rii);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_rii sets (changes) the scale factor r[i,i] for i-th row of the specified problem object. </p>
 */
public static void glp_set_rii(glp_prob P, int i, double rii) {
    GLPKJNI.glp_set_rii(glp_prob.getCPtr(P), P, i, rii);
  }

  
/**
 * glp_set sjj - set (change) column scale factor .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_sjj(glp_prob *lp, int j, double sjj);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_sjj sets (changes) the scale factor s[j,j] for j-th column of the specified problem object. </p>
 */
public static void glp_set_sjj(glp_prob P, int j, double sjj) {
    GLPKJNI.glp_set_sjj(glp_prob.getCPtr(P), P, j, sjj);
  }

  
/**
 * glp_get_rii - retrieve row scale factor .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_rii(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_rii returns current scale factor r[i,i] for i-th row of the specified problem object. </p>
 */
public static double glp_get_rii(glp_prob P, int i) {
    return GLPKJNI.glp_get_rii(glp_prob.getCPtr(P), P, i);
  }

  
/**
 * glp_get_sjj - retrieve column scale factor .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_sjj(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_sjj returns current scale factor s[j,j] for j-th column of the specified problem object. </p>
 */
public static double glp_get_sjj(glp_prob P, int j) {
    return GLPKJNI.glp_get_sjj(glp_prob.getCPtr(P), P, j);
  }

  
/**
 * glp_scale_prob - scale problem data .
 * <p>SYNOPSIS</p>
 * <p>void glp_scale_prob(glp_prob *lp, int flags);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_scale_prob performs automatic scaling of problem data for the specified problem object.</p>
 * <p>The parameter flags specifies scaling options used by the routine. Options can be combined with the bitwise OR operator and may be the following:</p>
 * <p>GLP_SF_GM perform geometric mean scaling; GLP_SF_EQ perform equilibration scaling; GLP_SF_2N round scale factors to nearest power of two; GLP_SF_SKIP skip scaling, if the problem is well scaled.</p>
 * <p>The parameter flags may be specified as GLP_SF_AUTO, in which case the routine chooses scaling options automatically. </p>
 */
public static void glp_scale_prob(glp_prob P, int flags) {
    GLPKJNI.glp_scale_prob(glp_prob.getCPtr(P), P, flags);
  }

  
/**
 * glp_unscale_prob - unscale problem data .
 * <p>SYNOPSIS</p>
 * <p>void glp_unscale_prob(glp_prob *lp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_unscale_prob performs unscaling of problem data for the specified problem object.</p>
 * <p>"Unscaling" means replacing the current scaling matrices R and S by unity matrices that cancels the scaling effect. </p>
 */
public static void glp_unscale_prob(glp_prob P) {
    GLPKJNI.glp_unscale_prob(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_set_row_stat - set (change) row status .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_row_stat(glp_prob *lp, int i, int stat);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_row_stat sets (changes) status of the auxiliary variable associated with i-th row.</p>
 * <p>The new status of the auxiliary variable should be specified by the parameter stat as follows:</p>
 * <p>GLP_BS - basic variable; GLP_NL - non-basic variable; GLP_NU - non-basic variable on its upper bound; if the variable is not double-bounded, this means the same as GLP_NL (only in case of this routine); GLP_NF - the same as GLP_NL (only in case of this routine); GLP_NS - the same as GLP_NL (only in case of this routine). </p>
 */
public static void glp_set_row_stat(glp_prob P, int i, int stat) {
    GLPKJNI.glp_set_row_stat(glp_prob.getCPtr(P), P, i, stat);
  }

  
/**
 * glp_set_col_stat - set (change) column status .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_col_stat(glp_prob *lp, int j, int stat);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_col_stat sets (changes) status of the structural variable associated with j-th column.</p>
 * <p>The new status of the structural variable should be specified by the parameter stat as follows:</p>
 * <p>GLP_BS - basic variable; GLP_NL - non-basic variable; GLP_NU - non-basic variable on its upper bound; if the variable is not double-bounded, this means the same as GLP_NL (only in case of this routine); GLP_NF - the same as GLP_NL (only in case of this routine); GLP_NS - the same as GLP_NL (only in case of this routine). </p>
 */
public static void glp_set_col_stat(glp_prob P, int j, int stat) {
    GLPKJNI.glp_set_col_stat(glp_prob.getCPtr(P), P, j, stat);
  }

  
/**
 * glp_std_basis - construct standard initial LP basis .
 * <p>SYNOPSIS</p>
 * <p>void glp_std_basis(glp_prob *lp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_std_basis builds the "standard" (trivial) initial basis for the specified problem object.</p>
 * <p>In the "standard" basis all auxiliary variables are basic, and all structural variables are non-basic. </p>
 */
public static void glp_std_basis(glp_prob P) {
    GLPKJNI.glp_std_basis(glp_prob.getCPtr(P), P);
  }

  
/**
 */
public static void glp_adv_basis(glp_prob P, int flags) {
    GLPKJNI.glp_adv_basis(glp_prob.getCPtr(P), P, flags);
  }

  
/**
 * glp_cpx_basis - construct Bixby's initial LP basis .
 * <p>SYNOPSIS</p>
 * <p>void glp_cpx_basis(glp_prob *lp);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_cpx_basis constructs an advanced initial basis for the specified problem object.</p>
 * <p>The routine is based on Bixby's algorithm described in the paper:</p>
 * <p>Robert E. Bixby. Implementing the Simplex Method: The Initial Basis. ORSA Journal on Computing, Vol. 4, No. 3, 1992, pp. 267-84. </p>
 */
public static void glp_cpx_basis(glp_prob P) {
    GLPKJNI.glp_cpx_basis(glp_prob.getCPtr(P), P);
  }

  
/**
 */
public static int glp_simplex(glp_prob P, glp_smcp parm) {
    return GLPKJNI.glp_simplex(glp_prob.getCPtr(P), P, glp_smcp.getCPtr(parm), parm);
  }

  
/**
 */
public static int glp_exact(glp_prob P, glp_smcp parm) {
    return GLPKJNI.glp_exact(glp_prob.getCPtr(P), P, glp_smcp.getCPtr(parm), parm);
  }

  
/**
 * glp_init_smcp - initialize simplex method control parameters .
 * <p>SYNOPSIS</p>
 * <p>void glp_init_smcp(glp_smcp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_init_smcp initializes control parameters, which are used by the simplex solver, with default values.</p>
 * <p>Default values of the control parameters are stored in a glp_smcp structure, which the parameter parm points to. </p>
 */
public static void glp_init_smcp(glp_smcp parm) {
    GLPKJNI.glp_init_smcp(glp_smcp.getCPtr(parm), parm);
  }

  
/**
 * glp_get_status - retrieve generic status of basic solution .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_status(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_status reports the generic status of the basic solution for the specified problem object as follows:</p>
 * <p>GLP_OPT - solution is optimal; GLP_FEAS - solution is feasible; GLP_INFEAS - solution is infeasible; GLP_NOFEAS - problem has no feasible solution; GLP_UNBND - problem has unbounded solution; GLP_UNDEF - solution is undefined. </p>
 */
public static int glp_get_status(glp_prob P) {
    return GLPKJNI.glp_get_status(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_get_prim_stat - retrieve status of primal basic solution .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_prim_stat(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_prim_stat reports the status of the primal basic solution for the specified problem object as follows:</p>
 * <p>GLP_UNDEF - primal solution is undefined; GLP_FEAS - primal solution is feasible; GLP_INFEAS - primal solution is infeasible; GLP_NOFEAS - no primal feasible solution exists. </p>
 */
public static int glp_get_prim_stat(glp_prob P) {
    return GLPKJNI.glp_get_prim_stat(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_get_dual_stat - retrieve status of dual basic solution .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_dual_stat(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_dual_stat reports the status of the dual basic solution for the specified problem object as follows:</p>
 * <p>GLP_UNDEF - dual solution is undefined; GLP_FEAS - dual solution is feasible; GLP_INFEAS - dual solution is infeasible; GLP_NOFEAS - no dual feasible solution exists. </p>
 */
public static int glp_get_dual_stat(glp_prob P) {
    return GLPKJNI.glp_get_dual_stat(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_get_obj_val - retrieve objective value (basic solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_obj_val(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_obj_val returns value of the objective function for basic solution. </p>
 */
public static double glp_get_obj_val(glp_prob P) {
    return GLPKJNI.glp_get_obj_val(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_get_row_stat - retrieve row status .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_row_stat(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_stat returns current status assigned to the auxiliary variable associated with i-th row as follows:</p>
 * <p>GLP_BS - basic variable; GLP_NL - non-basic variable on its lower bound; GLP_NU - non-basic variable on its upper bound; GLP_NF - non-basic free (unbounded) variable; GLP_NS - non-basic fixed variable. </p>
 */
public static int glp_get_row_stat(glp_prob P, int i) {
    return GLPKJNI.glp_get_row_stat(glp_prob.getCPtr(P), P, i);
  }

  
/**
 * glp_get_row_prim - retrieve row primal value (basic solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_row_prim(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_prim returns primal value of the auxiliary variable associated with i-th row. </p>
 */
public static double glp_get_row_prim(glp_prob P, int i) {
    return GLPKJNI.glp_get_row_prim(glp_prob.getCPtr(P), P, i);
  }

  
/**
 * glp_get_row_dual - retrieve row dual value (basic solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_row_dual(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_dual returns dual value (i.e. reduced cost) of the auxiliary variable associated with i-th row. </p>
 */
public static double glp_get_row_dual(glp_prob P, int i) {
    return GLPKJNI.glp_get_row_dual(glp_prob.getCPtr(P), P, i);
  }

  
/**
 * glp_get_col_stat - retrieve column status .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_col_stat(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_stat returns current status assigned to the structural variable associated with j-th column as follows:</p>
 * <p>GLP_BS - basic variable; GLP_NL - non-basic variable on its lower bound; GLP_NU - non-basic variable on its upper bound; GLP_NF - non-basic free (unbounded) variable; GLP_NS - non-basic fixed variable. </p>
 */
public static int glp_get_col_stat(glp_prob P, int j) {
    return GLPKJNI.glp_get_col_stat(glp_prob.getCPtr(P), P, j);
  }

  
/**
 * glp_get_col_prim - retrieve column primal value (basic solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_col_prim(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_prim returns primal value of the structural variable associated with j-th column. </p>
 */
public static double glp_get_col_prim(glp_prob P, int j) {
    return GLPKJNI.glp_get_col_prim(glp_prob.getCPtr(P), P, j);
  }

  
/**
 * glp_get_col_dual - retrieve column dual value (basic solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_get_col_dual(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_dual returns dual value (i.e. reduced cost) of the structural variable associated with j-th column. </p>
 */
public static double glp_get_col_dual(glp_prob P, int j) {
    return GLPKJNI.glp_get_col_dual(glp_prob.getCPtr(P), P, j);
  }

  
/**
 * glp_get_unbnd_ray - determine variable causing unboundedness .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_unbnd_ray(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_unbnd_ray returns the number k of a variable, which causes primal or dual unboundedness. If 1 &lt;= k &lt;= m, it is k-th auxiliary variable, and if m+1 &lt;= k &lt;= m+n, it is (k-m)-th structural variable, where m is the number of rows, n is the number of columns in the problem object. If such variable is not defined, the routine returns 0.</p>
 * <p>COMMENTS</p>
 * <p>If it is not exactly known which version of the simplex solver detected unboundedness, i.e. whether the unboundedness is primal or dual, it is sufficient to check the status of the variable reported with the routine glp_get_row_stat or glp_get_col_stat. If the variable is non-basic, the unboundedness is primal, otherwise, if the variable is basic, the unboundedness is dual (the latter case means that the problem has no primal feasible dolution). </p>
 */
public static int glp_get_unbnd_ray(glp_prob P) {
    return GLPKJNI.glp_get_unbnd_ray(glp_prob.getCPtr(P), P);
  }

  
/**
 */
public static int glp_get_it_cnt(glp_prob P) {
    return GLPKJNI.glp_get_it_cnt(glp_prob.getCPtr(P), P);
  }

  
/**
 */
public static void glp_set_it_cnt(glp_prob P, int it_cnt) {
    GLPKJNI.glp_set_it_cnt(glp_prob.getCPtr(P), P, it_cnt);
  }

  
/**
 */
public static int glp_interior(glp_prob P, glp_iptcp parm) {
    return GLPKJNI.glp_interior(glp_prob.getCPtr(P), P, glp_iptcp.getCPtr(parm), parm);
  }

  
/**
 * glp_init_iptcp - initialize interior-point solver control parameters .
 * <p>SYNOPSIS</p>
 * <p>void glp_init_iptcp(glp_iptcp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_init_iptcp initializes control parameters, which are used by the interior-point solver, with default values.</p>
 * <p>Default values of the control parameters are stored in the glp_iptcp structure, which the parameter parm points to. </p>
 */
public static void glp_init_iptcp(glp_iptcp parm) {
    GLPKJNI.glp_init_iptcp(glp_iptcp.getCPtr(parm), parm);
  }

  
/**
 * glp_ipt_status - retrieve status of interior-point solution .
 * <p>SYNOPSIS</p>
 * <p>int glp_ipt_status(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ipt_status reports the status of solution found by the interior-point solver as follows:</p>
 * <p>GLP_UNDEF - interior-point solution is undefined; GLP_OPT - interior-point solution is optimal; GLP_INFEAS - interior-point solution is infeasible; GLP_NOFEAS - no feasible solution exists. </p>
 */
public static int glp_ipt_status(glp_prob P) {
    return GLPKJNI.glp_ipt_status(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_ipt_obj_val - retrieve objective value (interior point) .
 * <p>SYNOPSIS</p>
 * <p>double glp_ipt_obj_val(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ipt_obj_val returns value of the objective function for interior-point solution. </p>
 */
public static double glp_ipt_obj_val(glp_prob P) {
    return GLPKJNI.glp_ipt_obj_val(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_ipt_row_prim - retrieve row primal value (interior point) .
 * <p>SYNOPSIS</p>
 * <p>double glp_ipt_row_prim(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ipt_row_prim returns primal value of the auxiliary variable associated with i-th row. </p>
 */
public static double glp_ipt_row_prim(glp_prob P, int i) {
    return GLPKJNI.glp_ipt_row_prim(glp_prob.getCPtr(P), P, i);
  }

  
/**
 * glp_ipt_row_dual - retrieve row dual value (interior point) .
 * <p>SYNOPSIS</p>
 * <p>double glp_ipt_row_dual(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ipt_row_dual returns dual value (i.e. reduced cost) of the auxiliary variable associated with i-th row. </p>
 */
public static double glp_ipt_row_dual(glp_prob P, int i) {
    return GLPKJNI.glp_ipt_row_dual(glp_prob.getCPtr(P), P, i);
  }

  
/**
 * glp_ipt_col_prim - retrieve column primal value (interior point) .
 * <p>SYNOPSIS</p>
 * <p>double glp_ipt_col_prim(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ipt_col_prim returns primal value of the structural variable associated with j-th column. </p>
 */
public static double glp_ipt_col_prim(glp_prob P, int j) {
    return GLPKJNI.glp_ipt_col_prim(glp_prob.getCPtr(P), P, j);
  }

  
/**
 * glp_ipt_col_dual - retrieve column dual value (interior point) .
 * <p>SYNOPSIS</p>
 * <p>double glp_ipt_col_dual(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ipt_col_dual returns dual value (i.e. reduced cost) of the structural variable associated with j-th column. </p>
 */
public static double glp_ipt_col_dual(glp_prob P, int j) {
    return GLPKJNI.glp_ipt_col_dual(glp_prob.getCPtr(P), P, j);
  }

  
/**
 * glp_set_col_kind - set (change) column kind .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_col_kind(glp_prob *mip, int j, int kind);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_col_kind sets (changes) the kind of j-th column (structural variable) as specified by the parameter kind:</p>
 * <p>GLP_CV - continuous variable; GLP_IV - integer variable; GLP_BV - binary variable. </p>
 */
public static void glp_set_col_kind(glp_prob P, int j, int kind) {
    GLPKJNI.glp_set_col_kind(glp_prob.getCPtr(P), P, j, kind);
  }

  
/**
 * glp_get_col_kind - retrieve column kind .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_col_kind(glp_prob *mip, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_kind returns the kind of j-th column, i.e. the kind of corresponding structural variable, as follows:</p>
 * <p>GLP_CV - continuous variable; GLP_IV - integer variable; GLP_BV - binary variable </p>
 */
public static int glp_get_col_kind(glp_prob P, int j) {
    return GLPKJNI.glp_get_col_kind(glp_prob.getCPtr(P), P, j);
  }

  
/**
 * glp_get_num_int - retrieve number of integer columns .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_num_int(glp_prob *mip);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_num_int returns the current number of columns, which are marked as integer. </p>
 */
public static int glp_get_num_int(glp_prob P) {
    return GLPKJNI.glp_get_num_int(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_get_num_bin - retrieve number of binary columns .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_num_bin(glp_prob *mip);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_num_bin returns the current number of columns, which are marked as binary. </p>
 */
public static int glp_get_num_bin(glp_prob P) {
    return GLPKJNI.glp_get_num_bin(glp_prob.getCPtr(P), P);
  }

  
/**
 */
public static int glp_intopt(glp_prob P, glp_iocp parm) {
    return GLPKJNI.glp_intopt(glp_prob.getCPtr(P), P, glp_iocp.getCPtr(parm), parm);
  }

  
/**
 * glp_init_iocp - initialize integer optimizer control parameters .
 * <p>SYNOPSIS</p>
 * <p>void glp_init_iocp(glp_iocp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_init_iocp initializes control parameters, which are used by the integer optimizer, with default values.</p>
 * <p>Default values of the control parameters are stored in a glp_iocp structure, which the parameter parm points to. </p>
 */
public static void glp_init_iocp(glp_iocp parm) {
    GLPKJNI.glp_init_iocp(glp_iocp.getCPtr(parm), parm);
  }

  
/**
 * glp_mip_status - retrieve status of MIP solution .
 * <p>SYNOPSIS</p>
 * <p>int glp_mip_status(glp_prob *mip);</p>
 * <p>RETURNS</p>
 * <p>The routine lpx_mip_status reports the status of MIP solution found by the branch-and-bound solver as follows:</p>
 * <p>GLP_UNDEF - MIP solution is undefined; GLP_OPT - MIP solution is integer optimal; GLP_FEAS - MIP solution is integer feasible but its optimality (or non-optimality) has not been proven, perhaps due to premature termination of the search; GLP_NOFEAS - problem has no integer feasible solution (proven by the solver). </p>
 */
public static int glp_mip_status(glp_prob P) {
    return GLPKJNI.glp_mip_status(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_mip_obj_val - retrieve objective value (MIP solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_mip_obj_val(glp_prob *mip);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_mip_obj_val returns value of the objective function for MIP solution. </p>
 */
public static double glp_mip_obj_val(glp_prob P) {
    return GLPKJNI.glp_mip_obj_val(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_mip_row_val - retrieve row value (MIP solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_mip_row_val(glp_prob *mip, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_mip_row_val returns value of the auxiliary variable associated with i-th row. </p>
 */
public static double glp_mip_row_val(glp_prob P, int i) {
    return GLPKJNI.glp_mip_row_val(glp_prob.getCPtr(P), P, i);
  }

  
/**
 * glp_mip_col_val - retrieve column value (MIP solution) .
 * <p>SYNOPSIS</p>
 * <p>double glp_mip_col_val(glp_prob *mip, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_mip_col_val returns value of the structural variable associated with j-th column. </p>
 */
public static double glp_mip_col_val(glp_prob P, int j) {
    return GLPKJNI.glp_mip_col_val(glp_prob.getCPtr(P), P, j);
  }

  
/**
 */
public static void glp_check_kkt(glp_prob P, int sol, int cond, SWIGTYPE_p_double ae_max, SWIGTYPE_p_int ae_ind, SWIGTYPE_p_double re_max, SWIGTYPE_p_int re_ind) {
    GLPKJNI.glp_check_kkt(glp_prob.getCPtr(P), P, sol, cond, SWIGTYPE_p_double.getCPtr(ae_max), SWIGTYPE_p_int.getCPtr(ae_ind), SWIGTYPE_p_double.getCPtr(re_max), SWIGTYPE_p_int.getCPtr(re_ind));
  }

  
/**
 */
public static int glp_print_sol(glp_prob P, String fname) {
    return GLPKJNI.glp_print_sol(glp_prob.getCPtr(P), P, fname);
  }

  
/**
 * glp_read_sol - read basic solution from text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_sol(glp_prob *lp, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_sol reads basic solution from a text file whose name is specified by the parameter fname into the problem object.</p>
 * <p>For the file format see description of the routine glp_write_sol.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns zero, otherwise non-zero. </p>
 */
public static int glp_read_sol(glp_prob P, String fname) {
    return GLPKJNI.glp_read_sol(glp_prob.getCPtr(P), P, fname);
  }

  
/**
 * glp_write_sol - write basic solution to text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_sol(glp_prob *lp, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_sol writes the current basic solution to a text file whose name is specified by the parameter fname. This file can be read back with the routine glp_read_sol.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns zero, otherwise non-zero.</p>
 * <p>FILE FORMAT</p>
 * <p>The file created by the routine glp_write_sol is a plain text file, which contains the following information:</p>
 * <p>m n p_stat d_stat obj_val r_stat[1] r_prim[1] r_dual[1] . . . r_stat[m] r_prim[m] r_dual[m] c_stat[1] c_prim[1] c_dual[1] . . . c_stat[n] c_prim[n] c_dual[n]</p>
 * <p>where: m is the number of rows (auxiliary variables); n is the number of columns (structural variables); p_stat is the primal status of the basic solution (GLP_UNDEF = 1, GLP_FEAS = 2, GLP_INFEAS = 3, or GLP_NOFEAS = 4); d_stat is the dual status of the basic solution (GLP_UNDEF = 1, GLP_FEAS = 2, GLP_INFEAS = 3, or GLP_NOFEAS = 4); obj_val is the objective value; r_stat[i], i = 1,...,m, is the status of i-th row (GLP_BS = 1, GLP_NL = 2, GLP_NU = 3, GLP_NF = 4, or GLP_NS = 5); r_prim[i], i = 1,...,m, is the primal value of i-th row; r_dual[i], i = 1,...,m, is the dual value of i-th row; c_stat[j], j = 1,...,n, is the status of j-th column (GLP_BS = 1, GLP_NL = 2, GLP_NU = 3, GLP_NF = 4, or GLP_NS = 5); c_prim[j], j = 1,...,n, is the primal value of j-th column; c_dual[j], j = 1,...,n, is the dual value of j-th column. </p>
 */
public static int glp_write_sol(glp_prob P, String fname) {
    return GLPKJNI.glp_write_sol(glp_prob.getCPtr(P), P, fname);
  }

  
/**
 */
public static int glp_print_ranges(glp_prob P, int len, SWIGTYPE_p_int list, int flags, String fname) {
    return GLPKJNI.glp_print_ranges(glp_prob.getCPtr(P), P, len, SWIGTYPE_p_int.getCPtr(list), flags, fname);
  }

  
/**
 */
public static int glp_print_ipt(glp_prob P, String fname) {
    return GLPKJNI.glp_print_ipt(glp_prob.getCPtr(P), P, fname);
  }

  
/**
 * glp_read_ipt - read interior-point solution from text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_ipt(glp_prob *lp, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_ipt reads interior-point solution from a text file whose name is specified by the parameter fname into the problem object.</p>
 * <p>For the file format see description of the routine glp_write_ipt.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns zero, otherwise non-zero. </p>
 */
public static int glp_read_ipt(glp_prob P, String fname) {
    return GLPKJNI.glp_read_ipt(glp_prob.getCPtr(P), P, fname);
  }

  
/**
 * glp_write_ipt - write interior-point solution to text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_ipt(glp_prob *lp, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_ipt writes the current interior-point solution to a text file whose name is specified by the parameter fname. This file can be read back with the routine glp_read_ipt.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns zero, otherwise non-zero.</p>
 * <p>FILE FORMAT</p>
 * <p>The file created by the routine glp_write_ipt is a plain text file, which contains the following information:</p>
 * <p>m n stat obj_val r_prim[1] r_dual[1] . . . r_prim[m] r_dual[m] c_prim[1] c_dual[1] . . . c_prim[n] c_dual[n]</p>
 * <p>where: m is the number of rows (auxiliary variables); n is the number of columns (structural variables); stat is the solution status (GLP_UNDEF = 1 or GLP_OPT = 5); obj_val is the objective value; r_prim[i], i = 1,...,m, is the primal value of i-th row; r_dual[i], i = 1,...,m, is the dual value of i-th row; c_prim[j], j = 1,...,n, is the primal value of j-th column; c_dual[j], j = 1,...,n, is the dual value of j-th column. </p>
 */
public static int glp_write_ipt(glp_prob P, String fname) {
    return GLPKJNI.glp_write_ipt(glp_prob.getCPtr(P), P, fname);
  }

  
/**
 */
public static int glp_print_mip(glp_prob P, String fname) {
    return GLPKJNI.glp_print_mip(glp_prob.getCPtr(P), P, fname);
  }

  
/**
 * glp_read_mip - read MIP solution from text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_mip(glp_prob *mip, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_mip reads MIP solution from a text file whose name is specified by the parameter fname into the problem object.</p>
 * <p>For the file format see description of the routine glp_write_mip.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns zero, otherwise non-zero. </p>
 */
public static int glp_read_mip(glp_prob P, String fname) {
    return GLPKJNI.glp_read_mip(glp_prob.getCPtr(P), P, fname);
  }

  
/**
 * glp_write_mip - write MIP solution to text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_mip(glp_prob *mip, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_mip writes the current MIP solution to a text file whose name is specified by the parameter fname. This file can be read back with the routine glp_read_mip.</p>
 * <p>RETURNS</p>
 * <p>On success the routine returns zero, otherwise non-zero.</p>
 * <p>FILE FORMAT</p>
 * <p>The file created by the routine glp_write_sol is a plain text file, which contains the following information:</p>
 * <p>m n stat obj_val r_val[1] . . . r_val[m] c_val[1] . . . c_val[n]</p>
 * <p>where: m is the number of rows (auxiliary variables); n is the number of columns (structural variables); stat is the solution status (GLP_UNDEF = 1, GLP_FEAS = 2, GLP_NOFEAS = 4, or GLP_OPT = 5); obj_val is the objective value; r_val[i], i = 1,...,m, is the value of i-th row; c_val[j], j = 1,...,n, is the value of j-th column. </p>
 */
public static int glp_write_mip(glp_prob P, String fname) {
    return GLPKJNI.glp_write_mip(glp_prob.getCPtr(P), P, fname);
  }

  
/**
 * glp_bf_exists - check if the basis factorization exists .
 * <p>SYNOPSIS</p>
 * <p>int glp_bf_exists(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>If the basis factorization for the current basis associated with the specified problem object exists and therefore is available for computations, the routine glp_bf_exists returns non-zero. Otherwise the routine returns zero. </p>
 */
public static int glp_bf_exists(glp_prob P) {
    return GLPKJNI.glp_bf_exists(glp_prob.getCPtr(P), P);
  }

  
/**
 */
public static int glp_factorize(glp_prob P) {
    return GLPKJNI.glp_factorize(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_bf_updated - check if the basis factorization has been updated .
 * <p>SYNOPSIS</p>
 * <p>int glp_bf_updated(glp_prob *lp);</p>
 * <p>RETURNS</p>
 * <p>If the basis factorization has been just computed from scratch, the routine glp_bf_updated returns zero. Otherwise, if the factorization has been updated one or more times, the routine returns non-zero. </p>
 */
public static int glp_bf_updated(glp_prob P) {
    return GLPKJNI.glp_bf_updated(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_get_bfcp - retrieve basis factorization control parameters .
 * <p>SYNOPSIS</p>
 * <p>void glp_get_bfcp(glp_prob *lp, glp_bfcp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_get_bfcp retrieves control parameters, which are used on computing and updating the basis factorization associated with the specified problem object.</p>
 * <p>Current values of control parameters are stored by the routine in a glp_bfcp structure, which the parameter parm points to. </p>
 */
public static void glp_get_bfcp(glp_prob P, glp_bfcp parm) {
    GLPKJNI.glp_get_bfcp(glp_prob.getCPtr(P), P, glp_bfcp.getCPtr(parm), parm);
  }

  
/**
 * glp_set_bfcp - change basis factorization control parameters .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_bfcp(glp_prob *lp, const glp_bfcp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_bfcp changes control parameters, which are used by internal GLPK routines in computing and updating the basis factorization associated with the specified problem object.</p>
 * <p>New values of the control parameters should be passed in a structure glp_bfcp, which the parameter parm points to.</p>
 * <p>The parameter parm can be specified as NULL, in which case all control parameters are reset to their default values. </p>
 */
public static void glp_set_bfcp(glp_prob P, glp_bfcp parm) {
    GLPKJNI.glp_set_bfcp(glp_prob.getCPtr(P), P, glp_bfcp.getCPtr(parm), parm);
  }

  
/**
 * glp_get_bhead - retrieve the basis header information .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_bhead(glp_prob *lp, int k);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_get_bhead returns the basis header information for the current basis associated with the specified problem object.</p>
 * <p>RETURNS</p>
 * <p>If xB[k], 1 &lt;= k &lt;= m, is i-th auxiliary variable (1 &lt;= i &lt;= m), the routine returns i. Otherwise, if xB[k] is j-th structural variable (1 &lt;= j &lt;= n), the routine returns m+j. Here m is the number of rows and n is the number of columns in the problem object. </p>
 */
public static int glp_get_bhead(glp_prob P, int k) {
    return GLPKJNI.glp_get_bhead(glp_prob.getCPtr(P), P, k);
  }

  
/**
 * glp_get_row_bind - retrieve row index in the basis header .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_row_bind(glp_prob *lp, int i);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_row_bind returns the index k of basic variable xB[k], 1 &lt;= k &lt;= m, which is i-th auxiliary variable, 1 &lt;= i &lt;= m, in the current basis associated with the specified problem object, where m is the number of rows. However, if i-th auxiliary variable is non-basic, the routine returns zero. </p>
 */
public static int glp_get_row_bind(glp_prob P, int i) {
    return GLPKJNI.glp_get_row_bind(glp_prob.getCPtr(P), P, i);
  }

  
/**
 * glp_get_col_bind - retrieve column index in the basis header .
 * <p>SYNOPSIS</p>
 * <p>int glp_get_col_bind(glp_prob *lp, int j);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_get_col_bind returns the index k of basic variable xB[k], 1 &lt;= k &lt;= m, which is j-th structural variable, 1 &lt;= j &lt;= n, in the current basis associated with the specified problem object, where m is the number of rows, n is the number of columns. However, if j-th structural variable is non-basic, the routine returns zero. </p>
 */
public static int glp_get_col_bind(glp_prob P, int j) {
    return GLPKJNI.glp_get_col_bind(glp_prob.getCPtr(P), P, j);
  }

  
/**
 * glp_ftran - perform forward transformation (solve system B*x = b) .
 * <p>SYNOPSIS</p>
 * <p>void glp_ftran(glp_prob *lp, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ftran performs forward transformation, i.e. solves the system B*x = b, where B is the basis matrix corresponding to the current basis for the specified problem object, x is the vector of unknowns to be computed, b is the vector of right-hand sides.</p>
 * <p>On entry elements of the vector b should be stored in dense format in locations x[1], ..., x[m], where m is the number of rows. On exit the routine stores elements of the vector x in the same locations.</p>
 * <p>SCALING/UNSCALING</p>
 * <p>Let A~ = (I | -A) is the augmented constraint matrix of the original (unscaled) problem. In the scaled LP problem instead the matrix A the scaled matrix A" = R*A*S is actually used, so</p>
 * <p>A~" = (I | A") = (I | R*A*S) = (R*I*inv(R) | R*A*S) = (1) = R*(I | A)*S~ = R*A~*S~,</p>
 * <p>is the scaled augmented constraint matrix, where R and S are diagonal scaling matrices used to scale rows and columns of the matrix A, and</p>
 * <p>S~ = diag(inv(R) | S) (2)</p>
 * <p>is an augmented diagonal scaling matrix.</p>
 * <p>By definition:</p>
 * <p>A~ = (B | N), (3)</p>
 * <p>where B is the basic matrix, which consists of basic columns of the augmented constraint matrix A~, and N is a matrix, which consists of non-basic columns of A~. From (1) it follows that:</p>
 * <p>A~" = (B" | N") = (R*B*SB | R*N*SN), (4)</p>
 * <p>where SB and SN are parts of the augmented scaling matrix S~, which correspond to basic and non-basic variables, respectively. Therefore</p>
 * <p>B" = R*B*SB, (5)</p>
 * <p>which is the scaled basis matrix. </p>
 */
public static void glp_ftran(glp_prob P, SWIGTYPE_p_double x) {
    GLPKJNI.glp_ftran(glp_prob.getCPtr(P), P, SWIGTYPE_p_double.getCPtr(x));
  }

  
/**
 * glp_btran - perform backward transformation (solve system B'*x = b) .
 * <p>SYNOPSIS</p>
 * <p>void glp_btran(glp_prob *lp, double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_btran performs backward transformation, i.e. solves the system B'*x = b, where B' is a matrix transposed to the basis matrix corresponding to the current basis for the specified problem problem object, x is the vector of unknowns to be computed, b is the vector of right-hand sides.</p>
 * <p>On entry elements of the vector b should be stored in dense format in locations x[1], ..., x[m], where m is the number of rows. On exit the routine stores elements of the vector x in the same locations.</p>
 * <p>SCALING/UNSCALING</p>
 * <p>See comments to the routine glp_ftran. </p>
 */
public static void glp_btran(glp_prob P, SWIGTYPE_p_double x) {
    GLPKJNI.glp_btran(glp_prob.getCPtr(P), P, SWIGTYPE_p_double.getCPtr(x));
  }

  
/**
 * glp_warm_up - "warm up" LP basis .
 * <p>SYNOPSIS</p>
 * <p>int glp_warm_up(glp_prob *P);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_warm_up "warms up" the LP basis for the specified problem object using current statuses assigned to rows and columns (that is, to auxiliary and structural variables).</p>
 * <p>This operation includes computing factorization of the basis matrix (if it does not exist), computing primal and dual components of basic solution, and determining the solution status.</p>
 * <p>RETURNS</p>
 * <p>0 The operation has been successfully performed.</p>
 * <p>GLP_EBADB The basis matrix is invalid, i.e. the number of basic (auxiliary and structural) variables differs from the number of rows in the problem object.</p>
 * <p>GLP_ESING The basis matrix is singular within the working precision.</p>
 * <p>GLP_ECOND The basis matrix is ill-conditioned. </p>
 */
public static int glp_warm_up(glp_prob P) {
    return GLPKJNI.glp_warm_up(glp_prob.getCPtr(P), P);
  }

  
/**
 * glp_eval_tab_row - compute row of the simplex tableau .
 * <p>SYNOPSIS</p>
 * <p>int glp_eval_tab_row(glp_prob *lp, int k, int ind[], double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_eval_tab_row computes a row of the current simplex tableau for the basic variable, which is specified by the number k: if 1 &lt;= k &lt;= m, x[k] is k-th auxiliary variable; if m+1 &lt;= k &lt;= m+n, x[k] is (k-m)-th structural variable, where m is number of rows, and n is number of columns. The current basis must be available.</p>
 * <p>The routine stores column indices and numerical values of non-zero elements of the computed row using sparse format to the locations ind[1], ..., ind[len] and val[1], ..., val[len], respectively, where 0 &lt;= len &lt;= n is number of non-zeros returned on exit.</p>
 * <p>Element indices stored in the array ind have the same sense as the index k, i.e. indices 1 to m denote auxiliary variables and indices m+1 to m+n denote structural ones (all these variables are obviously non-basic by definition).</p>
 * <p>The computed row shows how the specified basic variable x[k] = xB[i] depends on non-basic variables:</p>
 * <p>xB[i] = alfa[i,1]*xN[1] + alfa[i,2]*xN[2] + ... + alfa[i,n]*xN[n],</p>
 * <p>where alfa[i,j] are elements of the simplex table row, xN[j] are non-basic (auxiliary and structural) variables.</p>
 * <p>RETURNS</p>
 * <p>The routine returns number of non-zero elements in the simplex table row stored in the arrays ind and val.</p>
 * <p>BACKGROUND</p>
 * <p>The system of equality constraints of the LP problem is:</p>
 * <p>xR = A * xS, (1)</p>
 * <p>where xR is the vector of auxliary variables, xS is the vector of structural variables, A is the matrix of constraint coefficients.</p>
 * <p>The system (1) can be written in homogenous form as follows:</p>
 * <p>A~ * x = 0, (2)</p>
 * <p>where A~ = (I | -A) is the augmented constraint matrix (has m rows and m+n columns), x = (xR | xS) is the vector of all (auxiliary and structural) variables.</p>
 * <p>By definition for the current basis we have:</p>
 * <p>A~ = (B | N), (3)</p>
 * <p>where B is the basis matrix. Thus, the system (2) can be written as:</p>
 * <p>B * xB + N * xN = 0. (4)</p>
 * <p>From (4) it follows that:</p>
 * <p>xB = A^ * xN, (5)</p>
 * <p>where the matrix</p>
 * <p>A^ = - inv(B) * N (6)</p>
 * <p>is called the simplex table.</p>
 * <p>It is understood that i-th row of the simplex table is:</p>
 * <p>e * A^ = - e * inv(B) * N, (7)</p>
 * <p>where e is a unity vector with e[i] = 1.</p>
 * <p>To compute i-th row of the simplex table the routine first computes i-th row of the inverse:</p>
 * <p>rho = inv(B') * e, (8)</p>
 * <p>where B' is a matrix transposed to B, and then computes elements of i-th row of the simplex table as scalar products:</p>
 * <p>alfa[i,j] = - rho * N[j] for all j, (9)</p>
 * <p>where N[j] is a column of the augmented constraint matrix A~, which corresponds to some non-basic auxiliary or structural variable. </p>
 */
public static int glp_eval_tab_row(glp_prob P, int k, SWIGTYPE_p_int ind, SWIGTYPE_p_double val) {
    return GLPKJNI.glp_eval_tab_row(glp_prob.getCPtr(P), P, k, SWIGTYPE_p_int.getCPtr(ind), SWIGTYPE_p_double.getCPtr(val));
  }

  
/**
 * glp_eval_tab_col - compute column of the simplex tableau .
 * <p>SYNOPSIS</p>
 * <p>int glp_eval_tab_col(glp_prob *lp, int k, int ind[], double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_eval_tab_col computes a column of the current simplex table for the non-basic variable, which is specified by the number k: if 1 &lt;= k &lt;= m, x[k] is k-th auxiliary variable; if m+1 &lt;= k &lt;= m+n, x[k] is (k-m)-th structural variable, where m is number of rows, and n is number of columns. The current basis must be available.</p>
 * <p>The routine stores row indices and numerical values of non-zero elements of the computed column using sparse format to the locations ind[1], ..., ind[len] and val[1], ..., val[len] respectively, where 0 &lt;= len &lt;= m is number of non-zeros returned on exit.</p>
 * <p>Element indices stored in the array ind have the same sense as the index k, i.e. indices 1 to m denote auxiliary variables and indices m+1 to m+n denote structural ones (all these variables are obviously basic by the definition).</p>
 * <p>The computed column shows how basic variables depend on the specified non-basic variable x[k] = xN[j]:</p>
 * <p>xB[1] = ... + alfa[1,j]*xN[j] + ... xB[2] = ... + alfa[2,j]*xN[j] + ... . . . . . . xB[m] = ... + alfa[m,j]*xN[j] + ...</p>
 * <p>where alfa[i,j] are elements of the simplex table column, xB[i] are basic (auxiliary and structural) variables.</p>
 * <p>RETURNS</p>
 * <p>The routine returns number of non-zero elements in the simplex table column stored in the arrays ind and val.</p>
 * <p>BACKGROUND</p>
 * <p>As it was explained in comments to the routine glp_eval_tab_row (see above) the simplex table is the following matrix:</p>
 * <p>A^ = - inv(B) * N. (1)</p>
 * <p>Therefore j-th column of the simplex table is:</p>
 * <p>A^ * e = - inv(B) * N * e = - inv(B) * N[j], (2)</p>
 * <p>where e is a unity vector with e[j] = 1, B is the basis matrix, N[j] is a column of the augmented constraint matrix A~, which corresponds to the given non-basic auxiliary or structural variable. </p>
 */
public static int glp_eval_tab_col(glp_prob P, int k, SWIGTYPE_p_int ind, SWIGTYPE_p_double val) {
    return GLPKJNI.glp_eval_tab_col(glp_prob.getCPtr(P), P, k, SWIGTYPE_p_int.getCPtr(ind), SWIGTYPE_p_double.getCPtr(val));
  }

  
/**
 * glp_transform_row - transform explicitly specified row .
 * <p>SYNOPSIS</p>
 * <p>int glp_transform_row(glp_prob *P, int len, int ind[], double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_transform_row performs the same operation as the routine glp_eval_tab_row with exception that the row to be transformed is specified explicitly as a sparse vector.</p>
 * <p>The explicitly specified row may be thought as a linear form:</p>
 * <p>x = a[1]*x[m+1] + a[2]*x[m+2] + ... + a[n]*x[m+n], (1)</p>
 * <p>where x is an auxiliary variable for this row, a[j] are coefficients of the linear form, x[m+j] are structural variables.</p>
 * <p>On entry column indices and numerical values of non-zero elements of the row should be stored in locations ind[1], ..., ind[len] and val[1], ..., val[len], where len is the number of non-zero elements.</p>
 * <p>This routine uses the system of equality constraints and the current basis in order to express the auxiliary variable x in (1) through the current non-basic variables (as if the transformed row were added to the problem object and its auxiliary variable were basic), i.e. the resultant row has the form:</p>
 * <p>x = alfa[1]*xN[1] + alfa[2]*xN[2] + ... + alfa[n]*xN[n], (2)</p>
 * <p>where xN[j] are non-basic (auxiliary or structural) variables, n is the number of columns in the LP problem object.</p>
 * <p>On exit the routine stores indices and numerical values of non-zero elements of the resultant row (2) in locations ind[1], ..., ind[len'] and val[1], ..., val[len'], where 0 &lt;= len' &lt;= n is the number of non-zero elements in the resultant row returned by the routine. Note that indices (numbers) of non-basic variables stored in the array ind correspond to original ordinal numbers of variables: indices 1 to m mean auxiliary variables and indices m+1 to m+n mean structural ones.</p>
 * <p>RETURNS</p>
 * <p>The routine returns len', which is the number of non-zero elements in the resultant row stored in the arrays ind and val.</p>
 * <p>BACKGROUND</p>
 * <p>The explicitly specified row (1) is transformed in the same way as it were the objective function row.</p>
 * <p>From (1) it follows that:</p>
 * <p>x = aB * xB + aN * xN, (3)</p>
 * <p>where xB is the vector of basic variables, xN is the vector of non-basic variables.</p>
 * <p>The simplex table, which corresponds to the current basis, is:</p>
 * <p>xB = [-inv(B) * N] * xN. (4)</p>
 * <p>Therefore substituting xB from (4) to (3) we have:</p>
 * <p>x = aB * [-inv(B) * N] * xN + aN * xN = (5) = rho * (-N) * xN + aN * xN = alfa * xN,</p>
 * <p>where:</p>
 * <p>rho = inv(B') * aB, (6)</p>
 * <p>and</p>
 * <p>alfa = aN + rho * (-N) (7)</p>
 * <p>is the resultant row computed by the routine. </p>
 */
public static int glp_transform_row(glp_prob P, int len, SWIGTYPE_p_int ind, SWIGTYPE_p_double val) {
    return GLPKJNI.glp_transform_row(glp_prob.getCPtr(P), P, len, SWIGTYPE_p_int.getCPtr(ind), SWIGTYPE_p_double.getCPtr(val));
  }

  
/**
 * glp_transform_col - transform explicitly specified column .
 * <p>SYNOPSIS</p>
 * <p>int glp_transform_col(glp_prob *P, int len, int ind[], double val[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_transform_col performs the same operation as the routine glp_eval_tab_col with exception that the column to be transformed is specified explicitly as a sparse vector.</p>
 * <p>The explicitly specified column may be thought as if it were added to the original system of equality constraints:</p>
 * <p>x[1] = a[1,1]*x[m+1] + ... + a[1,n]*x[m+n] + a[1]*x x[2] = a[2,1]*x[m+1] + ... + a[2,n]*x[m+n] + a[2]*x (1) . . . . . . . . . . . . . . . x[m] = a[m,1]*x[m+1] + ... + a[m,n]*x[m+n] + a[m]*x</p>
 * <p>where x[i] are auxiliary variables, x[m+j] are structural variables, x is a structural variable for the explicitly specified column, a[i] are constraint coefficients for x.</p>
 * <p>On entry row indices and numerical values of non-zero elements of the column should be stored in locations ind[1], ..., ind[len] and val[1], ..., val[len], where len is the number of non-zero elements.</p>
 * <p>This routine uses the system of equality constraints and the current basis in order to express the current basic variables through the structural variable x in (1) (as if the transformed column were added to the problem object and the variable x were non-basic), i.e. the resultant column has the form:</p>
 * <p>xB[1] = ... + alfa[1]*x xB[2] = ... + alfa[2]*x (2) . . . . . . xB[m] = ... + alfa[m]*x</p>
 * <p>where xB are basic (auxiliary and structural) variables, m is the number of rows in the problem object.</p>
 * <p>On exit the routine stores indices and numerical values of non-zero elements of the resultant column (2) in locations ind[1], ..., ind[len'] and val[1], ..., val[len'], where 0 &lt;= len' &lt;= m is the number of non-zero element in the resultant column returned by the routine. Note that indices (numbers) of basic variables stored in the array ind correspond to original ordinal numbers of variables: indices 1 to m mean auxiliary variables and indices m+1 to m+n mean structural ones.</p>
 * <p>RETURNS</p>
 * <p>The routine returns len', which is the number of non-zero elements in the resultant column stored in the arrays ind and val.</p>
 * <p>BACKGROUND</p>
 * <p>The explicitly specified column (1) is transformed in the same way as any other column of the constraint matrix using the formula:</p>
 * <p>alfa = inv(B) * a, (3)</p>
 * <p>where alfa is the resultant column computed by the routine. </p>
 */
public static int glp_transform_col(glp_prob P, int len, SWIGTYPE_p_int ind, SWIGTYPE_p_double val) {
    return GLPKJNI.glp_transform_col(glp_prob.getCPtr(P), P, len, SWIGTYPE_p_int.getCPtr(ind), SWIGTYPE_p_double.getCPtr(val));
  }

  
/**
 * glp_prim_rtest - perform primal ratio test .
 * <p>SYNOPSIS</p>
 * <p>int glp_prim_rtest(glp_prob *P, int len, const int ind[], const double val[], int dir, double eps);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_prim_rtest performs the primal ratio test using an explicitly specified column of the simplex table.</p>
 * <p>The current basic solution associated with the LP problem object must be primal feasible.</p>
 * <p>The explicitly specified column of the simplex table shows how the basic variables xB depend on some non-basic variable x (which is not necessarily presented in the problem object):</p>
 * <p>xB[1] = ... + alfa[1] * x + ... xB[2] = ... + alfa[2] * x + ... (*) . . . . . . . . xB[m] = ... + alfa[m] * x + ...</p>
 * <p>The column (*) is specifed on entry to the routine using the sparse format. Ordinal numbers of basic variables xB[i] should be placed in locations ind[1], ..., ind[len], where ordinal number 1 to m denote auxiliary variables, and ordinal numbers m+1 to m+n denote structural variables. The corresponding non-zero coefficients alfa[i] should be placed in locations val[1], ..., val[len]. The arrays ind and val are not changed on exit.</p>
 * <p>The parameter dir specifies direction in which the variable x changes on entering the basis: +1 means increasing, -1 means decreasing.</p>
 * <p>The parameter eps is an absolute tolerance (small positive number) used by the routine to skip small alfa[j] of the row (*).</p>
 * <p>The routine determines which basic variable (among specified in ind[1], ..., ind[len]) should leave the basis in order to keep primal feasibility.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_prim_rtest returns the index piv in the arrays ind and val corresponding to the pivot element chosen, 1 &lt;= piv &lt;= len. If the adjacent basic solution is primal unbounded and therefore the choice cannot be made, the routine returns zero.</p>
 * <p>COMMENTS</p>
 * <p>If the non-basic variable x is presented in the LP problem object, the column (*) can be computed with the routine glp_eval_tab_col; otherwise it can be computed with the routine glp_transform_col. </p>
 */
public static int glp_prim_rtest(glp_prob P, int len, SWIGTYPE_p_int ind, SWIGTYPE_p_double val, int dir, double eps) {
    return GLPKJNI.glp_prim_rtest(glp_prob.getCPtr(P), P, len, SWIGTYPE_p_int.getCPtr(ind), SWIGTYPE_p_double.getCPtr(val), dir, eps);
  }

  
/**
 * glp_dual_rtest - perform dual ratio test .
 * <p>SYNOPSIS</p>
 * <p>int glp_dual_rtest(glp_prob *P, int len, const int ind[], const double val[], int dir, double eps);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_dual_rtest performs the dual ratio test using an explicitly specified row of the simplex table.</p>
 * <p>The current basic solution associated with the LP problem object must be dual feasible.</p>
 * <p>The explicitly specified row of the simplex table is a linear form that shows how some basic variable x (which is not necessarily presented in the problem object) depends on non-basic variables xN:</p>
 * <p>x = alfa[1] * xN[1] + alfa[2] * xN[2] + ... + alfa[n] * xN[n]. (*)</p>
 * <p>The row (*) is specified on entry to the routine using the sparse format. Ordinal numbers of non-basic variables xN[j] should be placed in locations ind[1], ..., ind[len], where ordinal numbers 1 to m denote auxiliary variables, and ordinal numbers m+1 to m+n denote structural variables. The corresponding non-zero coefficients alfa[j] should be placed in locations val[1], ..., val[len]. The arrays ind and val are not changed on exit.</p>
 * <p>The parameter dir specifies direction in which the variable x changes on leaving the basis: +1 means that x goes to its lower bound, and -1 means that x goes to its upper bound.</p>
 * <p>The parameter eps is an absolute tolerance (small positive number) used by the routine to skip small alfa[j] of the row (*).</p>
 * <p>The routine determines which non-basic variable (among specified in ind[1], ..., ind[len]) should enter the basis in order to keep dual feasibility.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_dual_rtest returns the index piv in the arrays ind and val corresponding to the pivot element chosen, 1 &lt;= piv &lt;= len. If the adjacent basic solution is dual unbounded and therefore the choice cannot be made, the routine returns zero.</p>
 * <p>COMMENTS</p>
 * <p>If the basic variable x is presented in the LP problem object, the row (*) can be computed with the routine glp_eval_tab_row; otherwise it can be computed with the routine glp_transform_row. </p>
 */
public static int glp_dual_rtest(glp_prob P, int len, SWIGTYPE_p_int ind, SWIGTYPE_p_double val, int dir, double eps) {
    return GLPKJNI.glp_dual_rtest(glp_prob.getCPtr(P), P, len, SWIGTYPE_p_int.getCPtr(ind), SWIGTYPE_p_double.getCPtr(val), dir, eps);
  }

  
/**
 * glp_analyze_bound - analyze active bound of non-basic variable .
 * <p>SYNOPSIS</p>
 * <p>void glp_analyze_bound(glp_prob *P, int k, double *limit1, int *var1, double *limit2, int *var2);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_analyze_bound analyzes the effect of varying the active bound of specified non-basic variable.</p>
 * <p>The non-basic variable is specified by the parameter k, where 1 &lt;= k &lt;= m means auxiliary variable of corresponding row while m+1 &lt;= k &lt;= m+n means structural variable (column).</p>
 * <p>Note that the current basic solution must be optimal, and the basis factorization must exist.</p>
 * <p>Results of the analysis have the following meaning.</p>
 * <p>value1 is the minimal value of the active bound, at which the basis still remains primal feasible and thus optimal. -DBL_MAX means that the active bound has no lower limit.</p>
 * <p>var1 is the ordinal number of an auxiliary (1 to m) or structural (m+1 to n) basic variable, which reaches its bound first and thereby limits further decreasing the active bound being analyzed. if value1 = -DBL_MAX, var1 is set to 0.</p>
 * <p>value2 is the maximal value of the active bound, at which the basis still remains primal feasible and thus optimal. +DBL_MAX means that the active bound has no upper limit.</p>
 * <p>var2 is the ordinal number of an auxiliary (1 to m) or structural (m+1 to n) basic variable, which reaches its bound first and thereby limits further increasing the active bound being analyzed. if value2 = +DBL_MAX, var2 is set to 0. </p>
 */
public static void glp_analyze_bound(glp_prob P, int k, SWIGTYPE_p_double value1, SWIGTYPE_p_int var1, SWIGTYPE_p_double value2, SWIGTYPE_p_int var2) {
    GLPKJNI.glp_analyze_bound(glp_prob.getCPtr(P), P, k, SWIGTYPE_p_double.getCPtr(value1), SWIGTYPE_p_int.getCPtr(var1), SWIGTYPE_p_double.getCPtr(value2), SWIGTYPE_p_int.getCPtr(var2));
  }

  
/**
 * glp_analyze_coef - analyze objective coefficient at basic variable .
 * <p>SYNOPSIS</p>
 * <p>void glp_analyze_coef(glp_prob *P, int k, double *coef1, int *var1, double *value1, double *coef2, int *var2, double *value2);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_analyze_coef analyzes the effect of varying the objective coefficient at specified basic variable.</p>
 * <p>The basic variable is specified by the parameter k, where 1 &lt;= k &lt;= m means auxiliary variable of corresponding row while m+1 &lt;= k &lt;= m+n means structural variable (column).</p>
 * <p>Note that the current basic solution must be optimal, and the basis factorization must exist.</p>
 * <p>Results of the analysis have the following meaning.</p>
 * <p>coef1 is the minimal value of the objective coefficient, at which the basis still remains dual feasible and thus optimal. -DBL_MAX means that the objective coefficient has no lower limit.</p>
 * <p>var1 is the ordinal number of an auxiliary (1 to m) or structural (m+1 to n) non-basic variable, whose reduced cost reaches its zero bound first and thereby limits further decreasing the objective coefficient being analyzed. If coef1 = -DBL_MAX, var1 is set to 0.</p>
 * <p>value1 is value of the basic variable being analyzed in an adjacent basis, which is defined as follows. Let the objective coefficient reaches its minimal value (coef1) and continues decreasing. Then the reduced cost of the limiting non-basic variable (var1) becomes dual infeasible and the current basis becomes non-optimal that forces the limiting non-basic variable to enter the basis replacing there some basic variable that leaves the basis to keep primal feasibility. Should note that on determining the adjacent basis current bounds of the basic variable being analyzed are ignored as if it were free (unbounded) variable, so it cannot leave the basis. It may happen that no dual feasible adjacent basis exists, in which case value1 is set to -DBL_MAX or +DBL_MAX.</p>
 * <p>coef2 is the maximal value of the objective coefficient, at which the basis still remains dual feasible and thus optimal. +DBL_MAX means that the objective coefficient has no upper limit.</p>
 * <p>var2 is the ordinal number of an auxiliary (1 to m) or structural (m+1 to n) non-basic variable, whose reduced cost reaches its zero bound first and thereby limits further increasing the objective coefficient being analyzed. If coef2 = +DBL_MAX, var2 is set to 0.</p>
 * <p>value2 is value of the basic variable being analyzed in an adjacent basis, which is defined exactly in the same way as value1 above with exception that now the objective coefficient is increasing. </p>
 */
public static void glp_analyze_coef(glp_prob P, int k, SWIGTYPE_p_double coef1, SWIGTYPE_p_int var1, SWIGTYPE_p_double value1, SWIGTYPE_p_double coef2, SWIGTYPE_p_int var2, SWIGTYPE_p_double value2) {
    GLPKJNI.glp_analyze_coef(glp_prob.getCPtr(P), P, k, SWIGTYPE_p_double.getCPtr(coef1), SWIGTYPE_p_int.getCPtr(var1), SWIGTYPE_p_double.getCPtr(value1), SWIGTYPE_p_double.getCPtr(coef2), SWIGTYPE_p_int.getCPtr(var2), SWIGTYPE_p_double.getCPtr(value2));
  }

  
/**
 * glp_ios_reason - determine reason for calling the callback routine .
 * <p>SYNOPSIS</p>
 * <p>glp_ios_reason(glp_tree *tree);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_reason returns a code, which indicates why the user-defined callback routine is being called. </p>
 */
public static int glp_ios_reason(glp_tree T) {
    return GLPKJNI.glp_ios_reason(glp_tree.getCPtr(T), T);
  }

  
/**
 * glp_ios_get_prob - access the problem object .
 * <p>SYNOPSIS</p>
 * <p>glp_prob *glp_ios_get_prob(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_get_prob can be called from the user-defined callback routine to access the problem object, which is used by the MIP solver. It is the original problem object passed to the routine glp_intopt if the MIP presolver is not used; otherwise it is an internal problem object built by the presolver. If the current subproblem exists, LP segment of the problem object corresponds to its LP relaxation.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_get_prob returns a pointer to the problem object used by the MIP solver. </p>
 */
public static glp_prob glp_ios_get_prob(glp_tree T) {
    long cPtr = GLPKJNI.glp_ios_get_prob(glp_tree.getCPtr(T), T);
    return (cPtr == 0) ? null : new glp_prob(cPtr, false);
  }

  
/**
 * glp_ios_tree_size - determine size of the branch-and-bound tree .
 * <p>SYNOPSIS</p>
 * <p>void glp_ios_tree_size(glp_tree *tree, int *a_cnt, int *n_cnt, int *t_cnt);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_tree_size stores the following three counts which characterize the current size of the branch-and-bound tree:</p>
 * <p>a_cnt is the current number of active nodes, i.e. the current size of the active list;</p>
 * <p>n_cnt is the current number of all (active and inactive) nodes;</p>
 * <p>t_cnt is the total number of nodes including those which have been already removed from the tree. This count is increased whenever a new node appears in the tree and never decreased.</p>
 * <p>If some of the parameters a_cnt, n_cnt, t_cnt is a null pointer, the corresponding count is not stored. </p>
 */
public static void glp_ios_tree_size(glp_tree T, SWIGTYPE_p_int a_cnt, SWIGTYPE_p_int n_cnt, SWIGTYPE_p_int t_cnt) {
    GLPKJNI.glp_ios_tree_size(glp_tree.getCPtr(T), T, SWIGTYPE_p_int.getCPtr(a_cnt), SWIGTYPE_p_int.getCPtr(n_cnt), SWIGTYPE_p_int.getCPtr(t_cnt));
  }

  
/**
 * glp_ios_curr_node - determine current active subproblem .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_curr_node(glp_tree *tree);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_curr_node returns the reference number of the current active subproblem. However, if the current subproblem does not exist, the routine returns zero. </p>
 */
public static int glp_ios_curr_node(glp_tree T) {
    return GLPKJNI.glp_ios_curr_node(glp_tree.getCPtr(T), T);
  }

  
/**
 * glp_ios_next_node - determine next active subproblem .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_next_node(glp_tree *tree, int p);</p>
 * <p>RETURNS</p>
 * <p>If the parameter p is zero, the routine glp_ios_next_node returns the reference number of the first active subproblem. However, if the tree is empty, zero is returned.</p>
 * <p>If the parameter p is not zero, it must specify the reference number of some active subproblem, in which case the routine returns the reference number of the next active subproblem. However, if there is no next active subproblem in the list, zero is returned.</p>
 * <p>All subproblems in the active list are ordered chronologically, i.e. subproblem A precedes subproblem B if A was created before B. </p>
 */
public static int glp_ios_next_node(glp_tree T, int p) {
    return GLPKJNI.glp_ios_next_node(glp_tree.getCPtr(T), T, p);
  }

  
/**
 * glp_ios_prev_node - determine previous active subproblem .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_prev_node(glp_tree *tree, int p);</p>
 * <p>RETURNS</p>
 * <p>If the parameter p is zero, the routine glp_ios_prev_node returns the reference number of the last active subproblem. However, if the tree is empty, zero is returned.</p>
 * <p>If the parameter p is not zero, it must specify the reference number of some active subproblem, in which case the routine returns the reference number of the previous active subproblem. However, if there is no previous active subproblem in the list, zero is returned.</p>
 * <p>All subproblems in the active list are ordered chronologically, i.e. subproblem A precedes subproblem B if A was created before B. </p>
 */
public static int glp_ios_prev_node(glp_tree T, int p) {
    return GLPKJNI.glp_ios_prev_node(glp_tree.getCPtr(T), T, p);
  }

  
/**
 * glp_ios_up_node - determine parent subproblem .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_up_node(glp_tree *tree, int p);</p>
 * <p>RETURNS</p>
 * <p>The parameter p must specify the reference number of some (active or inactive) subproblem, in which case the routine iet_get_up_node returns the reference number of its parent subproblem. However, if the specified subproblem is the root of the tree and, therefore, has no parent, the routine returns zero. </p>
 */
public static int glp_ios_up_node(glp_tree T, int p) {
    return GLPKJNI.glp_ios_up_node(glp_tree.getCPtr(T), T, p);
  }

  
/**
 * glp_ios_node_level - determine subproblem level .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_node_level(glp_tree *tree, int p);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_node_level returns the level of the subproblem, whose reference number is p, in the branch-and-bound tree. (The root subproblem has level 0, and the level of any other subproblem is the level of its parent plus one.) </p>
 */
public static int glp_ios_node_level(glp_tree T, int p) {
    return GLPKJNI.glp_ios_node_level(glp_tree.getCPtr(T), T, p);
  }

  
/**
 * glp_ios_node_bound - determine subproblem local bound .
 * <p>SYNOPSIS</p>
 * <p>double glp_ios_node_bound(glp_tree *tree, int p);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_node_bound returns the local bound for (active or inactive) subproblem, whose reference number is p.</p>
 * <p>COMMENTS</p>
 * <p>The local bound for subproblem p is an lower (minimization) or upper (maximization) bound for integer optimal solution to this subproblem (not to the original problem). This bound is local in the sense that only subproblems in the subtree rooted at node p cannot have better integer feasible solutions.</p>
 * <p>On creating a subproblem (due to the branching step) its local bound is inherited from its parent and then may get only stronger (never weaker). For the root subproblem its local bound is initially set to -DBL_MAX (minimization) or +DBL_MAX (maximization) and then improved as the root LP relaxation has been solved.</p>
 * <p>Note that the local bound is not necessarily the optimal objective value to corresponding LP relaxation; it may be stronger. </p>
 */
public static double glp_ios_node_bound(glp_tree T, int p) {
    return GLPKJNI.glp_ios_node_bound(glp_tree.getCPtr(T), T, p);
  }

  
/**
 * glp_ios_best_node - find active subproblem with best local bound .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_best_node(glp_tree *tree);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_best_node returns the reference number of the active subproblem, whose local bound is best (i.e. smallest in case of minimization or largest in case of maximization). However, if the tree is empty, the routine returns zero.</p>
 * <p>COMMENTS</p>
 * <p>The best local bound is an lower (minimization) or upper (maximization) bound for integer optimal solution to the original MIP problem. </p>
 */
public static int glp_ios_best_node(glp_tree T) {
    return GLPKJNI.glp_ios_best_node(glp_tree.getCPtr(T), T);
  }

  
/**
 * glp_ios_mip_gap - compute relative MIP gap .
 * <p>SYNOPSIS</p>
 * <p>double glp_ios_mip_gap(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_mip_gap computes the relative MIP gap with the following formula:</p>
 * <p>gap = |best_mip - best_bnd| / (|best_mip| + DBL_EPSILON),</p>
 * <p>where best_mip is the best integer feasible solution found so far, best_bnd is the best (global) bound. If no integer feasible solution has been found yet, gap is set to DBL_MAX.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_mip_gap returns the relative MIP gap. </p>
 */
public static double glp_ios_mip_gap(glp_tree T) {
    return GLPKJNI.glp_ios_mip_gap(glp_tree.getCPtr(T), T);
  }

  
/**
 * glp_ios_node_data - access subproblem application-specific data .
 * <p>SYNOPSIS</p>
 * <p>void *glp_ios_node_data(glp_tree *tree, int p);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_node_data allows the application accessing a memory block allocated for the subproblem (which may be active or inactive), whose reference number is p.</p>
 * <p>The size of the block is defined by the control parameter cb_size passed to the routine glp_intopt. The block is initialized by binary zeros on creating corresponding subproblem, and its contents is kept until the subproblem will be removed from the tree.</p>
 * <p>The application may use these memory blocks to store specific data for each subproblem.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_ios_node_data returns a pointer to the memory block for the specified subproblem. Note that if cb_size = 0, the routine returns a null pointer. </p>
 */
public static SWIGTYPE_p_void glp_ios_node_data(glp_tree T, int p) {
    long cPtr = GLPKJNI.glp_ios_node_data(glp_tree.getCPtr(T), T, p);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  
/**
 * glp_ios_row_attr - retrieve additional row attributes .
 * <p>SYNOPSIS</p>
 * <p>void glp_ios_row_attr(glp_tree *tree, int i, glp_attr *attr);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_row_attr retrieves additional attributes of row i and stores them in the structure glp_attr. </p>
 */
public static void glp_ios_row_attr(glp_tree T, int i, glp_attr attr) {
    GLPKJNI.glp_ios_row_attr(glp_tree.getCPtr(T), T, i, glp_attr.getCPtr(attr), attr);
  }

  
/**
 */
public static int glp_ios_pool_size(glp_tree T) {
    return GLPKJNI.glp_ios_pool_size(glp_tree.getCPtr(T), T);
  }

  
/**
 */
public static int glp_ios_add_row(glp_tree T, String name, int klass, int flags, int len, SWIGTYPE_p_int ind, SWIGTYPE_p_double val, int type, double rhs) {
    return GLPKJNI.glp_ios_add_row(glp_tree.getCPtr(T), T, name, klass, flags, len, SWIGTYPE_p_int.getCPtr(ind), SWIGTYPE_p_double.getCPtr(val), type, rhs);
  }

  
/**
 */
public static void glp_ios_del_row(glp_tree T, int i) {
    GLPKJNI.glp_ios_del_row(glp_tree.getCPtr(T), T, i);
  }

  
/**
 */
public static void glp_ios_clear_pool(glp_tree T) {
    GLPKJNI.glp_ios_clear_pool(glp_tree.getCPtr(T), T);
  }

  
/**
 * glp_ios_can_branch - check if can branch upon specified variable .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_can_branch(glp_tree *tree, int j);</p>
 * <p>RETURNS</p>
 * <p>If j-th variable (column) can be used to branch upon, the routine glp_ios_can_branch returns non-zero, otherwise zero. </p>
 */
public static int glp_ios_can_branch(glp_tree T, int j) {
    return GLPKJNI.glp_ios_can_branch(glp_tree.getCPtr(T), T, j);
  }

  
/**
 * glp_ios_branch_upon - choose variable to branch upon .
 * <p>SYNOPSIS</p>
 * <p>void glp_ios_branch_upon(glp_tree *tree, int j, int sel);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_branch_upon can be called from the user-defined callback routine in response to the reason GLP_IBRANCH to choose a branching variable, whose ordinal number is j. Should note that only variables, for which the routine glp_ios_can_branch returns non-zero, can be used to branch upon.</p>
 * <p>The parameter sel is a flag that indicates which branch (subproblem) should be selected next to continue the search:</p>
 * <p>GLP_DN_BRNCH - select down-branch; GLP_UP_BRNCH - select up-branch; GLP_NO_BRNCH - use general selection technique. </p>
 */
public static void glp_ios_branch_upon(glp_tree T, int j, int sel) {
    GLPKJNI.glp_ios_branch_upon(glp_tree.getCPtr(T), T, j, sel);
  }

  
/**
 * glp_ios_select_node - select subproblem to continue the search .
 * <p>SYNOPSIS</p>
 * <p>void glp_ios_select_node(glp_tree *tree, int p);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_select_node can be called from the user-defined callback routine in response to the reason GLP_ISELECT to select an active subproblem, whose reference number is p. The search will be continued from the subproblem selected. </p>
 */
public static void glp_ios_select_node(glp_tree T, int p) {
    GLPKJNI.glp_ios_select_node(glp_tree.getCPtr(T), T, p);
  }

  
/**
 * glp_ios_heur_sol - provide solution found by heuristic .
 * <p>SYNOPSIS</p>
 * <p>int glp_ios_heur_sol(glp_tree *tree, const double x[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_heur_sol can be called from the user-defined callback routine in response to the reason GLP_IHEUR to provide an integer feasible solution found by a primal heuristic.</p>
 * <p>Primal values of all variables (columns) found by the heuristic should be placed in locations x[1], ..., x[n], where n is the number of columns in the original problem object. Note that the routine glp_ios_heur_sol does not check primal feasibility of the solution provided.</p>
 * <p>Using the solution passed in the array x the routine computes value of the objective function. If the objective value is better than the best known integer feasible solution, the routine computes values of auxiliary variables (rows) and stores all solution components in the problem object.</p>
 * <p>RETURNS</p>
 * <p>If the provided solution is accepted, the routine glp_ios_heur_sol returns zero. Otherwise, if the provided solution is rejected, the routine returns non-zero. </p>
 */
public static int glp_ios_heur_sol(glp_tree T, SWIGTYPE_p_double x) {
    return GLPKJNI.glp_ios_heur_sol(glp_tree.getCPtr(T), T, SWIGTYPE_p_double.getCPtr(x));
  }

  
/**
 * glp_ios_terminate - terminate the solution process. .
 * <p>SYNOPSIS</p>
 * <p>void glp_ios_terminate(glp_tree *tree);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_ios_terminate sets a flag indicating that the MIP solver should prematurely terminate the search. </p>
 */
public static void glp_ios_terminate(glp_tree T) {
    GLPKJNI.glp_ios_terminate(glp_tree.getCPtr(T), T);
  }

  
/**
 * glp_init_mpscp - initialize MPS format control parameters .
 * <p>SYNOPSIS</p>
 * <p>void glp_init_mpscp(glp_mpscp *parm);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_init_mpscp initializes control parameters, which are used by the MPS input/output routines glp_read_mps and glp_write_mps, with default values.</p>
 * <p>Default values of the control parameters are stored in the glp_mpscp structure, which the parameter parm points to. </p>
 */
public static void glp_init_mpscp(glp_mpscp parm) {
    GLPKJNI.glp_init_mpscp(glp_mpscp.getCPtr(parm), parm);
  }

  
/**
 */
public static int glp_read_mps(glp_prob P, int fmt, glp_mpscp parm, String fname) {
    return GLPKJNI.glp_read_mps(glp_prob.getCPtr(P), P, fmt, glp_mpscp.getCPtr(parm), parm, fname);
  }

  
/**
 */
public static int glp_write_mps(glp_prob P, int fmt, glp_mpscp parm, String fname) {
    return GLPKJNI.glp_write_mps(glp_prob.getCPtr(P), P, fmt, glp_mpscp.getCPtr(parm), parm, fname);
  }

  
/**
 * glp_init_cpxcp - initialize CPLEX LP format control parameters .
 * <p>SYNOPSIS</p>
 * <p>void glp_init_cpxcp(glp_cpxcp *parm):</p>
 * <p>The routine glp_init_cpxcp initializes control parameters used by the CPLEX LP input/output routines glp_read_lp and glp_write_lp with default values.</p>
 * <p>Default values of the control parameters are stored in the glp_cpxcp structure, which the parameter parm points to. </p>
 */
public static void glp_init_cpxcp(glp_cpxcp parm) {
    GLPKJNI.glp_init_cpxcp(glp_cpxcp.getCPtr(parm), parm);
  }

  
/**
 */
public static int glp_read_lp(glp_prob P, glp_cpxcp parm, String fname) {
    return GLPKJNI.glp_read_lp(glp_prob.getCPtr(P), P, glp_cpxcp.getCPtr(parm), parm, fname);
  }

  
/**
 */
public static int glp_write_lp(glp_prob P, glp_cpxcp parm, String fname) {
    return GLPKJNI.glp_write_lp(glp_prob.getCPtr(P), P, glp_cpxcp.getCPtr(parm), parm, fname);
  }

  
/**
 * glp_read_prob - read problem data in GLPK format .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_prob(glp_prob *P, int flags, const char *fname);</p>
 * <p>The routine glp_read_prob reads problem data in GLPK LP/MIP format from a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public static int glp_read_prob(glp_prob P, int flags, String fname) {
    return GLPKJNI.glp_read_prob(glp_prob.getCPtr(P), P, flags, fname);
  }

  
/**
 * glp_write_prob - write problem data in GLPK format .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_prob(glp_prob *P, int flags, const char *fname);</p>
 * <p>The routine glp_write_prob writes problem data in GLPK LP/MIP format to a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public static int glp_write_prob(glp_prob P, int flags, String fname) {
    return GLPKJNI.glp_write_prob(glp_prob.getCPtr(P), P, flags, fname);
  }

  
/**
 */
public static glp_tran glp_mpl_alloc_wksp() {
    long cPtr = GLPKJNI.glp_mpl_alloc_wksp();
    return (cPtr == 0) ? null : new glp_tran(cPtr, false);
  }

  public static void glp_mpl_init_rand(glp_tran tran, int seed) {
    GLPKJNI.glp_mpl_init_rand(glp_tran.getCPtr(tran), tran, seed);
  }

  
/**
 */
public static int glp_mpl_read_model(glp_tran tran, String fname, int skip) {
    return GLPKJNI.glp_mpl_read_model(glp_tran.getCPtr(tran), tran, fname, skip);
  }

  
/**
 */
public static int glp_mpl_read_data(glp_tran tran, String fname) {
    return GLPKJNI.glp_mpl_read_data(glp_tran.getCPtr(tran), tran, fname);
  }

  
/**
 */
public static int glp_mpl_generate(glp_tran tran, String fname) {
    return GLPKJNI.glp_mpl_generate(glp_tran.getCPtr(tran), tran, fname);
  }

  
/**
 */
public static void glp_mpl_build_prob(glp_tran tran, glp_prob prob) {
    GLPKJNI.glp_mpl_build_prob(glp_tran.getCPtr(tran), tran, glp_prob.getCPtr(prob), prob);
  }

  
/**
 */
public static int glp_mpl_postsolve(glp_tran tran, glp_prob prob, int sol) {
    return GLPKJNI.glp_mpl_postsolve(glp_tran.getCPtr(tran), tran, glp_prob.getCPtr(prob), prob, sol);
  }

  
/**
 */
public static void glp_mpl_free_wksp(glp_tran tran) {
    GLPKJNI.glp_mpl_free_wksp(glp_tran.getCPtr(tran), tran);
  }

  
/**
 */
public static int glp_read_cnfsat(glp_prob P, String fname) {
    return GLPKJNI.glp_read_cnfsat(glp_prob.getCPtr(P), P, fname);
  }

  
/**
 */
public static int glp_check_cnfsat(glp_prob P) {
    return GLPKJNI.glp_check_cnfsat(glp_prob.getCPtr(P), P);
  }

  
/**
 */
public static int glp_write_cnfsat(glp_prob P, String fname) {
    return GLPKJNI.glp_write_cnfsat(glp_prob.getCPtr(P), P, fname);
  }

  
/**
 */
public static int glp_minisat1(glp_prob P) {
    return GLPKJNI.glp_minisat1(glp_prob.getCPtr(P), P);
  }

  
/**
 */
public static int glp_intfeas1(glp_prob P, int use_bound, int obj_bound) {
    return GLPKJNI.glp_intfeas1(glp_prob.getCPtr(P), P, use_bound, obj_bound);
  }

  
/**
 * glp_init_env - initialize GLPK environment .
 * <p>SYNOPSIS</p>
 * <p>int glp_init_env(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_init_env initializes the GLPK environment. Normally the application program does not need to call this routine, because it is called automatically on the first call to any API routine.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_init_env returns one of the following codes:</p>
 * <p>0 - initialization successful; 1 - environment has been already initialized; 2 - initialization failed (insufficient memory); 3 - initialization failed (unsupported programming model). </p>
 */
public static int glp_init_env() {
    return GLPKJNI.glp_init_env();
  }

  
/**
 * glp_version - determine library version .
 * <p>SYNOPSIS</p>
 * <p>const char *glp_version(void);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_version returns a pointer to a null-terminated character string, which specifies the version of the GLPK library in the form "X.Y", where X is the major version number, and Y is the minor version number, for example, "4.16". </p>
 */
public static String glp_version() {
    return GLPKJNI.glp_version();
  }

  public static String glp_config(String option) {
    return GLPKJNI.glp_config(option);
  }

  
/**
 * glp_free_env - free GLPK environment .
 * <p>SYNOPSIS</p>
 * <p>int glp_free_env(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_free_env frees all resources used by GLPK routines (memory blocks, etc.) which are currently still in use.</p>
 * <p>Normally the application program does not need to call this routine, because GLPK routines always free all unused resources. However, if the application program even has deleted all problem objects, there will be several memory blocks still allocated for the library needs. For some reasons the application program may want GLPK to free this memory, in which case it should call glp_free_env.</p>
 * <p>Note that a call to glp_free_env invalidates all problem objects as if no GLPK routine were called.</p>
 * <p>RETURNS</p>
 * <p>0 - termination successful; 1 - environment is inactive (was not initialized). </p>
 */
public static int glp_free_env() {
    return GLPKJNI.glp_free_env();
  }

  
/**
 * glp_puts - write string on terminal .
 * <p>SYNOPSIS</p>
 * <p>void glp_puts(const char *s);</p>
 * <p>The routine glp_puts writes the string s on the terminal. </p>
 */
public static void glp_puts(String s) {
    GLPKJNI.glp_puts(s);
  }

  
/**
 * glp_printf - write formatted output on terminal .
 * <p>SYNOPSIS</p>
 * <p>void glp_printf(const char *fmt, ...);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_printf uses the format control string fmt to format its parameters and writes the formatted output on the terminal. </p>
 */
public static void glp_printf(String fmt) {
    GLPKJNI.glp_printf(fmt);
  }

  
/**
 * glp_vprintf - write formatted output on terminal .
 * <p>SYNOPSIS</p>
 * <p>void glp_vprintf(const char *fmt, va_list arg);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_vprintf uses the format control string fmt to format its parameters specified by the list arg and writes the formatted output on the terminal. </p>
 */
public static void glp_vprintf(String fmt, SWIGTYPE_p_va_list arg) {
    GLPKJNI.glp_vprintf(fmt, SWIGTYPE_p_va_list.getCPtr(arg));
  }

  
/**
 * glp_term_out - enable/disable terminal output .
 * <p>SYNOPSIS</p>
 * <p>int glp_term_out(int flag);</p>
 * <p>DESCRIPTION</p>
 * <p>Depending on the parameter flag the routine glp_term_out enables or disables terminal output performed by glpk routines:</p>
 * <p>GLP_ON - enable terminal output; GLP_OFF - disable terminal output.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_term_out returns the previous value of the terminal output flag. </p>
 */
public static int glp_term_out(int flag) {
    return GLPKJNI.glp_term_out(flag);
  }

  
/**
 * glp_term_hook - install hook to intercept terminal output .
 * <p>SYNOPSIS</p>
 * <p>void glp_term_hook(int (*func)(void *info, const char *s), void *info);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_term_hook installs a user-defined hook routine to intercept all terminal output performed by glpk routines.</p>
 * <p>This feature can be used to redirect the terminal output to other destination, for example to a file or a text window.</p>
 * <p>The parameter func specifies the user-defined hook routine. It is called from an internal printing routine, which passes to it two parameters: info and s. The parameter info is a transit pointer, specified in the corresponding call to the routine glp_term_hook; it may be used to pass some information to the hook routine. The parameter s is a pointer to the null terminated character string, which is intended to be written to the terminal. If the hook routine returns zero, the printing routine writes the string s to the terminal in a usual way; otherwise, if the hook routine returns non-zero, no terminal output is performed.</p>
 * <p>To uninstall the hook routine the parameters func and info should be specified as NULL. </p>
 */
public static void glp_term_hook(SWIGTYPE_p_f_p_void_p_q_const__char__int func, SWIGTYPE_p_void info) {
    GLPKJNI.glp_term_hook(SWIGTYPE_p_f_p_void_p_q_const__char__int.getCPtr(func), SWIGTYPE_p_void.getCPtr(info));
  }

  
/**
 * glp_open_tee - start copying terminal output to text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_open_tee(const char *name);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_open_tee starts copying all the terminal output to an output text file, whose name is specified by the character string name.</p>
 * <p>RETURNS</p>
 * <p>0 - operation successful 1 - copying terminal output is already active 2 - unable to create output file </p>
 */
public static int glp_open_tee(String name) {
    return GLPKJNI.glp_open_tee(name);
  }

  
/**
 * glp_close_tee - stop copying terminal output to text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_close_tee(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_close_tee stops copying the terminal output to the output text file previously open by the routine glp_open_tee closing that file.</p>
 * <p>RETURNS</p>
 * <p>0 - operation successful 1 - copying terminal output was not started </p>
 */
public static int glp_close_tee() {
    return GLPKJNI.glp_close_tee();
  }

  
/**
 */
public static SWIGTYPE_p_f_p_q_const__char_v_______void glp_error_(String file, int line) {
    long cPtr = GLPKJNI.glp_error_(file, line);
    return (cPtr == 0) ? null : new SWIGTYPE_p_f_p_q_const__char_v_______void(cPtr, false);
  }

  
/**
 * glp_at_error - check for error state .
 * <p>SYNOPSIS</p>
 * <p>int glp_at_error(void);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_at_error checks if the GLPK environment is at error state, i.e. if the call to the routine is (indirectly) made from the glp_error routine via an user-defined hook routine.</p>
 * <p>RETURNS</p>
 * <p>If the GLPK environment is at error state, the routine glp_at_error returns non-zero, otherwise zero. </p>
 */
public static int glp_at_error() {
    return GLPKJNI.glp_at_error();
  }

  
/**
 * glp_assert - check for logical condition .
 * <p>SYNOPSIS</p>
 * <p>void glp_assert(int expr);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_assert (implemented as a macro) checks for a logical condition specified by the parameter expr. If the condition is false (i.e. the value of expr is zero), the routine writes a message on the terminal and abnormally terminates the program. </p>
 */
public static void glp_assert_(String expr, String file, int line) {
    GLPKJNI.glp_assert_(expr, file, line);
  }

  
/**
 * glp_error_hook - install hook to intercept abnormal termination .
 * <p>SYNOPSIS</p>
 * <p>void glp_error_hook(void (*func)(void *info), void *info);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_error_hook installs a user-defined hook routine to intercept abnormal termination.</p>
 * <p>The parameter func specifies the user-defined hook routine. It is called from the routine glp_error before the latter calls the abort function to abnormally terminate the application program because of fatal error. The parameter info is a transit pointer, specified in the corresponding call to the routine glp_error_hook; it may be used to pass some information to the hook routine.</p>
 * <p>To uninstall the hook routine the parameters func and info should be both specified as NULL. </p>
 */
public static void glp_error_hook(SWIGTYPE_p_f_p_void__void func, SWIGTYPE_p_void info) {
    GLPKJNI.glp_error_hook(SWIGTYPE_p_f_p_void__void.getCPtr(func), SWIGTYPE_p_void.getCPtr(info));
  }

  
/**
 * glp_alloc - allocate memory block .
 * <p>SYNOPSIS</p>
 * <p>void *glp_alloc(int n, int size);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_alloc allocates a memory block of n * size bytes long.</p>
 * <p>Note that being allocated the memory block contains arbitrary data (not binary zeros!).</p>
 * <p>RETURNS</p>
 * <p>The routine glp_alloc returns a pointer to the block allocated. To free this block the routine glp_free (not free!) must be used. </p>
 */
public static SWIGTYPE_p_void glp_alloc(int n, int size) {
    long cPtr = GLPKJNI.glp_alloc(n, size);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  
/**
 */
public static SWIGTYPE_p_void glp_realloc(SWIGTYPE_p_void ptr, int n, int size) {
    long cPtr = GLPKJNI.glp_realloc(SWIGTYPE_p_void.getCPtr(ptr), n, size);
    return (cPtr == 0) ? null : new SWIGTYPE_p_void(cPtr, false);
  }

  
/**
 * glp_free - free (deallocate) memory block .
 * <p>SYNOPSIS</p>
 * <p>void glp_free(void *ptr);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_free frees (deallocates) a memory block pointed to by ptr, which was previuosly allocated by the routine glp_alloc or reallocated by the routine glp_realloc. </p>
 */
public static void glp_free(SWIGTYPE_p_void ptr) {
    GLPKJNI.glp_free(SWIGTYPE_p_void.getCPtr(ptr));
  }

  
/**
 * glp_mem_limit - set memory usage limit .
 * <p>SYNOPSIS</p>
 * <p>void glp_mem_limit(int limit);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_mem_limit limits the amount of memory available for dynamic allocation (in GLPK routines) to limit megabytes. </p>
 */
public static void glp_mem_limit(int limit) {
    GLPKJNI.glp_mem_limit(limit);
  }

  
/**
 * glp_mem_usage - get memory usage information .
 * <p>SYNOPSIS</p>
 * <p>void glp_mem_usage(int *count, int *cpeak, size_t *total, size_t *tpeak);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_mem_usage reports some information about utilization of the memory by GLPK routines. Information is stored to locations specified by corresponding parameters (see below). Any parameter can be specified as NULL, in which case its value is not stored.</p>
 * <p>*count is the number of the memory blocks currently allocated by the routines glp_malloc and glp_calloc (one call to glp_malloc or glp_calloc results in allocating one memory block).</p>
 * <p>*cpeak is the peak value of *count reached since the initialization of the GLPK library environment.</p>
 * <p>*total is the total amount, in bytes, of the memory blocks currently allocated by the routines glp_malloc and glp_calloc.</p>
 * <p>*tpeak is the peak value of *total reached since the initialization of the GLPK library envirionment. </p>
 */
public static void glp_mem_usage(SWIGTYPE_p_int count, SWIGTYPE_p_int cpeak, SWIGTYPE_p_size_t total, SWIGTYPE_p_size_t tpeak) {
    GLPKJNI.glp_mem_usage(SWIGTYPE_p_int.getCPtr(count), SWIGTYPE_p_int.getCPtr(cpeak), SWIGTYPE_p_size_t.getCPtr(total), SWIGTYPE_p_size_t.getCPtr(tpeak));
  }

  
/**
 */
public static double glp_time() {
    return GLPKJNI.glp_time();
  }

  
/**
 * glp_difftime - compute difference between two time values .
 * <p>SYNOPSIS</p>
 * <p>double glp_difftime(double t1, double t0);</p>
 * <p>RETURNS</p>
 * <p>The routine glp_difftime returns the difference between two time values t1 and t0, expressed in seconds. </p>
 */
public static double glp_difftime(double t1, double t0) {
    return GLPKJNI.glp_difftime(t1, t0);
  }

  
/**
 */
public static glp_graph glp_create_graph(int v_size, int a_size) {
    long cPtr = GLPKJNI.glp_create_graph(v_size, a_size);
    return (cPtr == 0) ? null : new glp_graph(cPtr, false);
  }

  
/**
 * glp_set_graph_name - assign (change) graph name .
 * <p>SYNOPSIS</p>
 * <p>void glp_set_graph_name(glp_graph *G, const char *name);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_set_graph_name assigns a symbolic name specified by the character string name (1 to 255 chars) to the graph.</p>
 * <p>If the parameter name is NULL or an empty string, the routine erases the existing symbolic name of the graph. </p>
 */
public static void glp_set_graph_name(glp_graph G, String name) {
    GLPKJNI.glp_set_graph_name(glp_graph.getCPtr(G), G, name);
  }

  
/**
 * glp_add_vertices - add new vertices to graph .
 * <p>SYNOPSIS</p>
 * <p>int glp_add_vertices(glp_graph *G, int nadd);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_add_vertices adds nadd vertices to the specified graph. New vertices are always added to the end of the vertex list, so ordinal numbers of existing vertices remain unchanged.</p>
 * <p>Being added each new vertex is isolated (has no incident arcs).</p>
 * <p>RETURNS</p>
 * <p>The routine glp_add_vertices returns an ordinal number of the first new vertex added to the graph. </p>
 */
public static int glp_add_vertices(glp_graph G, int nadd) {
    return GLPKJNI.glp_add_vertices(glp_graph.getCPtr(G), G, nadd);
  }

  
/**
 */
public static void glp_set_vertex_name(glp_graph G, int i, String name) {
    GLPKJNI.glp_set_vertex_name(glp_graph.getCPtr(G), G, i, name);
  }

  
/**
 * glp_add_arc - add new arc to graph .
 * <p>SYNOPSIS</p>
 * <p>glp_arc *glp_add_arc(glp_graph *G, int i, int j);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_add_arc adds a new arc to the specified graph.</p>
 * <p>The parameters i and j specify the ordinal numbers of, resp., tail and head vertices of the arc. Note that self-loops and multiple arcs are allowed.</p>
 * <p>RETURNS</p>
 * <p>The routine glp_add_arc returns a pointer to the arc added. </p>
 */
public static glp_arc glp_add_arc(glp_graph G, int i, int j) {
    long cPtr = GLPKJNI.glp_add_arc(glp_graph.getCPtr(G), G, i, j);
    return (cPtr == 0) ? null : new glp_arc(cPtr, false);
  }

  
/**
 * glp_del_vertices - delete vertices from graph .
 * <p>SYNOPSIS</p>
 * <p>void glp_del_vertices(glp_graph *G, int ndel, const int num[]);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_del_vertices deletes vertices along with all incident arcs from the specified graph. Ordinal numbers of vertices to be deleted should be placed in locations num[1], ..., num[ndel], ndel &gt; 0.</p>
 * <p>Note that deleting vertices involves changing ordinal numbers of other vertices remaining in the graph. New ordinal numbers of the remaining vertices are assigned under the assumption that the original order of vertices is not changed. </p>
 */
public static void glp_del_vertices(glp_graph G, int ndel, SWIGTYPE_p_int num) {
    GLPKJNI.glp_del_vertices(glp_graph.getCPtr(G), G, ndel, SWIGTYPE_p_int.getCPtr(num));
  }

  
/**
 * glp_del_arc - delete arc from graph .
 * <p>SYNOPSIS</p>
 * <p>void glp_del_arc(glp_graph *G, glp_arc *a);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_del_arc deletes an arc from the specified graph. The arc to be deleted must exist. </p>
 */
public static void glp_del_arc(glp_graph G, glp_arc a) {
    GLPKJNI.glp_del_arc(glp_graph.getCPtr(G), G, glp_arc.getCPtr(a), a);
  }

  
/**
 */
public static void glp_erase_graph(glp_graph G, int v_size, int a_size) {
    GLPKJNI.glp_erase_graph(glp_graph.getCPtr(G), G, v_size, a_size);
  }

  
/**
 * glp_delete_graph - delete graph .
 * <p>SYNOPSIS</p>
 * <p>void glp_delete_graph(glp_graph *G);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_delete_graph deletes the specified graph and frees all the memory allocated to this program object. </p>
 */
public static void glp_delete_graph(glp_graph G) {
    GLPKJNI.glp_delete_graph(glp_graph.getCPtr(G), G);
  }

  
/**
 */
public static void glp_create_v_index(glp_graph G) {
    GLPKJNI.glp_create_v_index(glp_graph.getCPtr(G), G);
  }

  
/**
 */
public static int glp_find_vertex(glp_graph G, String name) {
    return GLPKJNI.glp_find_vertex(glp_graph.getCPtr(G), G, name);
  }

  
/**
 */
public static void glp_delete_v_index(glp_graph G) {
    GLPKJNI.glp_delete_v_index(glp_graph.getCPtr(G), G);
  }

  
/**
 * glp_read_graph - read graph from plain text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_graph(glp_graph *G, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_graph reads a graph from a plain text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public static int glp_read_graph(glp_graph G, String fname) {
    return GLPKJNI.glp_read_graph(glp_graph.getCPtr(G), G, fname);
  }

  
/**
 * glp_write_graph - write graph to plain text file .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_graph(glp_graph *G, const char *fname).</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_graph writes the specified graph to a plain text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public static int glp_write_graph(glp_graph G, String fname) {
    return GLPKJNI.glp_write_graph(glp_graph.getCPtr(G), G, fname);
  }

  
/**
 * glp_mincost_lp - convert minimum cost flow problem to LP .
 * <p>SYNOPSIS</p>
 * <p>void glp_mincost_lp(glp_prob *lp, glp_graph *G, int names, int v_rhs, int a_low, int a_cap, int a_cost);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_mincost_lp builds an LP problem, which corresponds to the minimum cost flow problem on the specified network G. </p>
 */
public static void glp_mincost_lp(glp_prob P, glp_graph G, int names, int v_rhs, int a_low, int a_cap, int a_cost) {
    GLPKJNI.glp_mincost_lp(glp_prob.getCPtr(P), P, glp_graph.getCPtr(G), G, names, v_rhs, a_low, a_cap, a_cost);
  }

  
/**
 */
public static int glp_mincost_okalg(glp_graph G, int v_rhs, int a_low, int a_cap, int a_cost, SWIGTYPE_p_double sol, int a_x, int v_pi) {
    return GLPKJNI.glp_mincost_okalg(glp_graph.getCPtr(G), G, v_rhs, a_low, a_cap, a_cost, SWIGTYPE_p_double.getCPtr(sol), a_x, v_pi);
  }

  
/**
 */
public static int glp_mincost_relax4(glp_graph G, int v_rhs, int a_low, int a_cap, int a_cost, int crash, SWIGTYPE_p_double sol, int a_x, int a_rc) {
    return GLPKJNI.glp_mincost_relax4(glp_graph.getCPtr(G), G, v_rhs, a_low, a_cap, a_cost, crash, SWIGTYPE_p_double.getCPtr(sol), a_x, a_rc);
  }

  
/**
 * glp_maxflow_lp - convert maximum flow problem to LP .
 * <p>SYNOPSIS</p>
 * <p>void glp_maxflow_lp(glp_prob *lp, glp_graph *G, int names, int s, int t, int a_cap);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_maxflow_lp builds an LP problem, which corresponds to the maximum flow problem on the specified network G. </p>
 */
public static void glp_maxflow_lp(glp_prob P, glp_graph G, int names, int s, int t, int a_cap) {
    GLPKJNI.glp_maxflow_lp(glp_prob.getCPtr(P), P, glp_graph.getCPtr(G), G, names, s, t, a_cap);
  }

  
/**
 */
public static int glp_maxflow_ffalg(glp_graph G, int s, int t, int a_cap, SWIGTYPE_p_double sol, int a_x, int v_cut) {
    return GLPKJNI.glp_maxflow_ffalg(glp_graph.getCPtr(G), G, s, t, a_cap, SWIGTYPE_p_double.getCPtr(sol), a_x, v_cut);
  }

  
/**
 * glp_check_asnprob - check correctness of assignment problem data .
 * <p>SYNOPSIS</p>
 * <p>int glp_check_asnprob(glp_graph *G, int v_set);</p>
 * <p>RETURNS</p>
 * <p>If the specified assignment problem data are correct, the routine glp_check_asnprob returns zero, otherwise, non-zero. </p>
 */
public static int glp_check_asnprob(glp_graph G, int v_set) {
    return GLPKJNI.glp_check_asnprob(glp_graph.getCPtr(G), G, v_set);
  }

  
/**
 * glp_asnprob_lp - convert assignment problem to LP .
 * <p>SYNOPSIS</p>
 * <p>int glp_asnprob_lp(glp_prob *P, int form, glp_graph *G, int names, int v_set, int a_cost);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_asnprob_lp builds an LP problem, which corresponds to the assignment problem on the specified graph G.</p>
 * <p>RETURNS</p>
 * <p>If the LP problem has been successfully built, the routine returns zero, otherwise, non-zero. </p>
 */
public static int glp_asnprob_lp(glp_prob P, int form, glp_graph G, int names, int v_set, int a_cost) {
    return GLPKJNI.glp_asnprob_lp(glp_prob.getCPtr(P), P, form, glp_graph.getCPtr(G), G, names, v_set, a_cost);
  }

  
/**
 */
public static int glp_asnprob_okalg(int form, glp_graph G, int v_set, int a_cost, SWIGTYPE_p_double sol, int a_x) {
    return GLPKJNI.glp_asnprob_okalg(form, glp_graph.getCPtr(G), G, v_set, a_cost, SWIGTYPE_p_double.getCPtr(sol), a_x);
  }

  
/**
 * glp_asnprob_hall - find bipartite matching of maximum cardinality .
 * <p>SYNOPSIS</p>
 * <p>int glp_asnprob_hall(glp_graph *G, int v_set, int a_x);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_asnprob_hall finds a matching of maximal cardinality in the specified bipartite graph G. It uses a version of the Fortran routine MC21A developed by I.S.Duff [1], which implements Hall's algorithm [2].</p>
 * <p>RETURNS</p>
 * <p>The routine glp_asnprob_hall returns the cardinality of the matching found. However, if the specified graph is incorrect (as detected by the routine glp_check_asnprob), the routine returns negative value.</p>
 * <p>REFERENCES</p>
 * <p>
I.S.Duff, Algorithm 575: Permutations for zero-free diagonal, ACM Trans. on Math. Softw. 7 (1981), 387-390.M.Hall, "An Algorithm for distinct representatives," Amer. Math. Monthly 63 (1956), 716-717. 
</p>
 */
public static int glp_asnprob_hall(glp_graph G, int v_set, int a_x) {
    return GLPKJNI.glp_asnprob_hall(glp_graph.getCPtr(G), G, v_set, a_x);
  }

  
/**
 */
public static double glp_cpp(glp_graph G, int v_t, int v_es, int v_ls) {
    return GLPKJNI.glp_cpp(glp_graph.getCPtr(G), G, v_t, v_es, v_ls);
  }

  
/**
 * glp_read_mincost - read min-cost flow problem data in DIMACS format .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_mincost(glp_graph *G, int v_rhs, int a_low, int a_cap, int a_cost, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_mincost reads minimum cost flow problem data in DIMACS format from a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public static int glp_read_mincost(glp_graph G, int v_rhs, int a_low, int a_cap, int a_cost, String fname) {
    return GLPKJNI.glp_read_mincost(glp_graph.getCPtr(G), G, v_rhs, a_low, a_cap, a_cost, fname);
  }

  
/**
 * glp_write_mincost - write min-cost flow problem data in DIMACS format .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_mincost(glp_graph *G, int v_rhs, int a_low, int a_cap, int a_cost, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_mincost writes minimum cost flow problem data in DIMACS format to a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public static int glp_write_mincost(glp_graph G, int v_rhs, int a_low, int a_cap, int a_cost, String fname) {
    return GLPKJNI.glp_write_mincost(glp_graph.getCPtr(G), G, v_rhs, a_low, a_cap, a_cost, fname);
  }

  
/**
 * glp_read_maxflow - read maximum flow problem data in DIMACS format .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_maxflow(glp_graph *G, int *s, int *t, int a_cap, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_maxflow reads maximum flow problem data in DIMACS format from a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public static int glp_read_maxflow(glp_graph G, SWIGTYPE_p_int s, SWIGTYPE_p_int t, int a_cap, String fname) {
    return GLPKJNI.glp_read_maxflow(glp_graph.getCPtr(G), G, SWIGTYPE_p_int.getCPtr(s), SWIGTYPE_p_int.getCPtr(t), a_cap, fname);
  }

  
/**
 * glp_write_maxflow - write maximum flow problem data in DIMACS format .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_maxflow(glp_graph *G, int s, int t, int a_cap, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_maxflow writes maximum flow problem data in DIMACS format to a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public static int glp_write_maxflow(glp_graph G, int s, int t, int a_cap, String fname) {
    return GLPKJNI.glp_write_maxflow(glp_graph.getCPtr(G), G, s, t, a_cap, fname);
  }

  
/**
 * glp_read_asnprob - read assignment problem data in DIMACS format .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_asnprob(glp_graph *G, int v_set, int a_cost, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_asnprob reads assignment problem data in DIMACS format from a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public static int glp_read_asnprob(glp_graph G, int v_set, int a_cost, String fname) {
    return GLPKJNI.glp_read_asnprob(glp_graph.getCPtr(G), G, v_set, a_cost, fname);
  }

  
/**
 * glp_write_asnprob - write assignment problem data in DIMACS format .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_asnprob(glp_graph *G, int v_set, int a_cost, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_asnprob writes assignment problem data in DIMACS format to a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public static int glp_write_asnprob(glp_graph G, int v_set, int a_cost, String fname) {
    return GLPKJNI.glp_write_asnprob(glp_graph.getCPtr(G), G, v_set, a_cost, fname);
  }

  
/**
 * glp_read_ccdata - read graph in DIMACS clique/coloring format .
 * <p>SYNOPSIS</p>
 * <p>int glp_read_ccdata(glp_graph *G, int v_wgt, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_read_ccdata reads an (undirected) graph in DIMACS clique/coloring format from a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public static int glp_read_ccdata(glp_graph G, int v_wgt, String fname) {
    return GLPKJNI.glp_read_ccdata(glp_graph.getCPtr(G), G, v_wgt, fname);
  }

  
/**
 * glp_write_ccdata - write graph in DIMACS clique/coloring format .
 * <p>SYNOPSIS</p>
 * <p>int glp_write_ccdata(glp_graph *G, int v_wgt, const char *fname);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_write_ccdata writes the specified graph in DIMACS clique/coloring format to a text file.</p>
 * <p>RETURNS</p>
 * <p>If the operation was successful, the routine returns zero. Otherwise it prints an error message and returns non-zero. </p>
 */
public static int glp_write_ccdata(glp_graph G, int v_wgt, String fname) {
    return GLPKJNI.glp_write_ccdata(glp_graph.getCPtr(G), G, v_wgt, fname);
  }

  
/**
 */
public static int glp_netgen(glp_graph G, int v_rhs, int a_cap, int a_cost, SWIGTYPE_p_int parm) {
    return GLPKJNI.glp_netgen(glp_graph.getCPtr(G), G, v_rhs, a_cap, a_cost, SWIGTYPE_p_int.getCPtr(parm));
  }

  
/**
 */
public static void glp_netgen_prob(int nprob, SWIGTYPE_p_int parm) {
    GLPKJNI.glp_netgen_prob(nprob, SWIGTYPE_p_int.getCPtr(parm));
  }

  
/**
 */
public static int glp_gridgen(glp_graph G, int v_rhs, int a_cap, int a_cost, SWIGTYPE_p_int parm) {
    return GLPKJNI.glp_gridgen(glp_graph.getCPtr(G), G, v_rhs, a_cap, a_cost, SWIGTYPE_p_int.getCPtr(parm));
  }

  
/**
 */
public static int glp_rmfgen(glp_graph G, SWIGTYPE_p_int s, SWIGTYPE_p_int t, int a_cap, SWIGTYPE_p_int parm) {
    return GLPKJNI.glp_rmfgen(glp_graph.getCPtr(G), G, SWIGTYPE_p_int.getCPtr(s), SWIGTYPE_p_int.getCPtr(t), a_cap, SWIGTYPE_p_int.getCPtr(parm));
  }

  
/**
 * glp_weak_comp - find all weakly connected components of graph .
 * <p>SYNOPSIS</p>
 * <p>int glp_weak_comp(glp_graph *G, int v_num);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_weak_comp finds all weakly connected components of the specified graph.</p>
 * <p>The parameter v_num specifies an offset of the field of type int in the vertex data block, to which the routine stores the number of a (weakly) connected component containing that vertex. If v_num &lt; 0, no component numbers are stored.</p>
 * <p>The components are numbered in arbitrary order from 1 to nc, where nc is the total number of components found, 0 &lt;= nc &lt;= |V|.</p>
 * <p>RETURNS</p>
 * <p>The routine returns nc, the total number of components found. </p>
 */
public static int glp_weak_comp(glp_graph G, int v_num) {
    return GLPKJNI.glp_weak_comp(glp_graph.getCPtr(G), G, v_num);
  }

  
/**
 * glp_strong_comp - find all strongly connected components of graph .
 * <p>SYNOPSIS</p>
 * <p>int glp_strong_comp(glp_graph *G, int v_num);</p>
 * <p>DESCRIPTION</p>
 * <p>The routine glp_strong_comp finds all strongly connected components of the specified graph.</p>
 * <p>The parameter v_num specifies an offset of the field of type int in the vertex data block, to which the routine stores the number of a strongly connected component containing that vertex. If v_num &lt; 0, no component numbers are stored.</p>
 * <p>The components are numbered in arbitrary order from 1 to nc, where nc is the total number of components found, 0 &lt;= nc &lt;= |V|. However, the component numbering has the property that for every arc (i-&gt;j) in the graph the condition num(i) &gt;= num(j) holds.</p>
 * <p>RETURNS</p>
 * <p>The routine returns nc, the total number of components found. </p>
 */
public static int glp_strong_comp(glp_graph G, int v_num) {
    return GLPKJNI.glp_strong_comp(glp_graph.getCPtr(G), G, v_num);
  }

  
/**
 */
public static int glp_top_sort(glp_graph G, int v_num) {
    return GLPKJNI.glp_top_sort(glp_graph.getCPtr(G), G, v_num);
  }

  
/**
 */
public static int glp_wclique_exact(glp_graph G, int v_wgt, SWIGTYPE_p_double sol, int v_set) {
    return GLPKJNI.glp_wclique_exact(glp_graph.getCPtr(G), G, v_wgt, SWIGTYPE_p_double.getCPtr(sol), v_set);
  }

}
