/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxCellHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxParagraphHelper;

public class DocxTableHelper
extends BaseHelper {
    private CutsInfo xCuts;
    private DocxCellHelper cellHelper;
    private DocxParagraphHelper paragraphHelper;

    protected DocxTableHelper(Writer writer, CutsInfo xCuts, boolean pageBreak) {
        super(writer);
        this.xCuts = xCuts;
        this.cellHelper = new DocxCellHelper(writer);
        this.paragraphHelper = new DocxParagraphHelper(writer, pageBreak);
    }

    public DocxCellHelper getCellHelper() {
        return this.cellHelper;
    }

    public DocxParagraphHelper getParagraphHelper() {
        return this.paragraphHelper;
    }

    public void exportHeader() {
        this.write("  <w:tbl>\n");
        this.write("   <w:tblPr>\n");
        this.write("    <w:tblLayout w:type=\"fixed\"/>\n");
        this.write("   </w:tblPr>\n");
        this.write("   <w:tblGrid>\n");
        for (int col = 1; col < this.xCuts.size(); ++col) {
            this.write("    <w:gridCol w:w=\"" + LengthUtil.twip(this.xCuts.getCut(col) - this.xCuts.getCut(col - 1)) + "\"/>\n");
        }
        this.write("   </w:tblGrid>\n");
    }

    public void exportFooter(boolean lastPage, int pageWidth, int pageHeight) {
        this.write("  </w:tbl>\n");
        if (lastPage) {
            this.write("    <w:p>\n");
            this.write("    <w:pPr>\n");
            this.write("  <w:sectPr>\n");
            this.write("   <w:pgSz w:w=\"" + LengthUtil.twip(pageWidth) + "\" w:h=\"" + LengthUtil.twip(pageHeight) + "\" />\n");
            this.write("   <w:pgMar w:top=\"0\" w:right=\"0\" w:bottom=\"0\" w:left=\"0\" w:header=\"0\" w:footer=\"0\" w:gutter=\"0\" />\n");
            this.write("   <w:docGrid w:linePitch=\"360\" />\n");
            this.write("  </w:sectPr>\n");
            this.write("    </w:pPr>\n");
            this.write("    </w:p>\n");
        }
    }

    public void exportRowHeader(int rowHeight, boolean allowRowResize) {
        this.write("   <w:tr>\n");
        this.write("    <w:trPr>\n");
        this.write("     <w:trHeight w:hRule=\"" + (allowRowResize ? "atLeast" : "exact") + "\" w:val=\"" + LengthUtil.twip(rowHeight) + "\" />\n");
        this.write("    </w:trPr>\n");
    }

    public void exportRowFooter() {
        this.write("   </w:tr>\n");
    }

    public void exportEmptyCell(JRExporterGridCell gridCell, int emptyCellColSpan) {
        this.write("    <w:tc>\n");
        this.write("     <w:tcPr>\n");
        if (emptyCellColSpan > 1) {
            this.write("      <w:gridSpan w:val=\"" + emptyCellColSpan + "\" />\n");
        }
        if (gridCell != null) {
            this.cellHelper.exportProps(gridCell);
        }
        this.write("     </w:tcPr>\n");
        this.paragraphHelper.exportEmptyParagraph();
        this.write("    </w:tc>\n");
    }

    public void exportOccupiedCells(JRExporterGridCell gridCell) {
        this.write("    <w:tc>\n");
        this.write("     <w:tcPr>\n");
        if (gridCell.getColSpan() > 1) {
            this.write("      <w:gridSpan w:val=\"" + gridCell.getColSpan() + "\" />\n");
        }
        this.write("      <w:vMerge w:val=\"continue\" />\n");
        this.cellHelper.exportProps(gridCell.getElement(), gridCell);
        this.write("     </w:tcPr>\n");
        this.paragraphHelper.exportEmptyParagraph();
        this.cellHelper.exportFooter();
    }
}

